/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import miningmart.compiler.Column;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.Scaling;

public class LinearScaling
extends Scaling {
    public Value getNewRangeMax() {
        return (Value)this.getSingleParameter("NewRangeMax", this.getCurrentLoopNumber());
    }

    public Value getNewRangeMin() {
        return (Value)this.getSingleParameter("NewRangeMin", this.getCurrentLoopNumber());
    }

    public String generateSQL(Column targetAttributeColumn) throws M4CompilerError {
        String actMin = targetAttributeColumn.getMinValue();
        String actMax = targetAttributeColumn.getMaxValue();
        if (actMin == null) {
            actMin = this.getM4Db().readOrComputeMinimum(targetAttributeColumn);
        }
        if (actMax == null) {
            actMax = this.getM4Db().readOrComputeMaximum(targetAttributeColumn);
        }
        return "( ((" + targetAttributeColumn.getSQLPlusLocation() + " - " + actMin + ") / " + "(" + actMax + " - " + actMin + ")) * " + "(" + this.getNewRangeMax().getValue() + " - " + this.getNewRangeMin().getValue() + ") + " + this.getNewRangeMin().getValue() + ")";
    }
}

