/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.util.Arrays;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Columnset;
import miningmart.compiler.Concept;
import miningmart.compiler.Feature;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.Step;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.SingleCSOperator;

public class JoinByKey
extends SingleCSOperator {
    private String listOfColumnSets;
    private String condition;
    private BaseAttribute[] sortedKeys;
    private Concept[] sortedConcepts;

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        return "(select " + selectPart + " from " + this.createListOfColumnSets() + " where " + this.createCondition() + ")";
    }

    /*
     * Unable to fully structure code
     */
    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        columnExpr = "";
        inF = null;
        iIn = 0;
        outF = null;
        iOut = 0;
        mapping = this.getInOutMap();
        iOut = 0;
        while (iOut < this.getOutputConcept().getFeatures().length) {
            block16: {
                outF = this.getOutputConcept().getFeature(iOut);
                conceptNumber = 0;
                mapPos = this.checkOccurrence(mapping, outF);
                if (mapPos <= -1) break block16;
                inF = mapping[0][mapPos];
                ** GOTO lbl-1000
            }
            do {
                currentConcept = this.getSortedConcepts()[conceptNumber];
                iIn = 0;
                do {
                    inF = currentConcept.getFeature(iIn);
                } while (++iIn < currentConcept.getFeatures().length && !outF.correspondsTo(inF));
            } while (++conceptNumber < this.sortedConcepts.length && !outF.correspondsTo(inF));
            if (!outF.correspondsTo(inF)) {
                this.doPrint(12, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because no corresponding input feature was found.");
            } else if (this.isDeselectedParameter(inF)) {
                this.doPrint(6, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because the corresponding input feature was deselected by " + "a FeatureSelection operator.");
            } else if (outF instanceof BaseAttribute) {
                inBA = (BaseAttribute)inF;
                outBA = (BaseAttribute)outF;
                inputColumn = inBA.getCurrentColumn();
                outputColumn = inputColumn.copyColTo(csForOutputConcept);
                outputColumn.setBaseAttribute(outBA);
                outBA.addColumn(outputColumn);
                outputColumn.setSQLDefinition(outBA.getName());
                outputColumn.setName(outBA.getName());
                nextAttrib = "";
                if (inputColumn.getSQLDefinition().equalsIgnoreCase(inputColumn.getName())) {
                    nextAttrib = String.valueOf(inputColumn.getColumnSet().getSchemaPlusName()) + ".";
                }
                nextAttrib = String.valueOf(nextAttrib) + inputColumn.getSQLDefinition() + " " + outBA.getName();
                columnExpr = String.valueOf(columnExpr) + nextAttrib + ", ";
            } else {
                if (!(outF instanceof MultiColumnFeature)) {
                    throw new M4CompilerError("Unknown Feature type found in Concept with id: " + this.getOutputConcept().getId() + "; Feature id: " + outF.getId());
                }
                outMCF = (MultiColumnFeature)outF;
                inMCF = (MultiColumnFeature)inF;
                theBAs = outMCF.getBaseAttributes();
                if (theBAs != null) {
                    try {
                        i = 0;
                        while (i < theBAs.length) {
                            outBA = theBAs[i];
                            inBA = inMCF.getBaseAttributes()[i];
                            inputColumn = inBA.getCurrentColumn();
                            outputColumn = inputColumn.copyColTo(csForOutputConcept);
                            outputColumn.setBaseAttribute(outBA);
                            outBA.addColumn(outputColumn);
                            outputColumn.setSQLDefinition(outBA.getName());
                            outputColumn.setName(outBA.getName());
                            nextAttrib = String.valueOf(inputColumn.getColumnSet().getSchemaPlusName()) + "." + inputColumn.getSQLDefinition() + " " + outBA.getName();
                            columnExpr = String.valueOf(columnExpr) + nextAttrib + ", ";
                            ++i;
                        }
                    }
                    catch (NullPointerException nfe) {
                        throw new M4CompilerError("JoinByKey Operator: Mismatch between MultiColumnFeatures in in- and output concept!");
                    }
                    catch (ArrayIndexOutOfBoundsException aie) {
                        throw new M4CompilerError("JoinByKey Operator: Mismatch between MultiColumnFeatures in in- and output concept!");
                    }
                }
            }
            ++iOut;
        }
        columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
        return columnExpr;
    }

    protected void setNewCSMultiStepBranch(Columnset newCS, int index) throws M4CompilerError {
        Concept[] theConcepts = this.getSortedConcepts();
        Object[] msbArray = new String[theConcepts.length + 1];
        int i = 0;
        while (i < theConcepts.length) {
            String msb = theConcepts[i].getCurrentColumnSet().getMultiStepBranch();
            msbArray[i++] = JoinByKey.nullToEmpty(msb);
        }
        msbArray[i] = JoinByKey.nullToEmpty(this.getInputConcept().getCurrentColumnSet().getMultiStepBranch());
        Arrays.sort(msbArray);
        newCS.setMultiStepBranch("");
        i = 0;
        while (i < msbArray.length) {
            newCS.addMultiStepBranch((String)msbArray[i]);
            ++i;
        }
    }

    private int getNumberOfLoops() {
        int loops = this.getHighestLoopNr();
        return loops;
    }

    public Concept getInputConcept() {
        return this.getSortedConcepts()[0];
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return false;
    }

    protected Concept[] getSortedConcepts() {
        return this.sortedConcepts;
    }

    protected BaseAttribute[] getSortedKeys() {
        return this.sortedKeys;
    }

    protected Feature[][] getInOutMap() throws M4CompilerError {
        int noOfMappings = this.getNumberOfLoops();
        Feature[][] theMap = new Feature[2][noOfMappings];
        int l = 0;
        while (l < noOfMappings) {
            theMap[0][l] = (Feature)this.getSingleParameter("MapInput", l);
            theMap[1][l] = (Feature)this.getSingleParameter("MapOutput", l);
            if (theMap[0][l] == null || theMap[1][l] == null) {
                throw new M4CompilerError("Operator JoinByKey: mapping information is incomplete!");
            }
            ++l;
        }
        return theMap;
    }

    private int checkOccurrence(Feature[][] map, Feature f) {
        int i = 0;
        while (i < map[1].length) {
            if (map[1][i].getId() == f.getId()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String createListOfColumnSets() throws M4CompilerError {
        String list = "";
        int i = 0;
        while (i < this.getSortedConcepts().length) {
            Columnset cs = this.getSortedConcepts()[i].getCurrentColumnSet();
            list = String.valueOf(list) + cs.getSchemaPlusName() + ", ";
            ++i;
        }
        list = list.substring(0, list.length() - 2);
        return list;
    }

    private String createCondition() throws M4CompilerError {
        Columnset cs = this.getSortedConcepts()[0].getCurrentColumnSet();
        BaseAttribute key = this.getSortedKeys()[0];
        int noOfCons = this.getSortedConcepts().length;
        String cond = String.valueOf(cs.getSchemaPlusName()) + "." + key.getCurrentColumn().getSQLDefinition();
        cond = String.valueOf(cond) + " = ";
        int i = 1;
        while (i < noOfCons - 1) {
            cs = this.getSortedConcepts()[i].getCurrentColumnSet();
            key = this.getSortedKeys()[i];
            cond = String.valueOf(cond) + cs.getSchemaPlusName() + "." + key.getCurrentColumn().getSQLDefinition();
            cond = String.valueOf(cond) + " AND ";
            cond = String.valueOf(cond) + cs.getSchemaPlusName() + "." + key.getCurrentColumn().getSQLDefinition();
            cond = String.valueOf(cond) + " = ";
            ++i;
        }
        cs = this.getSortedConcepts()[noOfCons - 1].getCurrentColumnSet();
        key = this.getSortedKeys()[noOfCons - 1];
        cond = String.valueOf(cond) + cs.getSchemaPlusName() + "." + key.getCurrentColumn().getSQLDefinition();
        return cond;
    }

    private void relateKeysToConcepts() throws M4CompilerError {
        BaseAttribute[] keys = (BaseAttribute[])this.getParameter("TheKeys");
        this.sortedConcepts = (Concept[])this.getParameter("TheConcepts");
        if (keys == null || keys.length == 0) {
            throw new M4CompilerError("Operator JoinByKey: No keys found!");
        }
        if (this.sortedConcepts == null || this.sortedConcepts.length == 0) {
            throw new M4CompilerError("Operator JoinByKey: No concepts found!");
        }
        if (this.sortedConcepts.length != keys.length) {
            throw new M4CompilerError("Operator JoinByKey: Number of keys must be equal to number of concepts!");
        }
        this.sortedKeys = new BaseAttribute[keys.length];
        int i = 0;
        while (i < this.sortedConcepts.length) {
            this.sortedKeys[i] = keys[this.findKeyPosition(this.sortedConcepts[i], keys)];
            ++i;
        }
    }

    private int findKeyPosition(Concept c, BaseAttribute[] bas) throws M4CompilerError {
        Feature[] theConceptFeatures = c.getFeatures();
        if (theConceptFeatures == null || theConceptFeatures.length == 0) {
            throw new M4CompilerError("Operator JoinByKey: concept '" + c.getName() + "' has no features!");
        }
        int j = 0;
        while (j < bas.length) {
            int i = 0;
            while (i < theConceptFeatures.length) {
                if (bas[j].getId() == theConceptFeatures[i].getId()) {
                    return j;
                }
                ++i;
            }
            ++j;
        }
        throw new M4CompilerError("Operator JoinByKey: concept '" + c.getName() + "' does not contain any of the given keys!");
    }

    public void load(Step st) throws M4CompilerError {
        super.load(st);
        this.relateKeysToConcepts();
    }
}

