/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Feature;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.FeatureConstruction;

public class GenericFeatureConstruction
extends FeatureConstruction {
    private BaseAttribute[] outputBAs = null;
    private static String NO_COLUMN_ATTACHED = "< *** No Column *** >";

    public String generateSQL(Column targetColumn) throws M4CompilerError {
        String translated = this.getTranslatedSQL_String();
        this.doPrint(12, translated);
        return translated;
    }

    private boolean isOutputBA(BaseAttribute ba) {
        int i;
        if (this.outputBAs == null) {
            this.outputBAs = new BaseAttribute[this.getHighestLoopNr()];
            i = 0;
            while (i < this.getHighestLoopNr()) {
                this.outputBAs[i] = (BaseAttribute)this.getSingleParameter("TheOutputAttribute", i);
                ++i;
            }
        }
        i = 0;
        while (i < this.getHighestLoopNr()) {
            if (this.outputBAs[i].getId() == ba.getId()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getTranslatedSQL_String() throws M4CompilerError {
        HashMap allMappings = this.getBaColumnMapping();
        String untranslatedSql = this.getSqlString();
        StringBuffer translated = new StringBuffer();
        int i = 0;
        while (i < untranslatedSql.length()) {
            int stop;
            int start = GenericFeatureConstruction.nextLetter(untranslatedSql, i);
            if (start > i) {
                translated.append(untranslatedSql.substring(i, start));
            }
            if ((stop = GenericFeatureConstruction.nextNotNameChar(untranslatedSql, start)) > start) {
                String token = untranslatedSql.substring(start, stop);
                String column = (String)allMappings.get(token.toUpperCase());
                if (column == NO_COLUMN_ATTACHED) {
                    throw new M4CompilerError("Operator GenericFeatureConstruction: An error occured when trying to apply the following Pseudo-SQL statement:\n" + untranslatedSql + "\nBaseAttribute " + token + " has no valid column!");
                }
                translated.append(column == null ? token : column);
            }
            i = stop;
        }
        return translated.toString();
    }

    private HashMap getBaColumnMapping() throws M4CompilerError {
        HashMap<String, String> allMappings = new HashMap<String, String>();
        Vector allBaseAttribs = this.getAllInputConceptBAs();
        Iterator it = ((AbstractList)allBaseAttribs).iterator();
        while (it.hasNext()) {
            BaseAttribute ba = (BaseAttribute)it.next();
            if (this.isOutputBA(ba)) continue;
            String baName = ba.getName();
            if (allMappings.containsKey(baName)) {
                throw new M4CompilerError("Operator GenericFeatureConstruction: found more than one BaseAttribute '" + baName + "' in TheInputConcept!");
            }
            Column col = ba.getCurrentColumn();
            if (col != null) {
                String colName = col.getSQLDefinition();
                allMappings.put(baName.toUpperCase(), colName);
                continue;
            }
            allMappings.put(baName.toUpperCase(), NO_COLUMN_ATTACHED);
        }
        return allMappings;
    }

    private static int nextLetter(String s, int start) {
        int length = s.length();
        int i = start >= 0 ? start : 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                return i;
            }
            if (c == '\'' && i + 1 < length && (i = s.indexOf(39, i + 1)) == -1) {
                i = length;
            }
            ++i;
        }
        return length;
    }

    private static int nextNotNameChar(String s, int start) {
        int length = s.length();
        int i = start >= 0 ? start : 0;
        while (i < length) {
            char c = s.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_')) {
                return i;
            }
            ++i;
        }
        return length;
    }

    private Vector getAllInputConceptBAs() throws M4CompilerError {
        Vector<BaseAttribute> allBaseAttribs = new Vector<BaseAttribute>();
        Feature[] fs = this.getTheInputConcept().getFeatures();
        int i = 0;
        while (i < fs.length) {
            if (fs[i] instanceof BaseAttribute) {
                allBaseAttribs.add((BaseAttribute)fs[i]);
            } else {
                BaseAttribute[] theBAs = ((MultiColumnFeature)fs[i]).getBaseAttributes();
                int j = 0;
                while (j < theBAs.length) {
                    allBaseAttribs.add(theBAs[j]);
                    ++j;
                }
            }
            ++i;
        }
        return allBaseAttribs;
    }

    public String getSqlString() {
        Value v = (Value)this.getSingleParameter("SQL_String", this.getCurrentLoopNumber());
        return v.getValue();
    }
}

