/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Feature;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.DB_SVM_CL;
import miningmart.compiler.operator.FeatureSelection;
import miningmart.compiler.operator.SVM_CL;
import miningmart.compiler.operator.SVM_Wrapper;

public class FeatureSelectionWithSVM
extends FeatureSelection {
    private SVM_Wrapper mysvm = null;
    private boolean useDatabaseSVM = false;

    protected Feature[] computeListOfAttributes(Feature[] theSuperset) throws M4CompilerError {
        Value v = this.mustUseDatabaseSVM();
        if (v != null) {
            this.useDatabaseSVM = v.getValue().equalsIgnoreCase("true");
        }
        this.prepareSVM();
        Feature[] bestSubset = this.search(theSuperset);
        return bestSubset;
    }

    private void prepareSVM() {
        block8: {
            try {
                long sample;
                Value v;
                BaseAttribute keyBA = this.getKey();
                String key = null;
                if (keyBA != null) {
                    key = keyBA.getCurrentColumn().getName();
                }
                if ((v = this.getPositiveTarget()) == null) {
                    throw new M4CompilerError("Operator FeatureSelectionWithSVM: Need parameter 'PositiveTargetValue'!");
                }
                String positiveTargetValue = v.getValue();
                Value sa = this.getSampleSize();
                if (sa == null) {
                    if (!this.useDatabaseSVM) {
                        throw new M4CompilerError("FeatureSelectionWithSVM: parameter 'SampleSize' must be specified if SVM outside database is used!");
                    }
                    this.mysvm = new DB_SVM_CL(this.getM4Db(), this.getM4Db().getCompilerAccessLogic().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), key, positiveTargetValue);
                    break block8;
                }
                try {
                    sample = Long.parseLong(sa.getValue());
                }
                catch (NumberFormatException nfe) {
                    throw new M4CompilerError("FeatureSelectionWithSVM: SampleSize must be an integer! Found: " + v.getValue());
                }
                this.mysvm = this.useDatabaseSVM ? new DB_SVM_CL(this.getM4Db(), this.getM4Db().getCompilerAccessLogic().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), key, sample, positiveTargetValue) : new SVM_CL(this.getM4Db(), this.getM4Db().getCompilerAccessLogic().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), sample, positiveTargetValue);
            }
            catch (Exception e) {
                this.doPrint(20, "Error with SVM for FeatureSelection: " + e.getMessage());
            }
        }
    }

    private String getPrefixForDatabaseObjects() throws M4CompilerError {
        return this.getInputConcept().getCurrentColumnSet().getName();
    }

    private Feature[] search(Feature[] theSet) throws M4CompilerError {
        Vector best;
        Vector<Feature> all = new Vector<Feature>();
        int i = 0;
        while (i < theSet.length) {
            all.add(theSet[i]);
            ++i;
        }
        all.trimToSize();
        if (this.getDirection().getValue().equalsIgnoreCase("forward")) {
            Vector empty = new Vector(0);
            best = this.searchForward(empty, all, -1.0);
        } else {
            best = this.searchBackward(all, -1.0);
        }
        Feature[] bestSubset = new Feature[best.size()];
        String theNames = "";
        int i2 = 0;
        while (i2 < bestSubset.length) {
            bestSubset[i2] = (Feature)best.get(i2);
            theNames = String.valueOf(theNames) + bestSubset[i2].getName() + ", ";
            ++i2;
        }
        theNames = theNames.substring(0, theNames.length() - 2);
        this.doPrint(12, "FSwithSVM: selected the following features: " + theNames);
        return bestSubset;
    }

    private Vector searchBackward(Vector current, double currentPerformance) throws M4CompilerError {
        if (current.size() == 1) {
            return current;
        }
        if (currentPerformance == -1.0) {
            this.doPrint(12, "FSwithSVM: evaluating all features...");
            currentPerformance = this.getSVMEstimation(current);
        }
        Vector bestDaughter = current;
        double bestPerformance = -1.0;
        this.doPrint(12, "Trying all sets of " + (current.size() - 1) + " features.");
        int i = 0;
        while (i < current.size()) {
            Vector daughter = this.removeIndexedFeature(current, i);
            double daughterPerformance = this.getSVMEstimation(daughter);
            if (daughterPerformance > bestPerformance) {
                bestPerformance = daughterPerformance;
                bestDaughter = daughter;
            }
            ++i;
        }
        if (bestPerformance >= currentPerformance) {
            return this.searchBackward(bestDaughter, bestPerformance);
        }
        return current;
    }

    private Vector searchForward(Vector current, Vector all, double currentPerformance) throws M4CompilerError {
        if (current.size() == all.size()) {
            return current;
        }
        if (currentPerformance == -1.0 && !current.isEmpty()) {
            currentPerformance = this.getSVMEstimation(current);
        }
        Vector bestDaughter = current;
        double bestPerformance = -1.0;
        this.doPrint(12, "FSwithSVM: forward search on level " + current.size() + "...");
        int i = 0;
        while (i < all.size()) {
            double daughterPerformance;
            Vector daughter = this.addIndexedFeature(current, all, i);
            if (daughter != null && (daughterPerformance = this.getSVMEstimation(daughter)) > bestPerformance) {
                bestPerformance = daughterPerformance;
                bestDaughter = daughter;
            }
            ++i;
        }
        if (bestPerformance > currentPerformance) {
            this.doPrint(12, "FSwithSVM: best performance on this level was estimated: " + bestPerformance);
            return this.searchForward(bestDaughter, all, bestPerformance);
        }
        this.doPrint(12, "FSwithSVM: returned from this level with estimation: " + currentPerformance);
        return current;
    }

    private double getSVMEstimation(Vector theFeatures) throws M4CompilerError {
        Columnset theColumnSet = this.getInputConcept().getCurrentColumnSet();
        Vector<String> theColNames = new Vector<String>();
        int i = 0;
        while (i < theFeatures.size()) {
            Feature f = (Feature)theFeatures.get(i);
            if (f instanceof BaseAttribute) {
                BaseAttribute ba = (BaseAttribute)f;
                theColNames.add(ba.getCurrentColumn().getName());
            } else {
                MultiColumnFeature mcf = (MultiColumnFeature)f;
                BaseAttribute[] theBAs = mcf.getBaseAttributes();
                int j = 0;
                while (j < theBAs.length) {
                    theColNames.add(theBAs[j].getCurrentColumn().getName());
                    ++j;
                }
            }
            ++i;
        }
        theColNames.trimToSize();
        Column theTargetAttributeColumn = this.getTheTargetAttribute().getCurrentColumn();
        this.mysvm.callSVM(theColumnSet.getSchemaPlusName(), theTargetAttributeColumn.getName(), this.getInputConcept().getId(), this.getC().getValue(), this.getKernelType().getValue(), this.getEpsilon().getValue(), theColNames);
        return this.mysvm.getXiAlphaEstimation();
    }

    private Vector addIndexedFeature(Vector to, Vector from, int index) {
        Object o = from.get(index);
        if (to.contains(o)) {
            return null;
        }
        Vector v = new Vector();
        int i = 0;
        while (i < to.size()) {
            v.add(to.get(i));
            ++i;
        }
        v.add(o);
        v.trimToSize();
        return v;
    }

    private Vector removeIndexedFeature(Vector from, int index) {
        Vector v = new Vector();
        int i = 0;
        while (i < from.size()) {
            if (i != index) {
                v.add(from.get(i));
            }
            ++i;
        }
        v.trimToSize();
        return v;
    }

    private Value getDirection() {
        return (Value)this.getSingleParameter("SearchDirection");
    }

    private Value getPositiveTarget() {
        return (Value)this.getSingleParameter("PositiveTargetValue");
    }

    private Value getSampleSize() {
        return (Value)this.getSingleParameter("SampleSize");
    }

    private Value getC() {
        return (Value)this.getSingleParameter("C");
    }

    private BaseAttribute getKey() {
        return (BaseAttribute)this.getSingleParameter("TheKey");
    }

    private BaseAttribute getTheTargetAttribute() {
        return (BaseAttribute)this.getSingleParameter("TheTargetAttribute");
    }

    private Value getEpsilon() {
        return (Value)this.getSingleParameter("Epsilon");
    }

    private Value getKernelType() {
        return (Value)this.getSingleParameter("KernelType");
    }

    private Value getLossFunctionNeg() {
        return (Value)this.getSingleParameter("LossFunctionNeg");
    }

    private Value getLossFunctionPos() {
        return (Value)this.getSingleParameter("LossFunctionPos");
    }

    private Value mustUseDatabaseSVM() {
        return (Value)this.getSingleParameter("UseDB_SVM");
    }
}

