/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Concept;
import miningmart.compiler.OpParam;
import miningmart.compiler.Step;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.exception.ParameterDeselectedError;
import miningmart.compiler.operator.Operator;

public abstract class FeatureConstruction
extends Operator {
    private Column[] theOutputColumns;
    private String[] generatedSQLDefinitions;
    private int numberOfLoops;
    private int currentLoopNr = 0;
    private boolean targetAttribDeselected = false;

    /*
     * Unable to fully structure code
     */
    public void load(Step st) throws M4CompilerError {
        block3: {
            try {
                super.load(st);
                break block3;
            }
            catch (ParameterDeselectedError e) {
                violated = e.getViolatedOpParams();
                it = violated.iterator();
                ** while (it.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                op = (OpParam)it.next();
                if (this.handleParameterDeselected(op)) continue;
                throw e;
            }
        }
        this.currentLoopNr = 0;
        this.theOutputColumns = new Column[this.getNumberOfLoops()];
        this.generatedSQLDefinitions = new String[this.getNumberOfLoops()];
    }

    private boolean handleParameterDeselected(OpParam op) {
        this.targetAttribDeselected = op.getParamName().equals("TheTargetAttribute");
        return this.targetAttribDeselected;
    }

    public void execute(boolean lazy) throws M4CompilerError, SQLException {
        if (this.targetAttribDeselected) {
            this.print();
        } else {
            super.execute(lazy);
        }
    }

    public void createStatement(boolean lazy) throws SQLException, M4CompilerError {
        this.currentLoopNr = 0;
        while (this.currentLoopNr < this.getNumberOfLoops()) {
            this.theOutputColumns[this.currentLoopNr] = this.generateColumnForOp();
            this.generatedSQLDefinitions[this.currentLoopNr] = this.theOutputColumns[this.currentLoopNr].getSQLDefinition();
            ++this.currentLoopNr;
        }
    }

    public void compileStatement() throws SQLException, M4CompilerError {
        int i = 0;
        while (i < this.getNumberOfLoops()) {
            long oldDataType = this.theOutputColumns[i].getColumnDataType();
            long newDataType = this.getM4Db().testSQLColumn(this.theOutputColumns[i]);
            if (newDataType != oldDataType) {
                this.doPrint(12, "Warning: FeatureConstruction: OutputAttribute Column is of different datatype than TargetAttribute Column.");
                this.theOutputColumns[i].setColumnDataTypeName(this.getNameForColumnDataType(newDataType));
            }
            this.theOutputColumns[i].setColumnDataType(newDataType);
            ++i;
        }
    }

    public void writeResults() throws M4CompilerError {
        try {
            int i = 0;
            while (i < this.getNumberOfLoops()) {
                this.getM4Db().writeNewColumnToM4(this.theOutputColumns[i], this.getStep().getId());
                this.getM4Db().commitM4Transactions();
                ++i;
            }
        }
        catch (SQLException e) {
            try {
                this.getM4Db().rollbackOnM4();
            }
            catch (SQLException e2) {
                throw new M4CompilerError("FeatureConstruction: An SQL error occurred when writing results: " + e.getMessage() + "\n, and another SQL error occurred when trying to roll back the DB: " + e2.getMessage());
            }
            throw new M4CompilerError("FeatureConstruction: An SQL error occurred when writing results: " + e.getMessage());
        }
        catch (M4CompilerError e) {
            try {
                this.getM4Db().rollbackOnM4();
            }
            catch (SQLException e2) {
                throw new M4CompilerError("FeatureConstruction: An SQL error occurred when writing results: " + e.getMessage() + "\n, and another SQL error occurred when trying to roll back the DB: " + e2.getMessage());
            }
            throw new M4CompilerError("FeatureConstruction: An error occurred when writing results: " + e.getMessage());
        }
    }

    public Column generateColumnForOp() throws M4CompilerError {
        Column newCol = new Column(this.getM4Db());
        newCol.setId(0L);
        BaseAttribute theBA = this.getTheOutputAttribute();
        newCol.setBaseAttribute(theBA);
        this.getTheOutputAttribute().addColumn(newCol);
        newCol.setName(this.getTheOutputAttribute().getName());
        Column theTargetAttributeColumn = null;
        theTargetAttributeColumn = this.getTheTargetAttribute().getCurrentColumn();
        newCol.setColumnSet(theTargetAttributeColumn.getColumnSet());
        theTargetAttributeColumn.getColumnSet().addColumn(newCol);
        newCol.setColumnDataType(theTargetAttributeColumn.getColumnDataType());
        newCol.setColumnDataTypeName(theTargetAttributeColumn.getColumnDataTypeName());
        newCol.setSQLDefinition(this.generateSQL(theTargetAttributeColumn));
        return newCol;
    }

    public abstract String generateSQL(Column var1) throws M4CompilerError;

    public int getNumberOfLoops() {
        int loops = this.getHighestLoopNr();
        return loops > 0 ? loops : 1;
    }

    public int getCurrentLoopNumber() {
        return this.currentLoopNr;
    }

    public Concept getTheInputConcept() {
        return (Concept)this.getSingleParameter("TheInputConcept");
    }

    public BaseAttribute getTheOutputAttribute() {
        return this.getTheOutputAttribute(this.getCurrentLoopNumber());
    }

    public BaseAttribute getTheTargetAttribute() {
        return this.getTheTargetAttribute(this.getCurrentLoopNumber());
    }

    public BaseAttribute getTheOutputAttribute(int loopNr) {
        return (BaseAttribute)this.getSingleParameter("TheOutputAttribute", loopNr);
    }

    public BaseAttribute getTheTargetAttribute(int loopNr) {
        return (BaseAttribute)this.getSingleParameter("TheTargetAttribute", loopNr);
    }

    private String getNameForColumnDataType(long type) throws M4CompilerError {
        if (type == 12L) {
            return "NUMBER";
        }
        if (type == 13L) {
            return "STRING";
        }
        if (type == 14L) {
            return "DATE";
        }
        if (type == 15L) {
            return "KEY";
        }
        throw new M4CompilerError("FeatureConstruction: Found unknown column data type number: " + type);
    }
}

