/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.TimeOperator;
import miningmart.compiler.utils.DB;

public class ExponentialMovingFunction
extends TimeOperator {
    private static final String INPUTTIMEBA = "InputTimeBA";
    private static final String INPUTVALUEBA = "InputValueBA";
    private static final String OUTPUTTIMEBA = "OutputTimeBA";
    private static final String OUTPUTVALUEBA = "OutputValueBA";
    private static final String HEADWEIGHT = "HeadWeight";
    private static final String TAILWEIGHT = "TailWeight";
    private static final String DISTANCE = "Distance";
    private static final String procedureName = "EMA";
    private static final String columnSetSuffix = "_CS";

    protected String getColumnSetSuffix() {
        return columnSetSuffix;
    }

    public BaseAttribute getTimeBaIn() {
        return (BaseAttribute)this.getSingleParameter(INPUTTIMEBA);
    }

    public BaseAttribute getValueBaIn() {
        return (BaseAttribute)this.getSingleParameter(INPUTVALUEBA);
    }

    public BaseAttribute getTimeBaOut() {
        return (BaseAttribute)this.getSingleParameter(OUTPUTTIMEBA);
    }

    public BaseAttribute getValueBaOut() {
        return (BaseAttribute)this.getSingleParameter(OUTPUTVALUEBA);
    }

    public Value getHeadWeight() {
        return (Value)this.getSingleParameter(HEADWEIGHT);
    }

    public Value getTailWeight() {
        return (Value)this.getSingleParameter(TAILWEIGHT);
    }

    public Value getDistance() {
        return (Value)this.getSingleParameter(DISTANCE);
    }

    protected void createJavaColumns(Columnset newCS) throws SQLException, M4CompilerError {
        Column timeColumnForType = this.getTimeBaIn().getColumn(0);
        this.createM4Column(this.getTimeBaOut(), newCS, timeColumnForType);
        Column valueColumnForType = this.getValueBaIn().getColumn(0);
        this.createM4Column(this.getValueBaOut(), newCS, valueColumnForType);
    }

    protected void runStoredProcedure(String newColumnsetName) throws SQLException, M4CompilerError {
        this.valueIsDouble(this.getHeadWeight(), HEADWEIGHT);
        this.valueIsDouble(this.getTailWeight(), TAILWEIGHT);
        this.valueIsLong(this.getDistance(), DISTANCE);
        this.baseattribHasColumns(this.getTimeBaIn(), INPUTTIMEBA);
        this.baseattribHasColumns(this.getValueBaIn(), INPUTVALUEBA);
        String[] parameters = new String[]{TimeOperator.getQuotedColSetNameforCon(this.getInputConcept()), TimeOperator.getQuotedColNameforInpBA(this.getTimeBaIn()), TimeOperator.getQuotedColNameforInpBA(this.getValueBaIn()), DB.quote(newColumnsetName), TimeOperator.getQuotedColNameforOutBA(this.getTimeBaOut()), TimeOperator.getQuotedColNameforOutBA(this.getValueBaOut()), this.getHeadWeight().getValue().trim(), this.getTailWeight().getValue().trim(), this.getDistance().getValue().trim()};
        this.getM4Db().executeDBProcedure(procedureName, parameters, true);
    }
}

