/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import miningmart.compiler.Column;
import miningmart.compiler.ValueCount;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.MissingValues;
import miningmart.compiler.utils.DB;

public class AssignStochasticValue
extends MissingValues {
    public String generateValueForOp(Column columnWithMissingValues) throws M4CompilerError {
        ValueCount[] theValues = columnWithMissingValues.getValueDistribution();
        if (theValues == null) {
            try {
                this.doPrint(12, "Computing value distribution for TheTargetAttribute for AssignStochasticValue...");
                this.getM4Db().updateColumnStatistics(columnWithMissingValues, this.getTheTargetAttribute().getConceptualDataType());
                columnWithMissingValues.readStatisticsFromDB();
                theValues = columnWithMissingValues.getValueDistribution();
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("AssignStochasticValue: error when computing statistics for column with missing values: " + sqle.getMessage());
            }
        }
        if (theValues == null || theValues.length == 0) {
            throw new M4CompilerError("AssignStochasticValue: TheTargetAttribute (" + this.getTheTargetAttribute().getName() + ") has no values! Compilation aborted");
        }
        StringBuffer stringBuffer = new StringBuffer("FUNCTION ").append(this.getFunctionName()).append(" (cROWNUM IN NUMBER) ").append(" RETURN ").append(columnWithMissingValues.getColumnDataTypeName()).append(" AS \n").append("  returnVal ").append(columnWithMissingValues.getColumnDataTypeName()).append(";\n").append("  r NUMBER(38,10);\n").append("begin\n").append(" --- Generate a Random Number between 1 and nr of rows\n").append("  r := m4randomnr(");
        this.getM4Db();
        String missingValueFunction = stringBuffer.append(DB.getRandomSeedNr()).append(", cROWNUM, ").append(columnWithMissingValues.getColumnSet().getStatisticsAll()).append(");\n").toString();
        long covered = 0L;
        int i = 0;
        while (i < theValues.length - 1) {
            missingValueFunction = String.valueOf(missingValueFunction) + "IF r < " + (covered += (long)theValues[i].getCount()) + " THEN returnVal := " + theValues[i].getValue() + ";\n" + " ELS";
            ++i;
        }
        covered += (long)theValues[theValues.length - 1].getCount();
        missingValueFunction = String.valueOf(missingValueFunction) + "E returnVal := " + theValues[theValues.length - 1].getValue() + ";\n" + "END IF; " + " return(returnVal);\n" + "end;\n";
        this.doPrint(12, "Installing Stochastic Missing Value Function:");
        try {
            this.getM4Db().createSQLFunction(missingValueFunction);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("AssignStochasticValue: could not create the following sql function: " + missingValueFunction + "; got SQL error: " + sqle.getMessage());
        }
        return String.valueOf(this.getFunctionName()) + "(ROWNUM)";
    }

    private String getFunctionName() {
        return "mv_" + this.getTheOutputAttribute().getId();
    }
}

