/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.SingleCSOperator;
import miningmart.compiler.utils.DB;

public class Apriori
extends SingleCSOperator {
    private static final String APRIORI_FILENAME = "apriori";
    private static final String RESULT_SUFFIX_SETS = ".sets";
    private static final String RESULT_SUFFIX_RULES = ".rules";
    private static final String NEW_COLDT_NAME = "STRING";
    private static final short NEW_COL_DT = 13;

    private String getSampleFileName() {
        return "apriori-sample_" + this.getStep().getId();
    }

    private String getRulesFileName() {
        return String.valueOf(this.getSampleFileName()) + RESULT_SUFFIX_RULES;
    }

    private String getSetsFileName() {
        return String.valueOf(this.getSampleFileName()) + RESULT_SUFFIX_SETS;
    }

    protected Columnset createSingleColumnSet(int index) throws M4CompilerError {
        try {
            String columnSetName = this.getNewCSName();
            this.callApriori(String.valueOf(this.getInputConcept().getCurrentColumnSet().getSchema()) + "." + columnSetName, this.getAprioriCommand());
            Columnset newCS = this.createJavaColumnset(columnSetName);
            this.createJavaColumns(newCS);
            long step = this.getStep().getId();
            String schema = this.getInputConcept().getCurrentColumnSet().getSchema();
            this.getM4Db().addTableToTrash(columnSetName, schema, step);
            this.setNewCSMultiStepBranch(newCS, index);
            return newCS;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("TimeOperator: SQL error: " + sqle.getMessage());
        }
    }

    private Columnset createJavaColumnset(String columnSetName) throws SQLException, M4CompilerError {
        Columnset newCS = new Columnset(this.getM4Db());
        newCS.setId(0L);
        newCS.setName(columnSetName);
        Columnset inputColumnSet = this.getInputConcept().getCurrentColumnSet();
        newCS.setSchema(inputColumnSet.getSchema());
        newCS.setType(this.getTypeOfNewColumnSet());
        newCS.setSQLDefinition(columnSetName);
        newCS.setConcept(this.getOutputConcept());
        newCS.setMultiStepBranch(inputColumnSet.getMultiStepBranch());
        return newCS;
    }

    private void createJavaColumns(Columnset newCS) throws SQLException, M4CompilerError {
        this.createM4Column(this.getPremiseBA(), newCS, this.getNewColNamePremise());
        this.createM4Column(this.getConclusionBA(), newCS, this.getNewColNameConclusion());
    }

    protected Column createM4Column(BaseAttribute outputBA, Columnset newCS, String newColumnName) throws SQLException, M4CompilerError {
        Column newColumn = new Column(this.getM4Db());
        newColumn.setId(0L);
        newColumn.setName(newColumnName);
        newColumn.setColumnSet(newCS);
        newColumn.setBaseAttribute(outputBA);
        newColumn.setColumnDataType(13L);
        newColumn.setColumnDataTypeName(NEW_COLDT_NAME);
        newColumn.setSQLDefinition(newColumnName);
        outputBA.addColumn(newColumn);
        newCS.addColumn(newColumn);
        return newColumn;
    }

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        return null;
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return false;
    }

    private String getNewColNamePremise() {
        return this.getPremiseBA().getName();
    }

    private String getNewColNameConclusion() {
        return this.getConclusionBA().getName();
    }

    private String getAprioriPath() throws M4CompilerError {
        String osName;
        String runtime = System.getProperty("ML_HOME");
        if (runtime == null || runtime.length() == 0) {
            throw new M4CompilerError("Operator Apriori: Missing environment variable 'ML_HOME' !\nUnable to find the binary!");
        }
        String prop = System.getProperty("os.name");
        if (prop.substring(0, 3).equalsIgnoreCase("win")) {
            osName = "Windows";
        } else {
            if (!prop.equals("SunOS") && !prop.equals("Linux")) {
                throw new M4CompilerError("Apriori-Wrapper: No implementation found for your operating system.\nCurrently supported: SunOS, Linux and Windows.\nInstall Apriori for your Operating System and change the method getAprioriPath in class 'Apriori.java'.Your operating system is: " + System.getProperty("os.name"));
            }
            osName = prop;
        }
        String sp = File.separator;
        return String.valueOf(runtime) + "bin" + sp + osName + sp;
    }

    private String getAprioriCommand() throws M4CompilerError {
        return String.valueOf(this.getAprioriPath()) + APRIORI_FILENAME;
    }

    private String getTempDir() throws M4CompilerError {
        String tmp = System.getProperty("TEMP_DIR");
        if (tmp == null || tmp.length() == 0) {
            tmp = this.getAprioriPath();
        }
        return tmp;
    }

    private void callApriori(String newCsName, String command) throws M4CompilerError {
        String inputCS = this.getInputConcept().getCurrentColumnSet().getName();
        String inCustCol = this.getCustomerIdBa().getCurrentColumn().getName();
        String inTidCol = this.getTransIdBa().getCurrentColumn().getName();
        String inItemCol = this.getItemBa().getCurrentColumn().getName();
        String sql_FromWhereCond = " FROM " + inputCS + " WHERE (" + inCustCol + " IS NOT NULL) AND (" + inTidCol + " IS NOT NULL) AND (" + inItemCol + " IS NOT NULL)";
        String sampleRatio = this.getSampleRatio(sql_FromWhereCond);
        String sampleFileName = String.valueOf(this.getTempDir()) + this.getSampleFileName();
        this.writeSampleToFile(sampleFileName, sampleRatio, sql_FromWhereCond, inCustCol, inTidCol, inItemCol);
        this.runBinary(command, this.getTempDir(), this.getSampleFileName());
        this.doPrint(12, "Removing duplicates from association rules array.");
        String resultRulesFile = String.valueOf(this.getTempDir()) + this.getRulesFileName();
        String resultSetsFile = String.valueOf(this.getTempDir()) + this.getSetsFileName();
        Collection rules = this.parseRules(this.openResultFile(resultRulesFile));
        this.writeResultsToTable(rules, newCsName);
        this.deleteFile(sampleFileName);
        this.deleteFile(resultRulesFile);
        this.deleteFile(resultSetsFile);
    }

    private String getSampleRatio(String sql_FromWhereCond) throws M4CompilerError {
        String sql_getNumberOfRecords = "SELECT count(*) " + sql_FromWhereCond;
        long count = 0L;
        try {
            Long countL = this.getM4Db().executeBusinessSingleValueSqlReadL(sql_getNumberOfRecords);
            if (countL == null) {
                throw new M4CompilerError("Wrapper for Apriori: Could not read result from query: " + sql_getNumberOfRecords);
            }
            count = countL;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Wrapper for Apriori: Could not read result from query: " + sql_getNumberOfRecords + ", Database problem: " + sqle.getMessage());
        }
        double sampleSize = this.getSampleSize();
        double sampleRatioD = sampleSize > (double)count ? 1.0 : sampleSize / (double)count;
        return Long.toString((long)(sampleRatioD * 1000000.0));
    }

    private void writeSampleToFile(String sampleFileName, String sampleRatio, String sql_FromWhereCond, String inCustCol, String inTidCol, String inItemCol) throws M4CompilerError {
        String columns = String.valueOf(inCustCol) + ", " + inTidCol + ", " + inItemCol;
        String artCol = this.getArtificalColumnName(columns);
        String artCol2 = String.valueOf(artCol) + "2";
        String artCol3 = String.valueOf(artCol) + "3";
        String artCol4 = String.valueOf(artCol) + "4";
        columns = String.valueOf(inCustCol) + " " + artCol2 + ", " + inTidCol + " " + artCol3 + ", " + inItemCol + " " + artCol4;
        String random = "M4RandomSelect(" + DB.getRandomSeedNr() + ", ROWNUM, " + sampleRatio + ")";
        String sql_getData = "SELECT " + artCol2 + ", " + artCol3 + ", " + artCol4 + " FROM (SELECT " + columns + ", " + random + " " + artCol + sql_FromWhereCond + ") WHERE " + artCol + " = 1";
        try {
            ResultSet rs = this.getM4Db().executeBusinessSqlRead(sql_getData);
            FileWriter fw = new FileWriter(sampleFileName);
            PrintWriter out = new PrintWriter(new BufferedWriter(fw));
            while (rs.next()) {
                String custId = rs.getString(artCol2);
                String TidId = rs.getString(artCol3);
                String Item = rs.getString(artCol4);
                out.println(String.valueOf(custId) + " " + TidId + " " + Item);
            }
            rs.close();
            out.close();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error in Apriori Wrapper when trying to read a sample from DB:\n" + sqle.getMessage());
        }
        catch (IOException e) {
            throw new M4CompilerError("Error in Apriori Wrapper when trying to write a DB sample to file:\n" + e.getMessage());
        }
    }

    private void runBinary(String command, String execDir, String dataFileName) throws M4CompilerError {
        block9: {
            String[] cmdArray = new String[]{command, this.getSampleFileName(), Long.toString(this.getMinSupport()), Double.toString(this.getMinConfidence()), "-ascii", "-print"};
            Process process = null;
            this.doPrint(12, "Starting external algorithm (Apriori) (command: '" + command + "')...");
            try {
                try {
                    String line;
                    process = Runtime.getRuntime().exec(cmdArray, null, new File(execDir));
                    this.doPrint(0, "\n--- Apriori binary output: ---");
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = in.readLine()) != null) {
                        this.doPrint(0, line);
                    }
                    this.doPrint(0, "------------------------------\n");
                    try {
                        int exitCode = process.exitValue();
                        this.doPrint(12, "Call to " + command + " exited with" + (exitCode == 0 ? "out errors." : " error code " + exitCode));
                    }
                    catch (IllegalThreadStateException e) {
                        throw new M4CompilerError("IllegalThreadStateException caught after Apriori has closed stdout.\n" + e.getMessage());
                    }
                }
                catch (IOException ioe) {
                    throw new M4CompilerError("Error accessing Apriori binary: " + ioe.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (process != null) {
                    process.destroy();
                }
                throw throwable;
            }
            Object var11_13 = null;
            if (process == null) break block9;
            process.destroy();
        }
    }

    private Collection parseRules(BufferedReader in) throws M4CompilerError {
        TreeSet<String> hs = new TreeSet<String>();
        try {
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    int[][] rule = this.readRuleFromLine(line);
                    int[] pr = rule[0];
                    int[] ant = rule[1];
                    StringBuffer sbuf = new StringBuffer("('");
                    int i = 0;
                    while (i < pr.length - 1) {
                        sbuf.append(String.valueOf(pr[i]) + " ");
                        ++i;
                    }
                    if (pr.length > 0) {
                        sbuf.append(pr[pr.length - 1]);
                    }
                    sbuf.append("', '");
                    i = 0;
                    while (i < ant.length - 1) {
                        sbuf.append(String.valueOf(ant[i]) + " ");
                        ++i;
                    }
                    if (ant.length > 0) {
                        sbuf.append(ant[ant.length - 1]);
                    }
                    sbuf.append("')");
                    hs.add(sbuf.toString());
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                in.close();
                throw throwable;
            }
            Object var10_12 = null;
            in.close();
            return hs;
        }
        catch (IOException e) {
            throw new M4CompilerError("Apriori-Wrapper: Could not read from successfully opened result file after call to binary.\nException message is:\n" + e.getMessage());
        }
    }

    private void writeResultsToTable(Collection rules, String tableName) throws M4CompilerError {
        try {
            this.createTable(tableName);
            String insertPrefix = "INSERT INTO " + tableName + " (" + this.getNewColNamePremise() + ", " + this.getNewColNameConclusion() + ") VALUES ";
            Iterator it = rules.iterator();
            while (it.hasNext()) {
                String sqlCommand = String.valueOf(insertPrefix) + (String)it.next();
                this.getM4Db().executeBusinessSqlWrite(sqlCommand);
            }
            this.getM4Db().commitBusinessTransactions();
            this.doPrint(12, "Results were successfully written to database table '" + tableName + "'.");
        }
        catch (SQLException e) {
            throw new M4CompilerError("An exception occured when trying to write Apriori results to a database table:\n" + e.getMessage());
        }
    }

    private void createTable(String tableName) throws SQLException, M4CompilerError {
        this.getM4Db().dropBusinessTable(tableName);
        String cmd = "CREATE TABLE " + tableName + " (" + this.getNewColNamePremise() + " VARCHAR(1000), " + this.getNewColNameConclusion() + " VARCHAR(1000) )";
        this.getM4Db().executeBusinessSqlWrite(cmd);
    }

    private BufferedReader openResultFile(String fileName) throws M4CompilerError {
        try {
            return new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            throw new M4CompilerError("Apriori Wrapper: Could not open result file '" + fileName + "' after execution of binary.\nException message is:\n" + e.getMessage());
        }
    }

    private int[] readSetFromLine(String line) {
        int stop;
        int start;
        if (line == null || (start = line.indexOf(123)) == -1 || (stop = line.indexOf(125, start)) == -1) {
            return null;
        }
        String setString = line.substring(start + 1, stop);
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (true) {
            if (i < setString.length() && Character.isWhitespace(setString.charAt(i))) {
                ++i;
                continue;
            }
            int j = i;
            while (j < setString.length() && !Character.isWhitespace(setString.charAt(j))) {
                ++j;
            }
            if (j > i) {
                v.add(setString.substring(i, j));
                i = j;
            }
            if (i >= setString.length()) break;
        }
        int[] r = new int[v.size()];
        i = 0;
        Iterator it = ((AbstractList)v).iterator();
        while (it.hasNext()) {
            r[i++] = Integer.parseInt((String)it.next());
        }
        Arrays.sort(r);
        return r;
    }

    /*
     * WARNING - void declaration
     */
    private int[][] readRuleFromLine(String line) {
        void var2_2;
        int index;
        if (line == null || (index = line.indexOf("->")) == -1) {
            return null;
        }
        String left = line.substring(0, (int)var2_2);
        String right = line.substring((int)(var2_2 + 2));
        int[][] r = new int[][]{this.readSetFromLine(left), this.readSetFromLine(right)};
        return r;
    }

    private void deleteFile(String fileName) {
        File f = new File(fileName);
        f.delete();
    }

    public BaseAttribute getCustomerIdBa() {
        return (BaseAttribute)this.getSingleParameter("CustID");
    }

    public BaseAttribute getTransIdBa() {
        return (BaseAttribute)this.getSingleParameter("TransID");
    }

    public BaseAttribute getItemBa() {
        return (BaseAttribute)this.getSingleParameter("Item");
    }

    public long getMinSupport() throws M4CompilerError {
        Long l;
        Value v = (Value)this.getSingleParameter("MinSupport");
        if (v != null && (l = v.getLong()) != null && l >= 0L) {
            long minSup = l;
            return minSup;
        }
        throw new M4CompilerError("Operator Apriori: Parameter 'MinSupport' must be a positive integer!\nFound: " + (v == null ? "<null>" : v.getValue()));
    }

    public double getMinConfidence() throws M4CompilerError {
        Double d;
        Value v = (Value)this.getSingleParameter("MinConfidence");
        if (v != null && (d = v.getDouble()) != null && 0.0 <= d && d <= 1.0) {
            return d;
        }
        throw new M4CompilerError("Operator Apriori: Parameter 'MinConfidence' must be a double value in [0, 1] !\nFound: " + (v == null ? "<null>" : v.getValue()));
    }

    public double getSampleSize() throws M4CompilerError {
        Long l;
        Value v = (Value)this.getSingleParameter("SampleSize");
        if (v != null && (l = v.getLong()) != null && l > 0L) {
            double sampleSize = l.longValue();
            return sampleSize;
        }
        throw new M4CompilerError("Operator Apriori: Parameter 'SampleSize' must be a positive integer!\nFound: " + (v == null ? "<null>" : v.getValue()));
    }

    public BaseAttribute getPremiseBA() {
        return (BaseAttribute)this.getSingleParameter("PremiseBA");
    }

    public BaseAttribute getConclusionBA() {
        return (BaseAttribute)this.getSingleParameter("ConclusionBA");
    }
}

