/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.sql.SQLException;
import miningmart.compiler.M4Object;
import miningmart.compiler.Parameter;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.utils.DB;

public class Value
extends Parameter {
    private long myType;
    private String myValue;

    public Value(DB m4Db) {
        super(m4Db);
    }

    public M4Object load(long valId) throws SQLException, M4CompilerError {
        this.myId = valId;
        this.getM4Db().readValueFromDB(this);
        return this;
    }

    public void print() {
        super.print();
        this.doPrint(4, "Value (Id = " + this.myId + ";" + " Type = " + this.myType + ") = " + this.myValue);
    }

    public void setType(long t) {
        this.myType = t;
    }

    public long getType() {
        return this.myType;
    }

    public void setValue(String v) {
        this.myValue = v;
    }

    public String getValue() {
        return this.myValue;
    }

    public boolean isLong() {
        String value = this.getValue();
        if (value == null) {
            return false;
        }
        try {
            Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean isDouble() {
        String value = this.getValue();
        if (value == null) {
            return false;
        }
        try {
            Double.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public Long getLong() {
        if (this.isLong()) {
            return Long.valueOf(this.getValue().trim());
        }
        return null;
    }

    public Double getDouble() {
        if (this.isDouble()) {
            return Double.valueOf(this.getValue().trim());
        }
        return null;
    }

    public Parameter createNewInstance() {
        return new Value(this.getM4Db());
    }
}

