/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.sql.SQLException;
import miningmart.compiler.Case;
import miningmart.compiler.M4Data;
import miningmart.compiler.M4Object;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.Operator;
import miningmart.compiler.utils.DB;

public class Step
extends M4Data {
    private Case myCase;
    private long myNr;
    private long opId;
    private String opClass;
    protected Operator op;
    private int loopCount;
    private String multiStepCondition;

    public void print() {
        this.doPrint(4, "Step (Id = " + this.myId + ";" + "      Operator = " + this.opClass + ";" + "      Loop Count = " + this.loopCount + ";" + "      Multi Step = " + this.multiStepCondition + ")");
    }

    public Step(long stepId, DB m4Db) throws SQLException, M4CompilerError {
        super(m4Db);
        try {
            Class<?> theOpClass;
            this.doPrint(4, "Loading Step " + stepId);
            this.myId = stepId;
            this.getM4Db().readStepFromDB(this);
            try {
                theOpClass = Class.forName("miningmart.compiler.operator." + this.opClass);
            }
            catch (ClassNotFoundException e1) {
                try {
                    theOpClass = Class.forName("miningmart.compiler.operator.dista." + this.opClass);
                }
                catch (ClassNotFoundException e2) {
                    theOpClass = Class.forName("miningmart.compiler.operator.uep." + this.opClass);
                }
            }
            this.op = (Operator)theOpClass.newInstance();
            this.op.load(this);
        }
        catch (ClassNotFoundException e) {
            this.doPrint(e);
            throw new M4CompilerError("Could not find implementation (Java class) for operator '" + this.opClass + "'!");
        }
        catch (InstantiationException e) {
            this.doPrint(e);
            throw new M4CompilerError("Operator Class " + this.opClass + " is not instantiatable.");
        }
        catch (IllegalAccessException e) {
            this.doPrint(e);
            throw new M4CompilerError("Operator Class " + this.opClass + " is not accessible.");
        }
    }

    public Operator getOperator() {
        return this.op;
    }

    public void setOperator(Operator theOp) {
        this.op = theOp;
    }

    public long getOperatorId() {
        return this.opId;
    }

    public void setOperatorId(long id) {
        this.opId = id;
    }

    public M4Object load(long id) {
        return this;
    }

    public long getCaseId() {
        return this.myCase.getId();
    }

    public long getNumber() {
        return this.myNr;
    }

    public void setCase(Case myCase) {
        this.myCase = myCase;
    }

    public void setNumber(long nr) {
        this.myNr = nr;
    }

    public String getOperatorClass() {
        return this.opClass;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public String getMultiStepCondition() {
        return this.multiStepCondition;
    }

    public void setOperatorClass(String oc) {
        this.opClass = oc;
    }

    public void setLoopCount(int lc) {
        this.loopCount = lc;
    }

    public void setMultiStepCondition(String msc) {
        this.multiStepCondition = msc;
    }

    public Case getCase() {
        return this.myCase;
    }
}

