/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

class Sequentializer {
    private final HashMap graph = new HashMap();

    Sequentializer() {
    }

    public VertexInformation getVertexInformationFor(Object obj) {
        return (VertexInformation)this.graph.get(obj);
    }

    public boolean containsNode(Object obj) {
        return this.graph.containsKey(obj);
    }

    public Iterator getKeyIterator() {
        return this.graph.keySet().iterator();
    }

    public Iterator getEntryIterator() {
        return this.graph.values().iterator();
    }

    public void addVertex(Object obj) {
        this.graph.put(obj, new VertexInformation());
    }

    public void addEdge(Object before, Object after) {
        VertexInformation vi = this.getVertexInformationFor(before);
        vi.addSuccessor(after);
    }

    public Collection getSequentialOrder() {
        Iterator nodeIterator = this.getKeyIterator();
        LinkedList sequential = new LinkedList();
        while (nodeIterator.hasNext() && sequential != null) {
            sequential = this.visitSuccessorsOf(nodeIterator.next(), sequential);
        }
        this.resetVisitedInformation();
        return sequential;
    }

    public Collection getDependentNodes(Object rootNode) {
        LinkedList ret = this.visitSuccessorsOf(rootNode, new LinkedList());
        this.resetVisitedInformation();
        return ret;
    }

    private LinkedList visitSuccessorsOf(Object vertex, LinkedList finished) {
        VertexInformation vInfo = this.getVertexInformationFor(vertex);
        short status = vInfo.getVisitedStatus();
        if (status == 1) {
            return null;
        }
        if (status == 2) {
            return finished;
        }
        vInfo.setVisitedStatus((short)1);
        Iterator successors = vInfo.getSuccessorIterator();
        while (successors.hasNext() && finished != null) {
            finished = this.visitSuccessorsOf(successors.next(), finished);
        }
        vInfo.setVisitedStatus((short)2);
        if (finished != null) {
            finished.addFirst(vertex);
        }
        return finished;
    }

    private void resetVisitedInformation() {
        Iterator elementIterator = this.getEntryIterator();
        while (elementIterator.hasNext()) {
            VertexInformation v = (VertexInformation)elementIterator.next();
            v.setVisitedStatus((short)0);
        }
    }

    private class VertexInformation {
        public static final short NOT_VISITED = 0;
        public static final short ACTIVE = 1;
        public static final short FINISHED = 2;
        private short visitedStatus = 0;
        private final Vector successors = new Vector();

        VertexInformation() {
        }

        public void addSuccessor(Object successor) {
            if (!this.successors.contains(successor)) {
                this.successors.add(successor);
            }
        }

        public Iterator getSuccessorIterator() {
            return ((AbstractList)this.successors).iterator();
        }

        public void setVisitedStatus(short status) {
            this.visitedStatus = status;
        }

        public short getVisitedStatus() {
            return this.visitedStatus;
        }
    }
}

