/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.sql.SQLException;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Concept;
import miningmart.compiler.M4Data;
import miningmart.compiler.M4Object;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.Relation;
import miningmart.compiler.Step;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.exception.M4CompilerThreadKilledException;
import miningmart.compiler.exception.ParameterError;
import miningmart.compiler.operator.Operator;
import miningmart.compiler.utils.DB;

public abstract class Parameter
extends M4Data {
    private long parameterId;
    private String myParamName;
    private Operator myOp;
    private Step myStep;
    private boolean isInputParam;
    private long objectId;
    private String objectType;
    private int loopNr;

    public Parameter(DB m4Db) {
        super(m4Db);
    }

    public abstract Parameter createNewInstance();

    public void print() {
        if (this.getParameterName() != null) {
            this.doPrint(6, "Parameter " + this.getParameterName() + "(Id = " + this.getParameterId() + ";" + " Type = " + this.objectType + "): ");
        }
    }

    public static BaseAttribute loadBaseAttribute(Operator op, String parName, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (BaseAttribute)Parameter.loadParameter(op, parName, new BaseAttribute(m4Db), DB.C_BA, 0, m4Db);
    }

    public static Value loadValue(Operator op, String parName, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Value)Parameter.loadParameter(op, parName, new Value(m4Db), DB.C_VAL, 0, m4Db);
    }

    public static MultiColumnFeature loadMultiColumnFeature(Operator op, String parName, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (MultiColumnFeature)Parameter.loadParameter(op, parName, new MultiColumnFeature(m4Db), DB.C_MCF, 0, m4Db);
    }

    public static Concept loadConcept(Operator op, String parName, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Concept)Parameter.loadParameter(op, parName, new Concept(m4Db), DB.C_CONC, 0, m4Db);
    }

    public static Relation loadRelation(Operator op, String parName, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Relation)Parameter.loadParameter(op, parName, new Relation(m4Db), DB.C_REL, 0, m4Db);
    }

    public static BaseAttribute[] loadBaseAttributeArray(Operator op, String parName, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException, M4CompilerThreadKilledException {
        return (BaseAttribute[])Parameter.loadParameterArray(op, parName, new BaseAttribute(m4Db), DB.C_BA, 0, m4Db);
    }

    public static Concept[] loadConceptArray(Operator op, String parName, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Concept[])Parameter.loadParameterArray(op, parName, new Concept(m4Db), DB.C_CONC, 0, m4Db);
    }

    public static Relation[] loadRelationArray(Operator op, String parName, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Relation[])Parameter.loadParameterArray(op, parName, new Relation(m4Db), DB.C_REL, 0, m4Db);
    }

    public static Value[] loadValueArray(Operator op, String parName, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Value[])Parameter.loadParameterArray(op, parName, new Value(m4Db), DB.C_VAL, 0, m4Db);
    }

    public static MultiColumnFeature[] loadMultiColumnFeatureArray(Operator op, String parName, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (MultiColumnFeature[])Parameter.loadParameterArray(op, parName, new MultiColumnFeature(m4Db), DB.C_MCF, 0, m4Db);
    }

    public static BaseAttribute loadBaseAttribute(Operator op, String parName, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (BaseAttribute)Parameter.loadParameter(op, parName, new BaseAttribute(m4Db), DB.C_BA, loopNr, m4Db);
    }

    public static Value loadValue(Operator op, String parName, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Value)Parameter.loadParameter(op, parName, new Value(m4Db), DB.C_VAL, loopNr, m4Db);
    }

    public static MultiColumnFeature loadMultiColumnFeature(Operator op, String parName, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (MultiColumnFeature)Parameter.loadParameter(op, parName, new MultiColumnFeature(m4Db), DB.C_MCF, loopNr, m4Db);
    }

    public static Concept loadConcept(Operator op, String parName, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Concept)Parameter.loadParameter(op, parName, new Concept(m4Db), DB.C_CONC, loopNr, m4Db);
    }

    public static Relation loadRelation(Operator op, String parName, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Relation)Parameter.loadParameter(op, parName, new Relation(m4Db), DB.C_REL, loopNr, m4Db);
    }

    public static BaseAttribute[] loadBaseAttributeArray(Operator op, String parName, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (BaseAttribute[])Parameter.loadParameterArray(op, parName, new BaseAttribute(m4Db), DB.C_BA, loopNr, m4Db);
    }

    public static Concept[] loadConceptArray(Operator op, String parName, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Concept[])Parameter.loadParameterArray(op, parName, new Concept(m4Db), DB.C_CONC, loopNr, m4Db);
    }

    public static Relation[] loadRelationArray(Operator op, String parName, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Relation[])Parameter.loadParameterArray(op, parName, new Relation(m4Db), DB.C_REL, loopNr, m4Db);
    }

    public static Value[] loadValueArray(Operator op, String parName, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (Value[])Parameter.loadParameterArray(op, parName, new Value(m4Db), DB.C_VAL, loopNr, m4Db);
    }

    public static MultiColumnFeature[] loadMultiColumnFeatureArray(Operator op, String parName, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        return (MultiColumnFeature[])Parameter.loadParameterArray(op, parName, new MultiColumnFeature(m4Db), DB.C_MCF, loopNr, m4Db);
    }

    private static M4Object loadParameter(Operator op, String parName, Parameter newP, String type, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        newP.setParameterName(parName);
        newP.setOperator(op);
        newP.setStep(op.getStep());
        newP.setLoopNr(loopNr);
        m4Db.readParameterFromDB(newP, type);
        if (type.equals(newP.getParObjectType())) {
            Parameter actP;
            op.doPrint(8, "Looking up cache for object: " + newP.getParObjectId());
            try {
                actP = (Parameter)m4Db.m4cache(newP.getParObjectId(), newP);
            }
            catch (SQLException sqle) {
                throw new ParameterError("Impossible to load parameter " + parName + ": SQL error: " + sqle.getMessage());
            }
            catch (M4CompilerError e) {
                throw new ParameterError("Impossible to load parameter " + parName + ": error: " + e.getMessage());
            }
            if (newP != actP) {
                op.doPrint(8, "Already Loaded");
                actP.setParameterId(newP.getParameterId());
                actP.setParameterName(newP.getParameterName());
                actP.setOperator(newP.getOperator());
                actP.setStep(newP.getStep());
                actP.setIsInputParam(newP.isInputParam());
                actP.setParObjectId(newP.getParObjectId());
                actP.setParObjectType(newP.getParObjectType());
                actP.setLoopNr(newP.getLoopNr());
            }
            return actP;
        }
        String message = "ParameterTypeError: expected parameter of type " + type + ", but got parameter of type " + newP.getParObjectType();
        throw new ParameterError(message);
    }

    private static M4Object[] loadParameterArray(Operator op, String parName, Parameter newP, String type, int loopNr, DB m4Db) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        ((Parameter)newP).setParameterName(parName);
        ((Parameter)newP).setOperator(op);
        ((Parameter)newP).setStep(op.getStep());
        ((Parameter)newP).setLoopNr(loopNr);
        M4Object[] paramList = m4Db.readParameterListFromDB((Parameter)newP, type);
        int i = 0;
        while (i < paramList.length) {
            Parameter actP;
            newP = paramList[i];
            if (type.equals(((Parameter)newP).getParObjectType())) {
                op.doPrint(8, "Looking up cache for object: " + ((Parameter)newP).getParObjectId());
                try {
                    actP = (Parameter)m4Db.m4cache(((Parameter)newP).getParObjectId(), newP);
                }
                catch (SQLException sqle) {
                    throw new ParameterError("Impossible to load parameter " + parName + ": SQL error: " + sqle.getMessage());
                }
                catch (M4CompilerError e) {
                    throw new ParameterError("Impossible to load parameter " + parName + ": error: " + e.getMessage());
                }
                if (newP != actP) {
                    op.doPrint(8, "Already Loaded");
                    actP.setParameterId(((Parameter)newP).getParameterId());
                    actP.setParameterName(((Parameter)newP).getParameterName());
                    actP.setOperator(((Parameter)newP).getOperator());
                    actP.setStep(((Parameter)newP).getStep());
                    actP.setIsInputParam(((Parameter)newP).isInputParam());
                    actP.setParObjectId(((Parameter)newP).getParObjectId());
                    actP.setParObjectType(((Parameter)newP).getParObjectType());
                    actP.setLoopNr(((Parameter)newP).getLoopNr());
                }
            } else {
                throw new ParameterError("ParameterTypeError: expected parameter of type " + type + ", but got parameter of type " + ((Parameter)newP).getParObjectType());
            }
            paramList[i] = actP;
            ++i;
        }
        return paramList;
    }

    public void setParameterId(long pid) {
        this.parameterId = pid;
    }

    public long getParameterId() {
        return this.parameterId;
    }

    public void setParameterName(String pn) {
        this.myParamName = pn;
    }

    public String getParameterName() {
        return this.myParamName;
    }

    public void setOperator(Operator op) {
        this.myOp = op;
    }

    public Operator getOperator() {
        return this.myOp;
    }

    public void setStep(Step s) {
        this.myStep = s;
    }

    public Step getStep() {
        return this.myStep;
    }

    public boolean isInputParam() {
        return this.isInputParam;
    }

    public void setIsInputParam(boolean is) {
        this.isInputParam = is;
    }

    public void setParObjectId(long pid) {
        this.objectId = pid;
    }

    public long getParObjectId() {
        return this.objectId;
    }

    public void setLoopNr(int nr) {
        this.loopNr = nr;
    }

    public int getLoopNr() {
        return this.loopNr;
    }

    public void setParObjectType(String ot) {
        this.objectType = ot;
    }

    public String getParObjectType() {
        return this.objectType;
    }
}

