/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.sql.SQLException;
import miningmart.compiler.M4Data;
import miningmart.compiler.M4Object;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.utils.DB;

public class OpParam
extends M4Data {
    private String paramName;
    private int minArg;
    private int maxArg;
    private short type;
    private boolean ioType;
    private static final boolean IN = true;
    private static final String IN_STRING = "IN";
    private static final boolean OUT = false;
    private static final String OUT_STRING = "OUT";
    public static final String CON_STR = "CON";
    public static final String REL_STR = "REL";
    public static final String BA_STR = "BA";
    public static final String MCF_STR = "MCF";
    public static final String FEAT_STR = "FEA";
    public static final String VAL_STR = "V";
    public static final String FUNC_STR = "FUNC";
    public static final short CONCEPT = 1;
    public static final short RELATIONSHIP = 2;
    public static final short BASEATTRIBUTE = 3;
    public static final short MULTICOLUMNFEATURE = 4;
    public static final short FEATURE = 5;
    public static final short VALUE = 6;
    public static final short FUNCTION = 7;

    public OpParam(DB m4Db) {
        super(m4Db);
    }

    public M4Object load(long id) throws SQLException, M4CompilerError {
        return this;
    }

    public void print() {
    }

    public boolean isInput() {
        return this.ioType;
    }

    public int getMaxArg() {
        return this.maxArg;
    }

    public int getMinArg() {
        return this.minArg;
    }

    public String getParamName() {
        return this.paramName;
    }

    public short getType() {
        return this.type;
    }

    public void setInput(String ioType) throws M4CompilerError {
        if (ioType.equalsIgnoreCase(IN_STRING)) {
            this.ioType = true;
        } else if (ioType.equalsIgnoreCase(OUT_STRING)) {
            this.ioType = false;
        } else {
            throw new M4CompilerError("Parameter " + this.getId() + "in table OP_PARAMS_T is neither '" + IN_STRING + "' nor '" + OUT_STRING + "', but: '" + ioType + "'");
        }
    }

    public void setMaxArg(int maxArg) {
        this.maxArg = maxArg;
    }

    public void setMinArg(int minArg) {
        this.minArg = minArg;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void setType(String typeString) throws M4CompilerError {
        if (typeString.equals(CON_STR)) {
            this.type = 1;
        } else if (typeString.equals(REL_STR)) {
            this.type = (short)2;
        } else if (typeString.equals(BA_STR)) {
            this.type = (short)3;
        } else if (typeString.equals(MCF_STR)) {
            this.type = (short)4;
        } else if (typeString.equals(FEAT_STR)) {
            this.type = (short)5;
        } else if (typeString.equals(VAL_STR)) {
            this.type = (short)6;
        } else if (typeString.equals(FUNC_STR)) {
            this.type = (short)7;
        } else {
            throw new M4CompilerError("Parameter " + this.getId() + "in table OP_PARAMS_T has unsupported type entry: '" + typeString + "'");
        }
    }
}

