/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import miningmart.compilerInterface.CompilerAccessLogic;

public class DeleteTrash {
    private static CompilerAccessLogic cal = null;

    public static void main(String[] args) {
        String errorMessage = "Wrong function call!\nUsage: (1) java DeleteTrash <databaseConfigFile> step <step-id>\n   or: (2) java DeleteTrash <databaseConfigFile> case <case-id>\nNumber (1) will delete all metadata for the given step and its dependent steps;\nnumber (2) will delete all metadata in the given case.";
        if (args.length != 3) {
            DeleteTrash.doPrint(20, errorMessage);
            return;
        }
        try {
            cal = new CompilerAccessLogic(args[0]);
            if (args[1].equals("step")) {
                cal.deleteTrashForStep(Long.parseLong(args[2]));
            } else if (args[1].equals("case")) {
                cal.deleteTrashForCase(Long.parseLong(args[2]));
            } else {
                DeleteTrash.doPrint(20, errorMessage);
            }
            DeleteTrash.doPrint(20, "\nDone.");
        }
        catch (NullPointerException npe) {
            System.out.println(((Throwable)npe).getMessage());
            npe.printStackTrace(System.out);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void doPrint(int verbosity, String message) {
        if (cal != null) {
            cal.getCasePrintObject().doPrint(verbosity, message);
        } else {
            System.err.println(message);
        }
    }
}

