/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.io.IOException;
import java.sql.SQLException;
import miningmart.compilerInterface.CompilerAccessLogic;

public class CreateCompiler {
    private final String dbConfig;
    private CompilerAccessLogic c;
    private int verbosity = -1;

    public static void main(String[] args) throws Exception {
        if (args.length > 2) {
            CreateCompiler c = new CreateCompiler(args[0]);
            String command = args[1];
            int numArgs = args.length;
            String[] tmp = new String[numArgs - 2];
            int i = 0;
            while (i < tmp.length) {
                tmp[i] = args[i + 2];
                ++i;
            }
            args = tmp;
            if (command.equals("step")) {
                c.compileStep(args);
            } else if (command.equalsIgnoreCase("stepFrom")) {
                c.compileStepFrom(args);
            } else if (command.equalsIgnoreCase("case")) {
                c.compileCase(args);
            } else if (command.equalsIgnoreCase("status")) {
                c.printStatus(args);
            } else if (command.equalsIgnoreCase("stat-con")) {
                c.updateConceptStatistics(args);
            } else if (command.equalsIgnoreCase("stat-cs")) {
                c.updateColumnsetStatistics(args);
            } else if (command.equalsIgnoreCase("stat-col")) {
                c.updateColumnStatistics(args);
            } else if (command.equalsIgnoreCase("gc-step")) {
                c.garbageCollectionForStep(args);
            } else if (command.equalsIgnoreCase("gc-case")) {
                c.garbageCollectionForCase(args);
            } else if (command.equalsIgnoreCase("ready")) {
                c.checkStepReady(args);
            } else if (command.equalsIgnoreCase("restOf")) {
                c.compileRestOfCase(args);
            }
        }
        System.err.println("Usage: java miningmart.compiler.CreateCompiler <db.config file>\n          status   <caseId> [ numberOfLines ]\n        | case     <caseId> [<lazy> [<verbosity>]]\n        | step     <stepId> [<lazy> [<verbosity>]]\n        | stepFrom <stepId> [<lazy> [<verbosity>]]\n        | restOf   <caseId> [<lazy> [<verbosity>]]\n         | stat-con <conceptId>\n        | stat-cs  <columnsetId>\n        | stat-col <columnId>\n        | gc-step  <stepId>\n        | gc-case  <caseId>\n        | ready    <stepId>\n");
        System.exit(-1);
    }

    private CreateCompiler(String dbConfig) {
        this.dbConfig = dbConfig;
    }

    private CompilerAccessLogic getCompilerAccess() throws IOException, SQLException {
        if (this.c == null) {
            this.c = this.verbosity < 0 ? new CompilerAccessLogic(this.dbConfig) : new CompilerAccessLogic(this.dbConfig, this.verbosity);
        }
        return this.c;
    }

    private void setVerbosity(int verbosity) {
        if (this.verbosity < 0) {
            this.verbosity = verbosity;
        }
    }

    private void printStatus(String[] args) throws Exception {
        int numberOfLines = 30;
        try {
            if (args.length > 1) {
                numberOfLines = Integer.parseInt(args[1]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        System.out.println("---------------------------------- Status ----------------------------------\n");
        String msg = this.getCompilerAccess().getStatusMessage(CreateCompiler.getObjId(args[0]), numberOfLines);
        if (msg == null) {
            msg = "<null>";
        }
        System.out.println(msg);
        System.out.println("\n----------------------------------------------------------------------------");
        System.exit(0);
    }

    private void compileCase(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        boolean lazyMode = args.length > 1 ? CreateCompiler.getLazyMode(args[1]) : false;
        System.out.println("Trying to compile case " + objId);
        String v = "";
        if (args.length > 2) {
            v = ", " + args[2];
            this.setVerbosity(CreateCompiler.getVerbosity(v));
        }
        this.getCompilerAccess().compileAll(objId, lazyMode);
        System.out.println("Returned from compileAll(" + objId + ", " + (lazyMode ? "lazy" : "eager") + v + ");");
        System.exit(0);
    }

    private void compileStep(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        boolean lazyMode = args.length > 1 ? CreateCompiler.getLazyMode(args[1]) : false;
        System.out.println("Trying to compile step " + objId + ".");
        String v = "";
        if (args.length > 2) {
            v = ", " + args[2];
            this.setVerbosity(CreateCompiler.getVerbosity(v));
        }
        this.getCompilerAccess().compileStep(objId, lazyMode);
        System.out.println("Returned from compileStep(" + objId + ", " + (lazyMode ? "lazy" : "eager") + v + ");");
        System.exit(0);
    }

    private void compileStepFrom(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        boolean lazyMode = args.length > 1 ? CreateCompiler.getLazyMode(args[1]) : false;
        System.out.println("Trying to compile all steps dependent on step " + objId + ".");
        String v = "";
        if (args.length > 2) {
            v = ", " + args[2];
            this.setVerbosity(CreateCompiler.getVerbosity(v));
        }
        this.getCompilerAccess().compileStepFrom(objId, lazyMode);
        System.out.println("Returned from compileStepFrom(" + objId + ", " + (lazyMode ? "lazy" : "eager") + v + ");");
        System.exit(0);
    }

    private void updateConceptStatistics(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Updating Concept statistics for Concept " + objId + ".");
        this.getCompilerAccess().updateStatisticsForConcept(objId);
        System.out.println("Statistics updated for object with id: " + objId + " !");
        System.exit(0);
    }

    private void updateColumnsetStatistics(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Updating Columnset statistics for Columnset " + objId + ".");
        this.getCompilerAccess().updateColumnsetStatistics(objId);
        System.out.println("Statistics updated for object with id: " + objId + " !");
        System.exit(0);
    }

    private void updateColumnStatistics(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Updating Column statistics for Column " + objId + ".");
        this.getCompilerAccess().updateColumnStatistics(objId);
        System.out.println("Statistics updated for object with id: " + objId + " !");
        System.exit(0);
    }

    private void garbageCollectionForStep(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Running Garbage Collection for Step " + objId + ".");
        this.getCompilerAccess().deleteTrashForStep(objId);
        System.out.println("Garbage for Step with id " + objId + " collected!");
        System.exit(0);
    }

    private void garbageCollectionForCase(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Running Garbage Collection for Case " + objId + ".");
        this.getCompilerAccess().deleteTrashForCase(objId);
        System.out.println("Garbage for Case with id " + objId + " collected!");
        System.exit(0);
    }

    private void checkStepReady(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        System.out.println("Checking if Step " + objId + " is ready for compilation.");
        boolean ready = this.getCompilerAccess().isReadyForCompilation(objId);
        System.out.println("Step with id " + objId + " is" + (ready ? "" : " not") + " ready for compilation!");
        System.exit(0);
    }

    private void compileRestOfCase(String[] args) throws Exception {
        long objId = CreateCompiler.getObjId(args[0]);
        boolean lazyMode = args.length > 1 ? CreateCompiler.getLazyMode(args[1]) : false;
        System.out.println("Trying to compile rest of case " + objId);
        String v = "";
        if (args.length > 2) {
            v = ", " + args[2];
            this.setVerbosity(CreateCompiler.getVerbosity(v));
        }
        this.getCompilerAccess().compileRestOfCase(objId, lazyMode);
        System.out.println("Returned from compileAll(" + objId + ", " + (lazyMode ? "lazy" : "eager") + v + ");");
        System.exit(0);
    }

    private static long getObjId(String s) {
        try {
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static boolean getLazyMode(String s) {
        String lazyString = s.trim().toLowerCase();
        return lazyString.startsWith("l") || lazyString.startsWith("y");
    }

    private static int getVerbosity(String s) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

