/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.sql.SQLException;
import miningmart.compiler.Columnset;
import miningmart.compiler.Feature;
import miningmart.compiler.M4Object;
import miningmart.compiler.Parameter;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.utils.DB;

public class Concept
extends Parameter {
    private boolean allColumnSetsLoaded = false;
    private boolean allFeaturesLoaded = false;
    private Columnset[] myColumnSets;
    private Feature[] myFeatures;
    private String mySubConceptRestriction;
    private String myType;
    private Columnset[] columnsets;
    private int columnsetIndex;

    public Concept(DB m4Db) {
        super(m4Db);
    }

    public void addColumnSet(Columnset c) throws M4CompilerError {
        Columnset[] cset = this.getColumnSets();
        if (cset == null) {
            this.setColumnSets(new Columnset[]{c});
        } else {
            Columnset[] newColSets = new Columnset[cset.length + 1];
            int i = 0;
            while (i < cset.length) {
                if (cset[i].getId() == c.getId() && c.getId() != 0L) {
                    return;
                }
                newColSets[i] = cset[i];
                ++i;
            }
            newColSets[cset.length] = c;
            this.setColumnSets(newColSets);
        }
    }

    public M4Object load(long concId) throws SQLException, M4CompilerError {
        this.myId = concId;
        this.getM4Db().readConceptFromDB(this);
        return this;
    }

    public void setColumnSets(Columnset[] cls) {
        this.myColumnSets = cls;
        this.allColumnSetsLoaded = true;
    }

    public Columnset[] getColumnSets() throws M4CompilerError {
        try {
            if (this.allColumnSetsLoaded) {
                return this.myColumnSets;
            }
            this.getM4Db().readColumnSetsForConceptFromDB(this);
            this.allColumnSetsLoaded = true;
            return this.myColumnSets;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB error: " + sqle.getMessage());
        }
    }

    public Columnset getCurrentColumnSet() throws M4CompilerError {
        if (this.columnsets != null) {
            return this.columnsets[this.columnsetIndex];
        }
        this.getColumnSets();
        if (this.myColumnSets != null && this.myColumnSets.length > 0) {
            return this.myColumnSets[0];
        }
        return null;
    }

    public void addFeature(Feature f) throws M4CompilerError {
        Feature[] newFtSets;
        Feature[] fset = this.getFeatures();
        if (fset == null) {
            newFtSets = new Feature[]{f};
        } else {
            newFtSets = new Feature[fset.length + 1];
            int i = 0;
            while (i < fset.length) {
                if (fset[i].getId() == f.getId() && f.getId() != 0L) {
                    return;
                }
                newFtSets[i] = fset[i];
                ++i;
            }
            newFtSets[fset.length] = f;
        }
        this.setFeatures(newFtSets);
    }

    public Feature getFeature(int index) throws M4CompilerError {
        Feature[] fs = this.getFeatures();
        if (fs != null && index > -1 && index < fs.length) {
            return fs[index];
        }
        throw new M4CompilerError("Concept.getFeature(): No Featurearray exists, or wrong index!");
    }

    public void setFeatures(Feature[] fs) {
        this.myFeatures = fs;
        this.allFeaturesLoaded = true;
    }

    public Feature[] getFeatures() throws M4CompilerError {
        try {
            if (!this.allFeaturesLoaded) {
                this.getM4Db().readFeaturesForConcept(this);
                this.allFeaturesLoaded = true;
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB error: " + sqle.getMessage());
        }
        return this.myFeatures;
    }

    public void setSubConceptRestriction(String scr) {
        this.mySubConceptRestriction = scr;
    }

    public String getSubConceptRestriction() {
        return this.mySubConceptRestriction;
    }

    public void setType(String t) throws M4CompilerError {
        if (!(t.equalsIgnoreCase("DB") || t.equalsIgnoreCase("Base") || t.equalsIgnoreCase("Mining"))) {
            throw new M4CompilerError("Tried to set unknown type into Concept '" + this.getName() + "': " + t);
        }
        this.myType = t.toUpperCase();
    }

    public String getType() {
        return this.myType;
    }

    public void print() {
        int i;
        super.print();
        this.doPrint(4, "Concept " + this.myName + "(Id = " + this.myId + ";" + " Type = " + this.myType + ") ");
        if (this.myColumnSets != null) {
            i = 0;
            while (i < this.myColumnSets.length) {
                this.myColumnSets[i].print();
                ++i;
            }
        }
        if (this.myFeatures != null) {
            i = 0;
            while (i < this.myFeatures.length) {
                this.myFeatures[i].print();
                ++i;
            }
        }
    }

    public String getCurrentSuffix() {
        if (this.columnsets != null) {
            return "_" + this.columnsetIndex;
        }
        return "";
    }

    public void initMultiStepSupport(Columnset[] columnsets) {
        this.columnsets = columnsets;
        this.resetColumnSets();
    }

    public void resetColumnSets() {
        this.columnsetIndex = 0;
    }

    public boolean hasNextColumnSet() throws M4CompilerError {
        if (this.columnsets != null) {
            return this.columnsetIndex + 1 < this.columnsets.length;
        }
        Columnset[] c = this.getColumnSets();
        if (c == null) {
            throw new M4CompilerError("Concept '" + this.getName() + "', id: " + this.getId() + "\nError during call of method Concept.hasNextColumnSet(): " + "\"InputConcept\".getColumnSets() returned null.");
        }
        return false;
    }

    public Columnset getNextColumnSet() throws M4CompilerError {
        if (this.hasNextColumnSet()) {
            return this.columnsets[++this.columnsetIndex];
        }
        throw new M4CompilerError("Concept '" + this.getName() + "', id: " + this.getId() + "\nTried to call method getNextColumnSet() with no Columnset left!");
    }

    public Parameter createNewInstance() {
        return new Concept(this.getM4Db());
    }
}

