/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.sql.SQLException;
import miningmart.compiler.Column;
import miningmart.compiler.Concept;
import miningmart.compiler.M4Data;
import miningmart.compiler.M4Object;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.utils.DB;

public class Columnset
extends M4Data {
    private Concept myConcept;
    private String mySchema;
    private String myType;
    private String sql;
    private String multiStepBranch;
    private Column[] myColumns;
    private boolean allColumnsLoaded = false;
    private int myStatistAll;
    private int myStatistNominal;
    private int myStatistOrdinal;
    private int myStatistTime;

    public Columnset(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        this.doPrint(4, "Columnset " + this.myName + "(Id = " + this.myId + ";" + " Type = " + this.myType + ") defined in SQL as " + this.sql);
    }

    public M4Object load(long csId) throws SQLException, M4CompilerError {
        this.myId = csId;
        DB m4db = this.getM4Db();
        m4db.readColumnsetFromDB(this);
        m4db.readColumnsForColumnsetFromDB(this);
        m4db.readColumnsetStatistFromDB(this);
        return this;
    }

    public void setConcept(Concept c) {
        this.myConcept = c;
    }

    public Concept getConcept() {
        return this.myConcept;
    }

    public void setSchema(String s) {
        this.mySchema = s;
    }

    public String getSchema() {
        if (this.mySchema == null) {
            return "";
        }
        return this.mySchema;
    }

    public String getSchemaPlusName() {
        String ret = this.getSchema();
        if (ret.length() > 0) {
            ret = String.valueOf(ret) + ".";
        }
        ret = String.valueOf(ret) + this.getName();
        return ret;
    }

    public void setType(String t) throws M4CompilerError {
        if (!t.equalsIgnoreCase("T") && !t.equalsIgnoreCase("V")) {
            throw new M4CompilerError("Tried to set unknown type into Columnset '" + this.getName() + "': " + t);
        }
        this.myType = t.toUpperCase();
    }

    public String getType() {
        return this.myType;
    }

    public void setSQLDefinition(String sqlDefinition) {
        this.sql = sqlDefinition;
    }

    public String getSQLDefinition() {
        if (this.sql == null) {
            return this.getName();
        }
        return this.sql;
    }

    public void setMultiStepBranch(String branchDefinition) {
        this.multiStepBranch = branchDefinition;
    }

    public String getMultiStepBranch() {
        return this.multiStepBranch;
    }

    public void addMultiStepBranchInfo(String oldDef, String attribute, String value) throws M4CompilerError {
        if (attribute == null || value == null || this.getMSBranchSelectionValue(attribute) != null) {
            this.setMultiStepBranch(oldDef == null ? "" : oldDef);
        } else {
            String extension = String.valueOf(attribute.trim()) + "=" + value.trim() + ";";
            this.setMultiStepBranch(oldDef == null ? extension : String.valueOf(oldDef) + extension);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addMultiStepBranch(String branch) throws M4CompilerError {
        if (branch != null) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            first = branch.substring(0, idx);
            branch = branch.substring(idx + 1);
            eqIdx = first.indexOf(61);
            if (eqIdx == -1) {
                throw new M4CompilerError("Columnset.addMultiStepBranch(String): Could not parse substring '" + first + "' !");
            }
            attribute = first.substring(0, eqIdx);
            value = first.substring(eqIdx + 1);
            this.addMultiStepBranchInfo(this.getMultiStepBranch(), attribute, value);
lbl11:
            // 2 sources

            ** while ((idx = branch.indexOf((int)59)) != -1)
        }
lbl12:
        // 1 sources

    }

    public void setColumns(Column[] theColumns) {
        this.myColumns = theColumns;
    }

    public Column[] getColumns() throws M4CompilerError {
        try {
            if (this.allColumnsLoaded) {
                return this.myColumns;
            }
            this.getM4Db().readColumnsForColumnsetFromDB(this);
            this.allColumnsLoaded = true;
            return this.myColumns;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB error: " + sqle.getMessage());
        }
    }

    public void setColumn(int index, Column c) throws M4CompilerError {
        if (index <= -1 || index >= this.myColumns.length) {
            throw new M4CompilerError("Illegal Index for Column in ColumnSet (ColumnSet.setColumn())!");
        }
        this.myColumns[index] = c;
    }

    public Column getColumn(int index) throws M4CompilerError {
        if (index > -1 && index < this.myColumns.length) {
            return this.myColumns[index];
        }
        throw new M4CompilerError("Illegal Index for Column in ColumnSet (ColumnSet.getColumn())!");
    }

    public void setStatisticsAll(int sa) {
        this.myStatistAll = sa;
    }

    public int getStatisticsAll() {
        return this.myStatistAll;
    }

    public void setStatisticsNominal(int sn) {
        this.myStatistNominal = sn;
    }

    public int getStatisticsNominal() {
        return this.myStatistNominal;
    }

    public void setStatisticsOrdinal(int so) {
        this.myStatistOrdinal = so;
    }

    public int getStatisticsOrdinal() {
        return this.myStatistOrdinal;
    }

    public void setStatisticsTime(int st) {
        this.myStatistTime = st;
    }

    public int getStatisticsTime() {
        return this.myStatistTime;
    }

    public void addColumn(Column c) {
        if (this.myColumns == null) {
            this.myColumns = new Column[]{c};
        } else {
            Column[] newset = new Column[this.myColumns.length + 1];
            int i = 0;
            while (i < this.myColumns.length) {
                if (this.myColumns[i].getId() == c.getId() && c.getId() != 0L) {
                    return;
                }
                newset[i] = this.myColumns[i];
                ++i;
            }
            newset[this.myColumns.length] = c;
            this.myColumns = newset;
        }
        this.allColumnsLoaded = true;
    }

    public String getMSBranchSelectionValue(String attributeName) throws M4CompilerError {
        int startIdx = Columnset.indexOfMsbAttribute(this.getMultiStepBranch(), attributeName);
        if (startIdx == -1) {
            return null;
        }
        int stopIdx = this.getMultiStepBranch().indexOf(59, startIdx += attributeName.length() + 1);
        if (stopIdx == -1) {
            throw new M4CompilerError("MultiStepBranch-Information of ColumnSet " + this.getId() + " for attribute " + attributeName + " not properly ended by ';' !");
        }
        return this.getMultiStepBranch().substring(startIdx, stopIdx);
    }

    public String getMsbInfoWithoutAttrib(String attributeName) throws M4CompilerError {
        String s = this.getMultiStepBranch();
        int startIdx = Columnset.indexOfMsbAttribute(s, attributeName);
        if (startIdx == -1) {
            return s;
        }
        int stopIdx = s.indexOf(59, startIdx);
        if (stopIdx == -1) {
            throw new M4CompilerError("MultiStepBranch-Information of ColumnSet " + this.getId() + " for attribute " + attributeName + " not properly ended by ';' !");
        }
        String pre = s.substring(0, startIdx);
        String post = s.substring(stopIdx + 1);
        return String.valueOf(pre) + post;
    }

    private static int indexOfMsbAttribute(String msbString, String attributeName) {
        if (msbString == null || attributeName == null) {
            return -1;
        }
        String searchString = String.valueOf(attributeName.toLowerCase()) + "=";
        String lc = msbString.toLowerCase();
        if (lc.startsWith(searchString)) {
            return 0;
        }
        int startIdx = lc.indexOf(searchString = ";" + searchString);
        if (startIdx != -1) {
            return startIdx + 1;
        }
        return -1;
    }
}

