/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.sql.SQLException;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Columnset;
import miningmart.compiler.M4Data;
import miningmart.compiler.M4Object;
import miningmart.compiler.ValueCount;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.utils.DB;

public class Column
extends M4Data {
    private BaseAttribute myBaseAttribute;
    private Columnset myColumnSet;
    private long dataType;
    private String dataTypeName;
    private String sql;
    private boolean baseAttributeLoaded = false;
    private boolean statisticsAreUpToDate = false;
    private int noOfUniqueValues = -1;
    private int noOfMissingValues = -1;
    private String minValue;
    private String maxValue;
    private String medianValue;
    private String modalValue;
    private String averageValue;
    private String stdDeviation;
    private ValueCount[] valueDistribution;

    public Column(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        String colSetName = this.myColumnSet == null ? "<Columnset not set>" : String.valueOf(this.myColumnSet.getSchema()) + "." + this.myColumnSet.getName();
        this.doPrint(4, "Column " + this.myName + "(Id = " + this.myId + ";" + " Type = " + this.dataType + ") of Columnset " + colSetName + "  defined in SQL as " + this.sql + "  (Unique: " + this.noOfUniqueValues + " Missing: " + this.noOfMissingValues + " Min: " + this.minValue + " Max: " + this.maxValue + " Median: " + this.medianValue + " Modal: " + this.modalValue + " Average: " + this.averageValue + " Std. Dev.: " + this.stdDeviation + ")");
    }

    public M4Object load(long colId) throws SQLException, M4CompilerError {
        this.myId = colId;
        this.getM4Db().readColumnFromDB(this);
        this.getM4Db().readBaseAttributeForColumnFromDB(this);
        this.baseAttributeLoaded = true;
        this.myColumnSet = (Columnset)this.getM4Db().m4cache(this.myColumnSet.getId(), new Columnset(this.getM4Db()));
        return this;
    }

    public Column copyColTo(Columnset cs) throws M4CompilerError {
        Column ret = new Column(this.getM4Db());
        ret.myId = 0L;
        ret.setName(this.getName());
        ret.setColumnSet(cs);
        ret.setBaseAttribute(this.getBaseAttribute());
        ret.setColumnDataType(this.getColumnDataType());
        ret.setSQLDefinition(this.getSQLDefinition());
        ret.setAverageValue(this.getAverageValue());
        ret.readStatisticsFromDB();
        ret.setColumnDataTypeName(this.getColumnDataTypeName());
        ret.setMaxValue(this.getMaxValue());
        ret.setMedianValue(this.getMedianValue());
        ret.setMinValue(this.getMinValue());
        ret.setModalValue(this.getModalValue());
        ret.setNumberOfMissingValues(this.getNumberOfMissingValues());
        ret.setNumberOfUniqueValues(this.getNumberOfUniqueValues());
        ret.setStandardDeviation(this.getStandardDeviation());
        ret.setValueDistribution(this.getValueDistribution());
        cs.addColumn(ret);
        return ret;
    }

    public void setBaseAttribute(BaseAttribute ba) {
        this.myBaseAttribute = ba;
        this.baseAttributeLoaded = true;
    }

    public BaseAttribute getBaseAttribute() throws M4CompilerError {
        try {
            if (this.baseAttributeLoaded) {
                return this.myBaseAttribute;
            }
            this.getM4Db().readBaseAttributeForColumnFromDB(this);
            this.baseAttributeLoaded = true;
            return this.myBaseAttribute;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB error: " + sqle.getMessage());
        }
    }

    public void setSQLDefinition(String sqlDefinition) {
        this.sql = sqlDefinition;
    }

    public String getSQLDefinition() {
        if (this.sql == null) {
            return this.getName();
        }
        return this.sql;
    }

    public String getSQLPlusLocation() {
        String location = this.getColumnSet().getSchemaPlusName();
        location = location != null && !location.equals("") ? String.valueOf(location) + "." : "";
        return String.valueOf(location) + this.getSQLDefinition();
    }

    public void setColumnDataType(long type) {
        this.dataType = type;
    }

    public long getColumnDataType() {
        return this.dataType;
    }

    public void setColumnDataTypeName(String dtname) {
        this.dataTypeName = dtname;
    }

    public String getColumnDataTypeName() {
        return this.dataTypeName;
    }

    public void readStatisticsFromDB() throws M4CompilerError {
        if (this.getId() != 0L) {
            try {
                this.getM4Db().readColumnStatistFromDB(this);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Column with Id " + this.getId() + ": An error occurred when reading statistics information from DB: " + sqle.getMessage());
            }
            this.declareStatisticsUpToDate();
        }
    }

    public void declareStatisticsUpToDate() {
        this.statisticsAreUpToDate = true;
    }

    public void declareStatisticsOutOfDate() {
        this.statisticsAreUpToDate = false;
    }

    public int getNumberOfUniqueValues() {
        return this.noOfUniqueValues;
    }

    public int getNumberOfMissingValues() {
        return this.noOfMissingValues;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public String getMedianValue() {
        return this.medianValue;
    }

    public String getModalValue() {
        return this.modalValue;
    }

    public String getAverageValue() {
        return this.averageValue;
    }

    public String getStandardDeviation() {
        return this.stdDeviation;
    }

    public ValueCount[] getValueDistribution() {
        return this.valueDistribution;
    }

    public boolean areStatisticsUpToDate() {
        return this.statisticsAreUpToDate;
    }

    public void setNumberOfUniqueValues(int nuv) {
        this.noOfUniqueValues = nuv;
    }

    public void setNumberOfMissingValues(int nmv) {
        this.noOfMissingValues = nmv;
    }

    public void setMinValue(String min) {
        this.minValue = min;
    }

    public void setMaxValue(String max) {
        this.maxValue = max;
    }

    public void setMedianValue(String med) {
        this.medianValue = med;
    }

    public void setModalValue(String mod) {
        this.modalValue = mod;
    }

    public void setAverageValue(String avg) {
        this.averageValue = avg;
    }

    public void setStandardDeviation(String stddev) {
        this.stdDeviation = stddev;
    }

    public void setValueDistribution(ValueCount[] vd) {
        this.valueDistribution = vd;
    }

    public Columnset getColumnSet() {
        return this.myColumnSet;
    }

    public void setColumnSet(Columnset cs) {
        this.myColumnSet = cs;
    }
}

