/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import miningmart.compiler.M4Data;
import miningmart.compiler.M4Object;
import miningmart.compiler.Sequentializer;
import miningmart.compiler.Step;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.utils.DB;

public class Case
extends M4Data {
    private Vector stepIds;
    private final Sequentializer sequentializer = new Sequentializer();

    public Case(DB m4Db) {
        super(m4Db);
    }

    public M4Object load(long id) throws SQLException, M4CompilerError {
        this.setId(id);
        this.getM4Db().readCaseFromDb(this);
        Collection c = this.sequentializer.getSequentialOrder();
        if (c == null) {
            throw new M4CompilerError("Error loading Case with Id " + id + ": found cycle in the step dependencies (table STEPSEQUENCE_T)!");
        }
        this.stepIds = new Vector(c);
        return this;
    }

    public void addStepId(Long stepId) {
        if (stepId != null && stepId != 0L) {
            this.sequentializer.addVertex(stepId);
        }
    }

    public void addStepDependency(Long stepIdBefore, Long stepIdAfter) throws M4CompilerError {
        if (stepIdBefore == null || stepIdAfter == null) {
            throw new M4CompilerError("Trying to enter null-values in step dependency graph! Case: " + this.getId());
        }
        if (!this.sequentializer.containsNode(stepIdBefore)) {
            throw new M4CompilerError("Trying to enter dependency for unknown step! Step ID:" + stepIdBefore + ", Case ID: " + this.getId());
        }
        if (!this.sequentializer.containsNode(stepIdAfter)) {
            throw new M4CompilerError("Trying to enter dependency for unknown step! Step ID:" + stepIdAfter + ", Case ID: " + this.getId());
        }
        this.sequentializer.addEdge(stepIdBefore, stepIdAfter);
    }

    public void print() {
        this.doPrint(4, "Step (Id = " + this.getId() + ";" + "      Name = " + this.getName() + ";" + "      Steps: ");
        try {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Long l = (Long)it.next();
                if (l == null) continue;
                this.doPrint(4, "Step " + l);
            }
        }
        catch (M4CompilerError e) {
            this.doPrint(4, "Warning: Error loading steps in Case.print(): " + e.getMessage());
        }
        this.doPrint(4, ")");
    }

    public Long getStepIdNo(int i) {
        if (this.getStepIds() == null || i < 0 || i >= this.getStepIds().size()) {
            return null;
        }
        return (Long)this.getStepIds().get(i);
    }

    public int getNumberOfSteps() {
        if (this.getStepIds() == null) {
            return 0;
        }
        return this.getStepIds().size();
    }

    public Long getPredecessorIdOf(Long stepId) throws M4CompilerError {
        int stepIndex = this.indexOfStep(stepId);
        if (stepIndex <= 0) {
            return null;
        }
        return (Long)this.getStepIds().get(stepIndex - 1);
    }

    public Long getSuccessorIdOf(Step step) {
        if (step == null || this.getStepIds() == null) {
            return null;
        }
        return this.getSuccessorIdOf(step.getId());
    }

    public Long getSuccessorIdOf(long stepId) {
        if (this.getStepIds() == null) {
            return null;
        }
        Iterator it = ((AbstractList)this.getStepIds()).iterator();
        while (it.hasNext()) {
            if ((Long)it.next() != stepId || !it.hasNext()) continue;
            return (Long)it.next();
        }
        return null;
    }

    public int indexOfStep(Long stepId) throws M4CompilerError {
        if (this.getStepIds() == null) {
            throw new M4CompilerError("Case " + this.getName() + ", id: " + this.getId() + " has no steps or was not loaded properly!");
        }
        return this.getStepIds().indexOf(stepId);
    }

    public Iterator iterator() throws M4CompilerError {
        if (this.getStepIds() == null) {
            throw new M4CompilerError("Case " + this.getName() + ", id: " + this.getId() + " has no steps or was not loaded properly!");
        }
        return ((AbstractList)this.getStepIds()).iterator();
    }

    public Iterator getReverseIterator() throws M4CompilerError {
        LinkedList rev = new LinkedList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            rev.addFirst(it.next());
        }
        return rev.iterator();
    }

    public Collection getDependentStepIdsFor(long startStepId) throws M4CompilerError {
        Long stepIdL = new Long(startStepId);
        if (!this.sequentializer.containsNode(stepIdL)) {
            throw new M4CompilerError("Case.getDependentStepIdsFor(long):\nStep with ID: " + startStepId + " not part of Case " + this.getId() + "!");
        }
        Collection ret = this.sequentializer.getDependentNodes(stepIdL);
        if (ret == null) {
            throw new M4CompilerError("Case.getDependentStepIdsFor(long):\nCase " + this.getId() + " has cyclic dependencies between Steps!");
        }
        return ret;
    }

    private Vector getStepIds() {
        return this.stepIds;
    }
}

