/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler;

import java.sql.SQLException;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Concept;
import miningmart.compiler.Feature;
import miningmart.compiler.M4Object;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.Parameter;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.utils.DB;

public class BaseAttribute
extends Feature {
    private long dataType;
    private String dataTypeName;
    private Column[] myColumns;
    private Concept myConcept;
    private boolean allConceptsLoaded = false;
    private boolean allColumnsLoaded = false;
    private boolean relevant;
    private boolean dbAttrib;
    private MultiColumnFeature myMCFeature;
    private boolean hidden = true;

    public BaseAttribute(DB m4Db) {
        super(m4Db);
    }

    public M4Object load(long baId) throws SQLException, M4CompilerError {
        this.myId = baId;
        this.getM4Db().readBaseAttributeFromDB(this);
        this.allConceptsLoaded = false;
        this.allColumnsLoaded = false;
        return this;
    }

    public void print() {
        super.print();
        String toPrint = "Base Attribute " + this.getName() + " (Id: " + this.myId + "): " + this.dataTypeName + " of concepts: ";
        toPrint = this.myConcept != null ? String.valueOf(toPrint) + this.myConcept.getName() + ", " : String.valueOf(toPrint) + "(not loaded)";
        this.doPrint(4, toPrint);
        if (this.myColumns != null) {
            int i = 0;
            while (i < this.myColumns.length) {
                if (this.myColumns[i] != null) {
                    this.myColumns[i].print();
                }
                ++i;
            }
        }
    }

    public BaseAttribute copy() {
        BaseAttribute ret = new BaseAttribute(this.getM4Db());
        ret.setId(0L);
        ret.setConcept(this.myConcept);
        ret.setConceptualDataType(this.getConceptualDataType());
        ret.setConceptualDataTypeName(this.getConceptualDataTypeName());
        ret.setDBAttrib(this.isDBAttrib());
        ret.setMCFeature(this.getMCFeature());
        ret.setName(this.getName());
        ret.setRelevant(this.isRelevant());
        ret.setColumns(this.myColumns);
        return ret;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean h) {
        this.hidden = h;
    }

    public void addColumn(Column c) throws M4CompilerError {
        this.getColumns();
        if (this.myColumns == null) {
            this.myColumns = new Column[]{c};
        } else {
            Column[] newset = new Column[this.myColumns.length + 1];
            int i = 0;
            while (i < this.myColumns.length) {
                if (this.myColumns[i].getId() == c.getId() && c.getId() != 0L) {
                    return;
                }
                newset[i] = this.myColumns[i];
                ++i;
            }
            newset[this.myColumns.length] = c;
            this.myColumns = newset;
        }
    }

    public void setConcept(Concept c) {
        this.myConcept = c;
    }

    public void setConceptualDataType(long type) {
        this.dataType = type;
    }

    public long getConceptualDataType() {
        return this.dataType;
    }

    public void setConceptualDataTypeName(String dtname) {
        this.dataTypeName = dtname;
    }

    public String getConceptualDataTypeName() {
        return this.dataTypeName;
    }

    public void setColumns(Column[] cols) {
        this.myColumns = cols;
        this.allColumnsLoaded = true;
    }

    public Column[] getColumns() throws M4CompilerError {
        try {
            if (this.allColumnsLoaded) {
                return this.myColumns;
            }
            this.getM4Db().readColumnsForBA(this);
            this.allColumnsLoaded = true;
            return this.myColumns;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB error: " + sqle.getMessage());
        }
    }

    public Column getColumn(int index) throws M4CompilerError {
        this.getColumns();
        if (this.myColumns != null && index > -1 && index < this.myColumns.length) {
            return this.myColumns[index];
        }
        throw new M4CompilerError("BaseAttribute.getColumn(): No Columnarray exists, or wrong index!");
    }

    private Column getColumnForColumnSet(Columnset cs) throws M4CompilerError {
        this.getColumns();
        if (this.myColumns != null) {
            int i = 0;
            while (i < this.myColumns.length) {
                Columnset myCs;
                Column col = this.myColumns[i];
                if (col != null && (myCs = col.getColumnSet()) != null && myCs.getId() == cs.getId()) {
                    return col;
                }
                ++i;
            }
        }
        return null;
    }

    public Column getCurrentColumn() throws M4CompilerError {
        Concept c = this.getConcept();
        if (c != null) {
            Columnset cs = c.getCurrentColumnSet();
            return this.getColumnForColumnSet(cs);
        }
        return null;
    }

    public Concept getConcept() throws M4CompilerError {
        try {
            if (this.allConceptsLoaded) {
                return this.myConcept;
            }
            this.getM4Db().readConceptForBA(this);
            this.allConceptsLoaded = true;
            return this.myConcept;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB error: " + sqle.getMessage());
        }
    }

    public void setMCFeature(MultiColumnFeature mcf) {
        this.myMCFeature = mcf;
    }

    public MultiColumnFeature getMCFeature() {
        return this.myMCFeature;
    }

    public boolean isRelevant() {
        return this.relevant;
    }

    public void setRelevant(boolean r) {
        this.relevant = r;
    }

    public boolean isDBAttrib() {
        return this.dbAttrib;
    }

    public void setDBAttrib(boolean a) {
        this.dbAttrib = a;
    }

    public boolean hasColumns() throws M4CompilerError {
        Column[] columns = this.getColumns();
        return columns != null && columns.length != 0;
    }

    public Parameter createNewInstance() {
        return new BaseAttribute(this.getM4Db());
    }
}

