/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining.visualization;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import subgroupmining.Subgroup;

public class XYPlot
extends JPanel {
    float x_origin = 10.0f;
    float y_origin = 320.0f;
    public int mean;
    public float p0 = 0.5f;
    public float maxconf = 1.0f;
    public Subgroup current;

    public XYPlot() {
        this.setLayout(null);
    }

    public void paintComponent(Graphics graphics) {
        int i;
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        float p1 = this.p0;
        if (this.mean == 1) {
            p1 /= this.maxconf;
        }
        Line2D.Float x_axis = new Line2D.Float(this.x_origin, this.y_origin, this.x_origin + (float)300, this.y_origin);
        Line2D.Float y_axis = new Line2D.Float(this.x_origin, this.y_origin, this.x_origin, this.y_origin - (float)300);
        Line2D.Float max1 = new Line2D.Float(this.x_origin, this.y_origin - (float)300, this.x_origin + this.p0 * (float)300, this.y_origin - (float)300);
        Line2D.Float max2 = new Line2D.Float(this.x_origin + this.p0 * (float)300, this.y_origin - (float)300, this.x_origin + (float)300, this.y_origin - this.p0 * (float)300);
        Line2D.Float max3 = new Line2D.Float(this.x_origin, this.y_origin - (float)300 * p1, this.x_origin + (float)300, this.y_origin - p1 * (float)300);
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(Color.blue);
        g.draw(x_axis);
        g.setColor(Color.yellow);
        g.draw(y_axis);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.black);
        if (this.mean == 0) {
            g.draw(max1);
            g.draw(max2);
        }
        g.setColor(Color.red);
        g.draw(max3);
        g.setColor(Color.green);
        g.setStroke(new BasicStroke(2.0f));
        float q = (float)this.current.getQuality();
        float c = (float)this.current.getConceptShare();
        float c0 = (float)this.current.getConceptSize();
        float n = c0 / c;
        double v0 = this.mean == 0 ? (double)this.p0 * (double)(1.0f - this.p0) : this.current.getV0();
        double f1 = v0 / (double)n;
        float f = q * (float)Math.sqrt(f1);
        float inc = 0.05f;
        for (float i2 = 0.0f; i2 < 1.0f - inc; i2 += inc) {
            float x1 = 0.025f + i2;
            float x2 = 0.025f + inc + i2;
            double x11 = (double)(1.0f - x1) / (double)x1;
            double x21 = (double)(1.0f - x2) / (double)x2;
            float y1 = (this.p0 + f * (float)Math.sqrt(x11)) / this.maxconf;
            float y2 = (this.p0 + f * (float)Math.sqrt(x21)) / this.maxconf;
            if (!(y2 <= 1.0f) || !(y1 <= 1.0f)) continue;
            Line2D.Float isoline = new Line2D.Float(this.x_origin + x1 * (float)300, this.y_origin - y1 * (float)300, this.x_origin + x2 * (float)300, this.y_origin - y2 * (float)300);
            g.draw(isoline);
        }
        g.setColor(Color.red);
        if ((double)this.p0 > 0.1) {
            if (this.mean == 0) {
                g.drawString("f(T)", this.x_origin + (float)11, this.y_origin - (float)300 * this.p0 + (float)12);
            } else {
                g.drawString("Avg(T)/ max(S,Avg(T|S))", this.x_origin + (float)11, this.y_origin - (float)300 * p1 + (float)12);
            }
        }
        g.setColor(Color.black);
        for (i = 40; i < 330; i += 30) {
            g.drawLine(i, (int)(this.y_origin - (float)2), i, (int)(this.y_origin + (float)2));
        }
        for (i = 50; i < 310; i += 30) {
            g.drawLine((int)(this.x_origin - (float)2), i, (int)(this.x_origin + (float)2), i);
        }
        g.setColor(Color.blue);
        g.drawString("Support f(C)", this.x_origin + (float)70, this.y_origin - (float)10);
        g.setColor(Color.yellow);
        if (this.mean == 0) {
            g.drawString("Strength f(T|C)", this.x_origin - (float)8, 12.0f);
        } else {
            g.drawString("Strength: Avg(T|C) / max(S,Avg(T|S))", this.x_origin - (float)8, 12.0f);
        }
    }
}

