/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining.visualization;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import subgroupmining.Subgroup;

public class TableRenderer
extends DefaultTableCellRenderer {
    public int mean;
    public double maxconf;

    public TableRenderer(double maxconf, int mean) {
        this.maxconf = maxconf;
        this.mean = mean;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
        CellPanel jp = new CellPanel(value, row, column, isSelected, isFocused);
        return jp;
    }

    class CellPanel
    extends JLabel {
        Subgroup sg = null;

        public CellPanel(Object value, int row, int column, boolean isSelected, boolean isFocused) {
            this.setOpaque(true);
            this.sg = (Subgroup)value;
            if (isSelected) {
                this.setBackground(Color.orange);
            } else {
                this.setBackground(Color.white);
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            float h = this.getHeight();
            double d = this.sg.getConfidence();
            if (TableRenderer.this.mean == 1) {
                d /= TableRenderer.this.maxconf;
            }
            Rectangle2D.Float r3 = new Rectangle2D.Float(0.0f, h - (float)this.sg.getConceptShare() * h, 10.0f, (float)this.sg.getConceptShare() * h);
            g.setColor(Color.blue);
            g.fill(r3);
            g.setColor(Color.black);
            g.draw(r3);
            g.translate(10, 0);
            Rectangle2D.Float r4 = new Rectangle2D.Float(0.0f, h - (float)d * h, 10.0f, (float)d * h);
            g.setColor(Color.yellow);
            g.fill(r4);
            g.setColor(Color.black);
            g.draw(r4);
            g.translate(10, 0);
            Rectangle2D.Float r5 = new Rectangle2D.Float(0.0f, h - (float)this.sg.getQuality() * h / (float)10, 10.0f, (float)this.sg.getQuality() * h / (float)10);
            g.setColor(Color.green);
            g.fill(r5);
            g.setColor(Color.black);
            g.draw(r5);
        }
    }
}

