/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining.assocrulevis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import subgroupmining.HypothesisStore;
import subgroupmining.Subgroup;
import subgroupmining.assocrulevis.DoubleRenderer;
import subgroupmining.assocrulevis.SingleGroupPanel;
import subgroupmining.assocrulevis.TableRenderer;
import subgroupmining.assocrulevis.TableSorter;
import subgroupmining.assocrulevis.VisualSubgroup;
import subgroupmining.assocrulevis.XYPlot;

public class TwoKeyPlot
extends JPanel
implements ListSelectionListener {
    HypothesisStore subgroups = new HypothesisStore();
    XYPlot xyPlotPanel = new XYPlot();
    JSplitPane jSplitPane1 = new JSplitPane();
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane jSplitPane2 = new JSplitPane();
    public JTable table = new JTable();
    JScrollPane tableScroller = new JScrollPane();
    SingleGroupPanel singleGroup = new SingleGroupPanel();
    Font font = new Font("Sans Serif", 0, 9);
    public String targetValue;
    public double maxconf = 1.0;
    int mean;
    TableSorter ts;
    public static Subgroup current = null;
    String fileName = "hypothesis.txt";

    public TwoKeyPlot() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TwoKeyPlot tk = new TwoKeyPlot();
        HypothesisStore st = tk.load();
        tk.visualizeSubgroups(st);
        JFrame jf = new JFrame();
        jf.getContentPane().add(tk);
        jf.pack();
        jf.show();
    }

    public void visualizeSubgroups(HypothesisStore subgroups) {
        this.subgroups = subgroups;
        Subgroup sg = (Subgroup)subgroups.get(0);
        this.mean = sg.getSubgroupSize(0) > 0.0 ? 0 : 1;
        if (this.mean == 1) {
            this.maxconf = sg.getConfidence();
            for (int i = 1; i < subgroups.size(); ++i) {
                sg = (Subgroup)subgroups.get(i);
                if (!(sg.getConfidence() > this.maxconf)) continue;
                this.maxconf = sg.getConfidence();
            }
        }
        this.xyPlotPanel.mean = this.mean;
        this.xyPlotPanel.p0 = (float)((Subgroup)subgroups.get(0)).getP0();
        this.xyPlotPanel.maxconf = (float)this.maxconf;
        this.singleGroup.mean = this.mean;
        this.singleGroup.maxconf = (float)this.maxconf;
        this.ts = new TableSorter(null.new SubgroupTableModel(subgroups, this.maxconf, this.mean));
        this.ts.addMouseListenerToHeaderInTable(this.table);
        this.table.setModel(this.ts);
        this.table.getTableHeader().setFont(this.font);
        this.table.changeSelection(0, 0, false, false);
        TableColumn colQuality = this.table.getColumnModel().getColumn(1);
        colQuality.setMaxWidth(30);
        colQuality.setCellRenderer(new TableRenderer(this.maxconf, this.mean));
        colQuality.setPreferredWidth(30);
        TableColumn colQualityVal = this.table.getColumnModel().getColumn(2);
        colQualityVal.setMaxWidth(35);
        colQualityVal.setPreferredWidth(35);
        colQualityVal.setCellRenderer(new DoubleRenderer());
        TableColumn colShare = this.table.getColumnModel().getColumn(3);
        colShare.setMaxWidth(30);
        colShare.setPreferredWidth(30);
        colShare.setCellRenderer(new DoubleRenderer());
        TableColumn colConfidence = this.table.getColumnModel().getColumn(4);
        colConfidence.setMaxWidth(30);
        colConfidence.setPreferredWidth(30);
        colConfidence.setCellRenderer(new DoubleRenderer());
        TableColumn colSel = this.table.getColumnModel().getColumn(5);
        colSel.setMaxWidth(20);
        colSel.setPreferredWidth(20);
        colSel.setCellRenderer(new DoubleRenderer());
        TableColumn colSubgroup = this.table.getColumnModel().getColumn(0);
        colSubgroup.setMaxWidth(400);
        colSubgroup.setPreferredWidth(300);
        colSubgroup.sizeWidthToFit();
        colSubgroup.setCellRenderer(new DoubleRenderer());
        this.xyPlotPanel.removeAll();
        this.xyPlotPanel.setMinimumSize(new Dimension(300, 200));
        this.xyPlotPanel.setMaximumSize(new Dimension(500, 500));
        this.xyPlotPanel.setPreferredSize(new Dimension(300, 325));
        for (int i = 0; i < subgroups.size(); ++i) {
            sg = (Subgroup)subgroups.get(i);
            double d = sg.getConfidence();
            if (this.mean == 1) {
                d /= this.maxconf;
            }
            int x = (int)((double)10 + sg.getConceptShare() * (double)300);
            int y = (int)((double)320 - d * (double)300);
            VisualSubgroup vs = new VisualSubgroup(sg, this.maxconf, this.mean);
            vs.setSize(10, 10);
            vs.setLocation(x, y);
            vs.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    TwoKeyPlot.this.sg_mouseClicked(e);
                }
            });
            this.xyPlotPanel.add(vs);
        }
        this.validate();
    }

    public HypothesisStore getSelectedHypotheses() {
        HypothesisStore hS = new HypothesisStore();
        Double eins = new Double(1.0);
        for (int i = 0; i < this.subgroups.size(); ++i) {
            Subgroup s = (Subgroup)this.ts.getValueAt(i, 1);
            if (!((Double)this.ts.getValueAt(i, 7)).equals(eins)) continue;
            hS.add(s);
        }
        return hS;
    }

    public void setCluster() {
        for (int i = 0; i < this.subgroups.size(); ++i) {
            Subgroup s = (Subgroup)this.ts.getValueAt(i, 1);
            int c = s.getCluster();
            Double d = c == 0 ? new Double(999.0) : new Double(c);
            this.ts.setValueAt(d, i, 6);
        }
        this.table.repaint();
        this.xyPlotPanel.repaint();
    }

    void sg_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            VisualSubgroup vs0 = (VisualSubgroup)e.getSource();
            for (int i = 0; i < this.subgroups.size(); ++i) {
                if (this.ts.getValueAt(i, 1) != vs0.sg) continue;
                this.table.changeSelection(i, 0, false, false);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (row >= 0) {
            this.xyPlotPanel.current = current = (Subgroup)this.table.getModel().getValueAt(row, 1);
            this.xyPlotPanel.repaint();
            this.singleGroup.setSubgroup(current);
            this.validate();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jSplitPane1.setBackground(Color.white);
        this.jSplitPane1.setLeftComponent(this.tableScroller);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setLeftComponent(this.xyPlotPanel);
        this.jSplitPane2.setRightComponent(this.singleGroup);
        this.singleGroup.setBackground(Color.white);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TwoKeyPlot.this.table_mouseClicked(e);
            }
        });
        this.tableScroller.getViewport().setBackground(Color.white);
        this.xyPlotPanel.setBackground(Color.lightGray);
        this.add((Component)this.jSplitPane1, "Center");
        this.tableScroller.setViewportView(this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    public void save() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.fileName));
            out.writeObject(this.subgroups);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HypothesisStore load() {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.fileName));
            HypothesisStore hypothesisStore = (HypothesisStore)in.readObject();
            return hypothesisStore;
        }
        catch (Exception e) {
            e.printStackTrace();
            HypothesisStore hypothesisStore = null;
            return hypothesisStore;
        }
    }

    void this_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            boolean bl = false;
        }
    }

    void table_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int col = this.table.getSelectedColumn();
            if (col < 5) {
                this.ts.sortByColumn(col, false);
            } else if (col == 5) {
                Double eins = new Double(1.0);
                Double nulll = new Double(0.0);
                int row = this.table.getSelectedRow();
                if (((Double)this.table.getValueAt(row, col)).equals(eins)) {
                    this.table.setValueAt(nulll, row, col);
                } else {
                    this.table.setValueAt(eins, row, col);
                }
                this.table.repaint();
            }
        }
    }

    class SubgroupTableModel
    extends AbstractTableModel {
        HypothesisStore groups;
        Subgroup sg;
        Object[][] data;
        String[] columnNames = new String[]{"Description", "", "Qual", "Supp", "Strength", "Sel"};

        SubgroupTableModel(HypothesisStore groups, double maxconf, int mean) {
            this.groups = groups;
            this.data = new Object[groups.size()][6];
            for (int i = 0; i < groups.size(); ++i) {
                this.sg = (Subgroup)groups.get(i);
                this.data[i][0] = this.sg.toString1();
                this.data[i][1] = this.sg;
                this.data[i][2] = new Double(this.sg.getQuality());
                this.data[i][3] = new Double(this.sg.getConceptShare());
                this.data[i][4] = mean == 0 ? new Double(this.sg.getConfidence()) : new Double(this.sg.getConfidence() / maxconf);
                this.data[i][5] = new Double(1.0);
            }
        }

        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex > 1) {
                return Class.forName("java.lang.Double");
            }
            return this.data[columnIndex].getClass();
        }

        public int getRowCount() {
            return this.data.length;
        }

        public int getColumnCount() {
            return this.data[0].length;
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public void setValueAt(Object o, int row, int col) {
            this.data[row][col] = o;
        }
    }
}

