/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining;

import java.io.Serializable;
import subgroupmining.Subgroup;

public class SubgroupPair
implements Comparable,
Serializable {
    Subgroup parent;
    Subgroup successor;
    private double quality;

    Subgroup getParent() {
        return this.parent;
    }

    Subgroup getSuccessor() {
        return this.successor;
    }

    public SubgroupPair(Subgroup parent, Subgroup successor) {
        this.parent = parent;
        this.successor = successor;
    }

    public SubgroupPair() {
    }

    public double getQuality() {
        return this.quality;
    }

    public double calculateQuality() {
        Subgroup parent = this.getParent();
        Subgroup succ = this.getSuccessor();
        double n1 = 0.0;
        double v2 = succ.getV0();
        double n = succ.getConceptSize();
        if (parent != null && n < (n1 = parent.getConceptSize())) {
            n1 = n * n1 / (n1 - n);
        }
        this.quality = parent == null || parent.getConceptset().isEmpty() ? succ.getQuality() : (v2 == 0.0 ? 0.0 : Math.sqrt(n1 / v2) * (succ.getConfidence() - parent.getConfidence()));
        return this.quality;
    }

    public int compareTo(Object object) {
        SubgroupPair se = (SubgroupPair)object;
        double qual = se.getSuccessor().getQuality();
        double quality = this.successor.getQuality();
        if (quality > qual) {
            return -1;
        }
        if (qual > quality) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        SubgroupPair se = (SubgroupPair)object;
        return this.successor.equals(se.getSuccessor());
    }
}

