/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining;

import database.Database;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import subgroupmining.AttributeMeta;
import subgroupmining.Link;
import subgroupmining.QueryConstructor;
import subgroupmining.Relation;
import subgroupmining.RelationGraph;
import subgroupmining.TableMeta;
import subgroupmining.visualization.BarChart;
import subgroupmining.visualization.Triple;

public class DataChooserPanel
extends JPanel {
    JList tableList = new JList();
    JList ignoreFieldList = new JList();
    JList addFieldList = new JList();
    JList valueList = new JList();
    JList relationList = new JList();
    JList linkList = new JList();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JButton applyButton = new JButton();
    JButton applyLinkButton = new JButton();
    JButton defLinkButton = new JButton();
    JButton resetPrimButton = new JButton();
    JButton ignoreNumButton = new JButton();
    JButton ignoreAllButton = new JButton();
    JButton genMultiButton = new JButton();
    JButton applyDiscButton = new JButton();
    JButton dummyButton = new JButton();
    JToolBar jToolBar1 = new JToolBar();
    CheckboxGroup cbg1 = new CheckboxGroup();
    CheckboxGroup cbg0 = new CheckboxGroup();
    Panel p0 = new Panel();
    Panel p1 = new Panel();
    Checkbox cb1;
    Checkbox cb2;
    Checkbox cb3;
    Checkbox cb4;
    Checkbox cb5;
    Checkbox cb6;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane sp1 = new JScrollPane(this.tableList);
    JScrollPane sp2 = new JScrollPane(this.ignoreFieldList);
    JScrollPane sp3 = new JScrollPane(this.addFieldList);
    JScrollPane sp4 = new JScrollPane(this.valueList);
    JScrollPane sp5 = new JScrollPane(this.relationList);
    JScrollPane sp6 = new JScrollPane(this.linkList);
    public Database db;
    Vector addColumnNames = new Vector();
    Vector ignoreColumnNames = new Vector();
    Vector valueNames = new Vector();
    Vector relationNames = new Vector();
    Vector linkNames = new Vector();
    Vector linkrel1 = new Vector();
    Vector linkrel2 = new Vector();
    Vector linkconjs = new Vector();
    Vector linkconds = new Vector();
    Vector linkatts = new Vector();
    Object selectedTarget;
    boolean flag = true;
    boolean modflag = false;
    int linkstep = 0;
    String selection = "";
    Relation relation1;
    Relation relation2;
    int conj;
    int index;
    int clink = -1;
    String linkcond = "";
    String link;
    int ignorevalues;
    JTextField ivalues = new JTextField();
    JTextField r1 = new JTextField(22);
    JTextField r2 = new JTextField(22);
    protected Map parameters = new HashMap();
    public RelationGraph rg = null;
    public TableMeta currentTM = null;
    public String selectedKey = "KEY";
    String load = "";
    String sql = "";

    public Map getParameters() {
        return this.parameters;
    }

    public DataChooserPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    public DataChooserPanel(Database db) {
        this.db = db;
        Vector<String> tableModel = new Vector<String>();
        try {
            ResultSet rs = db.getOraTables();
            while (rs.next()) {
                tableModel.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
        this.tableList.setListData(tableModel);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.tableList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tableList.setToolTipText("Select Primary Table in Database");
        this.tableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataChooserPanel.this.tableList_valueChanged(e);
            }
        });
        this.tableList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DataChooserPanel.this.tableList_mouseClicked(e);
            }
        });
        this.ignoreFieldList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.ignoreFieldList.setToolTipText("Attributes to ignore from search");
        this.ignoreFieldList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DataChooserPanel.this.ignoreFieldList_mouseClicked(e);
            }
        });
        this.ignoreFieldList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataChooserPanel.this.ignoreFieldList_valueChanged(e);
            }
        });
        this.ignoreFieldList.setVisible(true);
        this.addFieldList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addFieldList.setToolTipText("Attributes to include in search and selected target attribute");
        this.addFieldList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DataChooserPanel.this.addFieldList_mouseClicked(e);
            }
        });
        this.addFieldList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataChooserPanel.this.addFieldList_valueChanged(e);
            }
        });
        this.addFieldList.setVisible(true);
        this.valueList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.valueList.setToolTipText("Values of selected attribute and select Target Value of Target Attribute");
        this.valueList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataChooserPanel.this.valueList_valueChanged(e);
            }
        });
        this.relationList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.relationList.setToolTipText("Secondary tables used in multirelational mining");
        this.relationList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DataChooserPanel.this.relationList_mouseClicked(e);
            }
        });
        this.relationList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataChooserPanel.this.relationList_valueChanged(e);
            }
        });
        this.relationList.setVisible(true);
        this.linkList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.linkList.setToolTipText("Links to be used for multirelational mining");
        this.linkList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DataChooserPanel.this.linkList_mouseClicked(e);
            }
        });
        this.linkList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataChooserPanel.this.linkList_valueChanged(e);
            }
        });
        this.linkList.setVisible(true);
        this.jLabel1.setText("    T1: Primary Table");
        this.jLabel2.setText("A2: Ignore Attributes");
        this.jLabel3.setText("A1: Include Attributes & Target Attribute");
        this.jLabel4.setText("V:  Attribute Values");
        this.jLabel5.setText("    T2: Primary & Secondary Tables (multirelational)");
        this.jLabel6.setText("L:  Links (multirelational)");
        this.p1.setLayout(new FlowLayout());
        this.cb1 = new Checkbox("Shift", this.cbg1, true);
        this.cb2 = new Checkbox("Select", this.cbg1, false);
        this.cb3 = new Checkbox("Chart", this.cbg1, false);
        this.cb4 = new Checkbox("Disc", this.cbg1, false);
        this.p1.add(this.cb1);
        this.p1.add(this.cb2);
        this.p1.add(this.cb3);
        this.p1.add(this.cb4);
        this.p0.setLayout(new FlowLayout());
        this.cb5 = new Checkbox("Move", this.cbg0, false);
        this.cb6 = new Checkbox("Select", this.cbg0, true);
        this.p0.add(this.cb5);
        this.p0.add(this.cb6);
        this.applyButton.setToolTipText("Apply primary table selections");
        this.applyButton.setText("ApplyPrim");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataChooserPanel.this.applyButton_actionPerformed(e);
            }
        });
        this.applyLinkButton.setToolTipText("Apply link definition");
        this.applyLinkButton.setText("ApplyLink");
        this.applyLinkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataChooserPanel.this.applyLinkButton_actionPerformed(e);
            }
        });
        this.defLinkButton.setToolTipText("Define new link");
        this.defLinkButton.setText("AddLink");
        this.defLinkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataChooserPanel.this.defLinkButton_actionPerformed(e);
            }
        });
        this.resetPrimButton.setToolTipText("Reset primary definition");
        this.resetPrimButton.setText("ResetPrimDef");
        this.resetPrimButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataChooserPanel.this.resetPrimButton_actionPerformed(e);
            }
        });
        this.ignoreNumButton.setToolTipText("Shift all non-string attributes to Ignore Attributes");
        this.ignoreNumButton.setText("ShiftNum.Attributes");
        this.ignoreNumButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataChooserPanel.this.ignoreNumButton_actionPerformed(e);
            }
        });
        this.ignoreAllButton.setToolTipText("Shift all attributes to Ignore Attributes");
        this.ignoreAllButton.setText("ShiftAllAttr.");
        this.ignoreAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataChooserPanel.this.ignoreAllButton_actionPerformed(e);
            }
        });
        this.genMultiButton.setToolTipText("Generate relation graph for multirelational links");
        this.genMultiButton.setText("CreateMultirelGraph");
        this.genMultiButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataChooserPanel.this.genMultiButton_actionPerformed(e);
            }
        });
        this.applyDiscButton.setToolTipText("Apply saved discretizations of numerical attributes for search");
        this.applyDiscButton.setText("ApplyDisc");
        this.applyDiscButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataChooserPanel.this.applyDiscButton_actionPerformed(e);
            }
        });
        this.dummyButton.setText(" ");
        this.ivalues.setText("0");
        this.jToolBar1.add(this.applyButton);
        this.jToolBar1.add(this.resetPrimButton);
        this.jToolBar1.add(this.ignoreNumButton);
        this.jToolBar1.add(this.ignoreAllButton);
        this.jToolBar1.add(this.ivalues);
        this.jToolBar1.add(this.dummyButton);
        this.jToolBar1.add(this.defLinkButton);
        this.jToolBar1.add(this.applyLinkButton);
        this.jToolBar1.add(this.genMultiButton);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.sp1, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 100, 0, 0), 0, 0));
        this.add((Component)this.sp5, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 100, 0, 0), 0, 0));
        this.add((Component)this.sp3, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.sp2, new GridBagConstraints(2, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.sp4, new GridBagConstraints(4, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 50), 0, 0));
        this.add((Component)this.sp6, new GridBagConstraints(4, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 50), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 80, 0, 0), 0, 0));
        this.add((Component)this.jLabel5, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 80, 0, 0), 0, 0));
        this.add((Component)this.jLabel3, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.jLabel4, new GridBagConstraints(4, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.jLabel6, new GridBagConstraints(4, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.p0, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)this.p1, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)this.r1, new GridBagConstraints(4, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)this.r2, new GridBagConstraints(4, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)this.applyDiscButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)this.jToolBar1, new GridBagConstraints(0, 6, 6, 1, 0.0, 0.0, 17, 0, new Insets(5, 80, 0, 0), 0, 0));
    }

    public String getLoad() {
        return this.load;
    }

    public String getSql() {
        return this.sql;
    }

    void tableList_mouseClicked(MouseEvent e) {
        int i = e.getClickCount();
        System.out.println(i);
        if (this.cb5.getState() && i == 2) {
            this.relationNames.add(this.tableList.getSelectedValue());
            this.relationList.setListData(this.relationNames);
            this.relationList.invalidate();
        }
    }

    void addFieldList_mouseClicked(MouseEvent e) {
        int i = e.getClickCount();
        if (i < 2) {
            return;
        }
        System.out.println(String.valueOf("Klicks: ").concat(String.valueOf(i)));
        if (this.cb1.getState()) {
            String svalue = (String)this.addFieldList.getSelectedValue();
            if (svalue == this.selectedTarget) {
                this.selectedTarget = null;
            }
            this.ignoreColumnNames.add(svalue);
            this.ignoreFieldList.setListData(this.ignoreColumnNames);
            this.ignoreFieldList.invalidate();
            this.addColumnNames.remove(this.addFieldList.getSelectedIndex());
            this.addFieldList.setListData(this.addColumnNames);
            if (this.selectedTarget != null) {
                this.addFieldList.setSelectedValue(this.selectedTarget, true);
            }
            this.addFieldList.invalidate();
        }
        if (this.cb3.getState()) {
            this.visualizeAtt((String)this.tableList.getSelectedValue(), (String)this.addFieldList.getSelectedValue());
        }
    }

    void ignoreFieldList_mouseClicked(MouseEvent e) {
        if (this.cb1.getState() && e.getClickCount() > 1) {
            this.addColumnNames.add(this.ignoreFieldList.getSelectedValue());
            this.addFieldList.setListData(this.addColumnNames);
            if (this.selectedTarget != null) {
                this.addFieldList.setSelectedValue(this.selectedTarget, true);
            }
            this.addFieldList.invalidate();
            this.ignoreColumnNames.remove(this.ignoreFieldList.getSelectedIndex());
            this.ignoreFieldList.setListData(this.ignoreColumnNames);
            this.ignoreFieldList.invalidate();
        }
    }

    void relationList_mouseClicked(MouseEvent e) {
        if (this.cb5.getState() && e.getClickCount() == 2) {
            this.relationNames.remove(this.relationList.getSelectedIndex());
            this.relationList.setListData(this.relationNames);
            this.relationList.invalidate();
        }
    }

    void linkList_mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        this.modflag = false;
        Object[] v = new Object[]{"modify", "cancel"};
        int index1 = this.linkList.getSelectedIndex();
        int option = JOptionPane.showOptionDialog(this, "Modify or cancel link definition?", (String)this.linkNames.get(this.index), 2, 3, null, v, v[0]);
        if (option == 1) {
            this.linkNames.remove(index1);
            this.linkrel1.remove(index1);
            this.linkrel2.remove(index1);
            this.linkconjs.remove(index1);
            this.linkconds.remove(index1);
            this.linkatts.remove(index1);
            this.flag = false;
            this.linkList.setListData(this.linkNames);
            this.flag = true;
            this.linkList.invalidate();
        } else if (option == 0) {
            this.modflag = true;
            this.index = index1;
            this.relation1 = (Relation)this.linkrel1.get(this.index);
            this.relation2 = (Relation)this.linkrel2.get(this.index);
            Integer ii = (Integer)this.linkconjs.get(this.index);
            this.conj = ii;
            this.linkcond = (String)this.linkconds.get(this.index);
            this.addColumnNames = (Vector)this.linkatts.get(this.index);
            this.defLinkButton_actionPerformed(null);
        }
    }

    void tableList_valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.cb6.getState()) {
            this.selectedTarget = null;
            this.addColumnNames = new Vector();
            this.currentTM = null;
            try {
                ResultSet meta = this.db.getMetaData().getColumns(null, null, this.tableList.getSelectedValue().toString(), null);
                while (meta.next()) {
                    this.addColumnNames.add(meta.getString(4));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.flag = false;
            this.addFieldList.setListData(this.addColumnNames);
            this.addFieldList.invalidate();
            this.ignoreColumnNames = new Vector();
            this.ignoreFieldList.setListData(this.ignoreColumnNames);
            this.ignoreFieldList.invalidate();
            this.valueNames = new Vector();
            this.valueList.setListData(this.valueNames);
            this.valueList.invalidate();
            this.flag = true;
        }
    }

    void addFieldList_valueChanged(ListSelectionEvent e) {
        if (this.cb2.getState() && !e.getValueIsAdjusting() && this.flag) {
            this.valueNames = new Vector();
            this.selectedTarget = this.addFieldList.getSelectedValue();
            String table = this.tableList.getSelectedValue().toString();
            String target = this.addFieldList.getSelectedValue().toString();
            this.valueNames = this.getValueList(table, target);
            this.valueList.setListData(this.valueNames);
            this.valueList.invalidate();
        }
    }

    public Vector getValueList(String table, String target) {
        int t = this.getType(table, target);
        if (t == 1 || t == 2) {
            return this.getValues(table, target);
        }
        return new Vector();
    }

    void ignoreFieldList_valueChanged(ListSelectionEvent e) {
        if (this.cb2.getState() && !e.getValueIsAdjusting() && this.flag) {
            this.valueNames = new Vector();
            this.selectedTarget = null;
            this.flag = false;
            int ind = this.addFieldList.getSelectedIndex();
            if (ind >= 0) {
                this.addFieldList.removeSelectionInterval(ind, ind);
            }
            this.flag = true;
            String table = this.tableList.getSelectedValue().toString();
            String target = this.ignoreFieldList.getSelectedValue().toString();
            this.valueNames = this.getValueList(table, target);
            this.valueList.setListData(this.valueNames);
            if (this.valueNames.isEmpty()) {
                this.selectedKey = this.ignoreFieldList.getSelectedValue().toString();
            }
            this.valueList.invalidate();
        }
    }

    void valueList_valueChanged(ListSelectionEvent e) {
    }

    void relationList_valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.linkstep > 0 && this.linkstep < 3 && this.flag) {
            this.selection = this.relationList.getSelectedValue().toString();
            this.defLinkButton_actionPerformed(null);
        }
    }

    void linkList_valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.flag) {
            this.r1.setText(this.linkrel1.get(this.linkList.getSelectedIndex()).toString());
            this.r2.setText(this.linkrel2.get(this.linkList.getSelectedIndex()).toString());
        }
    }

    void applyButton_actionPerformed(ActionEvent e) {
        this.load = "";
        if (this.tableList.getSelectedValue() != null) {
            this.load = this.tableList.getSelectedValue().toString();
        }
        StringBuffer sqlString = new StringBuffer("select ");
        for (int i = 0; i < this.addColumnNames.size(); ++i) {
            sqlString.append(this.addColumnNames.elementAt(i));
            if (i >= this.addColumnNames.size() - 1) continue;
            sqlString.append(',');
        }
        sqlString.append(" from ");
        this.sql = String.valueOf(sqlString.toString()).concat(String.valueOf(this.load));
        System.out.println(this.sql);
        if (!this.load.equals("") && this.selectedTarget != null) {
            if (this.valueList.getSelectedValue() == null) {
                this.parameters.put("target Value", "MEANPATTERN");
            } else {
                this.parameters.put("target Value", this.valueList.getSelectedValue().toString());
            }
            this.parameters.put("target Attribute", this.selectedTarget.toString());
            this.parameters.put("tableName", this.load);
            Vector v1 = (Vector)this.addColumnNames.clone();
            v1.remove(this.addFieldList.getSelectedValue());
            this.parameters.put("columnNames", v1);
        } else {
            JOptionPane.showMessageDialog(this, "No table or target attribute selected");
        }
    }

    void ignoreNumButton_actionPerformed(ActionEvent e) {
        if (this.tableList.getSelectedValue() == null) {
            return;
        }
        String table = this.tableList.getSelectedValue().toString();
        Vector v1 = (Vector)this.addColumnNames.clone();
        Iterator it = v1.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            String att = o.toString();
            int t = this.getType(table, att);
            if (t == 1 || t == 3) continue;
            this.ignoreColumnNames.add(o);
            this.addColumnNames.remove(o);
        }
        this.flag = false;
        this.ignoreFieldList.setListData(this.ignoreColumnNames);
        this.ignoreFieldList.invalidate();
        this.addFieldList.setListData(this.addColumnNames);
        this.addFieldList.invalidate();
        this.flag = true;
    }

    void ignoreAllButton_actionPerformed(ActionEvent e) {
        Vector v1 = (Vector)this.addColumnNames.clone();
        Iterator it = v1.iterator();
        this.ignorevalues = Integer.parseInt(this.ivalues.getText());
        while (it.hasNext()) {
            String column;
            String table;
            int typ;
            Object o = it.next();
            boolean b = true;
            if (this.ignorevalues > 0 && ((typ = this.getType(table = this.tableList.getSelectedValue().toString(), column = o.toString())) == 1 || typ == 2) && this.getNr(table, column) <= this.ignorevalues) {
                b = false;
            }
            if (!b) continue;
            this.ignoreColumnNames.add(o);
            this.addColumnNames.remove(o);
        }
        this.flag = false;
        this.ignoreFieldList.setListData(this.ignoreColumnNames);
        this.ignoreFieldList.invalidate();
        this.addFieldList.setListData(this.addColumnNames);
        this.addFieldList.invalidate();
        this.flag = true;
    }

    void applyLinkButton_actionPerformed(ActionEvent e) {
        if (this.modflag) {
            this.clink = this.index;
            this.modflag = false;
        }
        if (this.clink < 0) {
            JOptionPane.showMessageDialog(this, "No unapplied link definition available");
            return;
        }
        Vector cloneadd = (Vector)this.addColumnNames.clone();
        if (this.linkNames.size() < this.clink) {
            this.linkNames.add(this.link);
            this.linkrel1.add(this.relation1);
            this.linkrel2.add(this.relation2);
            this.linkconjs.add(new Integer(this.conj));
            this.linkconds.add(this.linkcond);
            this.linkatts.add(cloneadd);
            this.flag = false;
            this.linkList.setListData(this.linkNames);
            this.linkList.invalidate();
            this.flag = true;
        } else {
            this.linkrel1.setElementAt(this.relation1, this.clink);
            this.linkrel2.setElementAt(this.relation2, this.clink);
            this.linkconjs.setElementAt(new Integer(this.conj), this.clink);
            this.linkconds.setElementAt(this.linkcond, this.clink);
            this.linkatts.setElementAt(cloneadd, this.clink);
        }
        this.clink = -1;
    }

    void defLinkButton_actionPerformed(ActionEvent e) {
        this.clink = -1;
        int ind = this.relationList.getSelectedIndex();
        this.flag = false;
        if (ind >= 0) {
            this.relationList.removeSelectionInterval(ind, ind);
        }
        this.flag = true;
        this.link = this.modflag ? (String)this.linkNames.get(this.index) : String.valueOf("Link").concat(String.valueOf(this.linkNames.size() + 1));
        if (this.linkstep == 0) {
            int option = JOptionPane.showConfirmDialog(this, "Now select first and then second relation from T2", String.valueOf("Defining Link: ").concat(String.valueOf(this.link)), 2);
            if (option != 0) {
                return;
            }
            this.r1.setText("");
            this.r2.setText("");
            this.linkstep = 1;
            return;
        }
        if (this.linkstep == 1) {
            this.linkstep = 0;
            this.relation1 = new Relation(this.selection);
            this.r1.setText(this.relation1.toString());
            this.linkstep = 2;
            return;
        }
        if (this.linkstep == 2) {
            int option;
            this.linkstep = 0;
            this.relation2 = new Relation(this.selection);
            this.r2.setText(this.relation2.toString());
            String input = JOptionPane.showInputDialog(this, "Maximal number of conjunctions:", String.valueOf("Defining Link: ").concat(String.valueOf(this.link)), 2);
            if (input == null) {
                return;
            }
            this.conj = Integer.parseInt(input);
            this.linkcond = JOptionPane.showInputDialog(this, "Only input when non standard link condition:", String.valueOf("Defining Link: ").concat(String.valueOf(this.link)), 2);
            if (this.linkcond == null) {
                this.linkcond = "";
            }
            if ((option = JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf("Now collect attributes in A1 for ").concat(String.valueOf(this.relation2))).concat(String.valueOf(" and finally press applyLink button")), String.valueOf("Defining Link: ").concat(String.valueOf(this.link)), 2)) != 0) {
                return;
            }
            this.addColumnNames = new Vector();
            try {
                ResultSet meta = this.db.getMetaData().getColumns(null, null, this.relation2.toString(), null);
                while (meta.next()) {
                    this.addColumnNames.add(meta.getString(4));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.flag = false;
            this.addFieldList.setListData(this.addColumnNames);
            this.addFieldList.invalidate();
            this.ignoreColumnNames = new Vector();
            this.ignoreFieldList.setListData(this.ignoreColumnNames);
            this.ignoreFieldList.invalidate();
            this.valueNames = new Vector();
            this.valueList.setListData(this.valueNames);
            this.valueList.invalidate();
            this.flag = true;
            this.clink = this.modflag ? this.index : this.linkNames.size() + 1;
            this.modflag = false;
        }
    }

    void resetPrimButton_actionPerformed(ActionEvent e) {
        if (this.parameters.size() < 4) {
            JOptionPane.showMessageDialog(this, "No applied primary definition available");
            return;
        }
        String table = (String)this.parameters.get("tableName");
        Vector vv = (Vector)this.parameters.get("columnNames");
        this.addColumnNames = (Vector)vv.clone();
        String target = (String)this.parameters.get("target Attribute");
        String targetvalue = (String)this.parameters.get("target Value");
        this.cb5.setState(true);
        this.tableList.setSelectedValue(table, true);
        this.tableList.invalidate();
        this.cb6.setState(true);
        this.addColumnNames.add(target);
        this.flag = false;
        this.addFieldList.setListData(this.addColumnNames);
        this.addFieldList.setSelectedValue(target, true);
        this.addFieldList.invalidate();
        this.ignoreColumnNames = new Vector();
        try {
            ResultSet meta = this.db.getMetaData().getColumns(null, null, table, null);
            while (meta.next()) {
                this.ignoreColumnNames.add(meta.getString(4));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < this.addColumnNames.size(); ++i) {
            this.ignoreColumnNames.remove((String)this.addColumnNames.get(i));
        }
        this.ignoreFieldList.setListData(this.ignoreColumnNames);
        this.ignoreFieldList.invalidate();
        this.valueNames = new Vector();
        this.valueList.setListData(this.valueNames);
        this.valueList.invalidate();
        this.flag = true;
    }

    void genMultiButton_actionPerformed(ActionEvent e) {
        Vector c;
        if (this.parameters.size() < 4) {
            JOptionPane.showMessageDialog(this, "No applied primary definition available");
            return;
        }
        if (this.linkNames.size() == 0) {
            JOptionPane.showMessageDialog(this, "No links defined");
            return;
        }
        String table = (String)this.parameters.get("tableName");
        this.rg = new RelationGraph();
        ArrayList relations = this.rg.relations;
        ArrayList links = this.rg.links;
        Relation r0 = new Relation(table);
        r0.setID(0);
        relations.add(r0);
        int i1 = 1;
        for (int i = 0; i < this.relationNames.size(); ++i) {
            String rs = (String)this.relationNames.get(i);
            if (rs == table) continue;
            Relation r = new Relation(rs);
            r.setID(i1);
            ++i1;
            relations.add(r);
        }
        Link l0 = new Link(r0, r0);
        l0.setID(0);
        l0.setMaxConjunctions(1);
        l0.setLinkCondition("");
        l0.attributes = c = (Vector)this.parameters.get("columnNames");
        links.add(l0);
        for (int i = 0; i < this.linkNames.size(); ++i) {
            Relation rela1 = (Relation)this.linkrel1.get(i);
            Relation rela2 = (Relation)this.linkrel2.get(i);
            Link l = new Link(rela1, rela2);
            l.setID(i + 1);
            Integer ii = (Integer)this.linkconjs.get(i);
            l.setMaxConjunctions(ii);
            String s = (String)this.linkconds.get(i);
            System.out.println(String.valueOf("Linkcondition: ").concat(String.valueOf(s)));
            if (s.trim().equals("")) {
                s = this.stdcond(rela1, rela2);
            }
            l.setLinkCondition(s);
            l.attributes = (Vector)((Vector)this.linkatts.get(i)).clone();
            links.add(l);
        }
        JOptionPane.showMessageDialog(this, "Multirelational Graph defined");
    }

    void applyDiscButton_actionPerformed(ActionEvent e) {
        TableMeta tM = null;
        int flag = 0;
        String table = this.tableList.getSelectedValue().toString();
        this.currentTM = new TableMeta(table, this.db);
        this.currentTM.meta = new HashMap();
        Iterator it = this.addColumnNames.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            String att = o.toString();
            int typ = this.getType(table, att);
            if (++flag == 1) {
                tM = (TableMeta)this.db.metaDataMap.get(table);
            }
            if (typ < 2) continue;
            AttributeMeta aM = tM.getAttributeMeta(att);
            Vector v = aM.getDisc();
            Vector w = aM.getDiscInd();
            if (v == null && tM.metaflag) {
                TableMeta tM1 = new TableMeta(table, this.db);
                if (tM1.retrieve1Meta() == 1 && tM1.meta.get(att) != null) {
                    v = ((AttributeMeta)tM1.meta.get(att)).getDisc();
                }
                if (v != null) {
                    w = ((AttributeMeta)tM1.meta.get(att)).getDiscInd();
                    aM.setDisc(v, w);
                }
            }
            if (v == null) continue;
            AttributeMeta aM1 = new AttributeMeta(att, table, tM.metaflag);
            aM1.setDisc(v, w);
            this.currentTM.meta.put(att, aM1);
            System.out.println(String.valueOf("Discretization added for: ").concat(String.valueOf(att)));
        }
    }

    void resetRG() {
        Link l;
        int i;
        ArrayList relations = this.rg.relations;
        ArrayList links = this.rg.links;
        this.relationNames = new Vector();
        this.linkNames = new Vector();
        this.linkrel1 = new Vector();
        this.linkrel2 = new Vector();
        this.linkconjs = new Vector();
        this.linkconds = new Vector();
        this.linkatts = new Vector();
        for (i = 0; i < relations.size(); ++i) {
            String rs = ((Relation)relations.get(i)).toString();
            this.relationNames.add(rs);
        }
        for (i = 1; i < links.size(); ++i) {
            l = (Link)links.get(i);
            this.linkNames.add(l.toString());
            Relation r = l.getParent();
            this.linkrel1.add(r.toString());
            r = l.getSuccessor();
            this.linkrel2.add(r.toString());
            Integer ii = new Integer(l.getMaxConjunctions());
            this.linkconjs.add(ii);
            this.linkconds.add(l.getLinkCondition());
            Vector vcl = (Vector)l.attributes.clone();
            this.linkatts.add(vcl);
        }
        l = (Link)links.get(1);
        this.r1.setText(l.getParent().toString());
        this.r2.setText(l.getSuccessor().toString());
        this.flag = false;
        this.linkList.setListData(this.linkNames);
        this.relationList.setListData(this.relationNames);
        this.linkList.setSelectedIndex(0);
        this.flag = true;
        this.relationList.invalidate();
        this.linkList.invalidate();
    }

    String stdcond(Relation r1, Relation r2) {
        String rs1 = r1.toString();
        String rs2 = r2.toString();
        String cond = String.valueOf(String.valueOf(String.valueOf(String.valueOf("MDSYS.SDO_Filter(").concat(String.valueOf(rs1))).concat(String.valueOf(".GEOM,"))).concat(String.valueOf(rs2))).concat(String.valueOf(".GEOM,'mask=ANYINTERACT querytype=join') = 'TRUE'"));
        return cond;
    }

    String stdcond1(Relation r1, Relation r2) {
        String rs1 = r1.toString();
        String rs2 = r2.toString();
        String cond = String.valueOf(String.valueOf(String.valueOf(String.valueOf("MDSYS.SDO_RELATE(").concat(String.valueOf(rs1))).concat(String.valueOf(".GEOM,"))).concat(String.valueOf(rs2))).concat(String.valueOf(".GEOM,'mask=ANYINTERACT querytype=join') = 'TRUE'"));
        return cond;
    }

    public AttributeMeta getAttributeMeta(String table, String att) {
        AttributeMeta aM;
        TableMeta tM = (TableMeta)this.db.metaDataMap.get(table);
        if (tM == null) {
            tM = new TableMeta(table, this.db);
            aM = tM.getAttributeMeta(att);
            this.db.metaDataMap.put(table, tM);
        } else {
            aM = tM.getAttributeMeta(att);
        }
        return aM;
    }

    public int getPopSize(String table) {
        TableMeta tM = (TableMeta)this.db.metaDataMap.get(table);
        if (tM == null) {
            tM = new TableMeta(table, this.db);
            tM.retrieveMeta();
            this.db.metaDataMap.put(table, tM);
        }
        int p = (Integer)tM.meta.get("***");
        return p;
    }

    public int getType(String table, String att) {
        AttributeMeta aM = this.getAttributeMeta(table, att);
        return aM.type;
    }

    public int getNr(String table, String att) {
        AttributeMeta aM = this.getAttributeMeta(table, att);
        return aM.getNr();
    }

    public String getAverage(String table, String att) {
        AttributeMeta aM = this.getAttributeMeta(table, att);
        return aM.average;
    }

    public String getVariance(String table, String att) {
        AttributeMeta aM = this.getAttributeMeta(table, att);
        return aM.variance;
    }

    public float getMin(String table, String att) {
        AttributeMeta aM = this.getAttributeMeta(table, att);
        return aM.min;
    }

    public float getMax(String table, String att) {
        AttributeMeta aM = this.getAttributeMeta(table, att);
        return aM.max;
    }

    public Vector getValues(String table, String att) {
        AttributeMeta aM = this.getAttributeMeta(table, att);
        return aM.getValues();
    }

    public Vector getCounts(String table, String att) {
        Vector v = new Vector();
        AttributeMeta aM = this.getAttributeMeta(table, att);
        return aM.getCounts();
    }

    public int getCount(String table, String att, String val) {
        AttributeMeta aM = this.getAttributeMeta(table, att);
        return aM.getCount(val);
    }

    public void storeDiscr(String table, String att, Vector v, Vector w) {
        AttributeMeta aM = this.getAttributeMeta(table, att);
        aM.setDisc(v, w);
        TableMeta tM = (TableMeta)this.db.metaDataMap.get(table);
        tM.store1Meta();
    }

    public Vector loadDiscVals(String table, String att) {
        AttributeMeta aM = this.getAttributeMeta(table, att);
        Vector v = aM.getDisc();
        if (v == null) {
            TableMeta tM1;
            TableMeta tM = (TableMeta)this.db.metaDataMap.get(table);
            if (tM.metaflag && (tM1 = new TableMeta(table, this.db)).retrieve1Meta() == 1 && tM1.meta.get(att) != null) {
                v = ((AttributeMeta)tM1.meta.get(att)).getDisc();
            }
        }
        return v;
    }

    void visualizeAtt(String table, String att) {
        System.out.println(String.valueOf(String.valueOf(String.valueOf("BAR chart for: ").concat(String.valueOf(table))).concat(String.valueOf("."))).concat(String.valueOf(att)));
        JFrame jf = new JFrame();
        jf.setTitle(String.valueOf(String.valueOf(table).concat(String.valueOf("."))).concat(String.valueOf(att)));
        jf.setLocation(50, 250);
        jf.setSize(800, 320);
        jf.setDefaultCloseOperation(2);
        int t = this.getType(table, att);
        int nr = this.getNr(table, att);
        if (t > 0) {
            Vector vals;
            int mode = 0;
            int tt = 0;
            boolean conti = false;
            boolean plustarget = false;
            if (t == 3 && nr > 100) {
                vals = new Vector();
                mode = 3;
            } else {
                vals = this.getValues(table, att);
            }
            Vector counts = this.getCounts(table, att);
            int popS = this.getPopSize(table);
            Vector counts1 = new Vector();
            String st = (String)this.selectedTarget;
            Object stv = this.valueList.getSelectedValue();
            if (st != null) {
                jf.setTitle(String.valueOf(String.valueOf(String.valueOf(String.valueOf(table).concat(String.valueOf("."))).concat(String.valueOf(att))).concat(String.valueOf("  Target: "))).concat(String.valueOf(st)));
                tt = this.getType(table, st);
                plustarget = true;
                if ((tt == 1 || tt == 2) && stv != null) {
                    jf.setTitle(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(table).concat(String.valueOf("."))).concat(String.valueOf(att))).concat(String.valueOf("  Target: "))).concat(String.valueOf(st))).concat(String.valueOf(" = "))).concat(String.valueOf(stv)));
                    counts1 = this.getTargetShares(vals, table, att, st, stv.toString(), tt, t, nr);
                } else if (tt == 3) {
                    counts1 = this.getTargetMeans(vals, counts, table, att, st, t, nr);
                    conti = true;
                } else {
                    plustarget = false;
                }
            }
            Vector<Triple> vec = new Vector<Triple>();
            for (int i = 0; i < counts.size(); ++i) {
                Object value;
                Number i3 = null;
                if (t == 1) {
                    value = (String)vals.get(i);
                    mode = 1;
                } else if (nr < 101) {
                    value = new Double((String)vals.get(i));
                    mode = 2;
                } else {
                    value = new Double(String.valueOf("").concat(String.valueOf(i + 1)));
                }
                if (counts1.size() > 0 && tt < 3) {
                    i3 = (Integer)counts1.get(i);
                } else if (counts1.size() > 0 && tt == 3) {
                    i3 = (Double)counts1.get(i);
                }
                Triple tp = new Triple(value, (Integer)counts.get(i), i3);
                vec.add(tp);
            }
            BarChart bc = new BarChart(vec, mode, plustarget, popS, conti, table, att, this);
            jf.getContentPane().add(bc);
            jf.show();
        }
    }

    Vector getTargetShares(Vector vals, String table, String att, String st, String stv, int typet, int type, int nr) {
        Vector<Integer> counts1 = new Vector<Integer>();
        int a = vals.size();
        if (a == 0) {
            a = 100;
        }
        for (int i = 0; i < a; ++i) {
            counts1.add(new Integer(0));
        }
        boolean mode = false;
        if (type == 3 && nr > 100) {
            String query = QueryConstructor.makeTargetShareContQuery(table, st, stv, typet, att, this.getMin(table, att), this.getMax(table, att));
            ResultSet rs = this.db.select(query);
            int[] n = new int[100];
            try {
                while (rs.next()) {
                    int i;
                    n[0] = rs.getInt(1);
                    int cs = n[0];
                    for (i = 1; i < 100; ++i) {
                        n[i] = rs.getInt(i + 1) - cs;
                        cs += n[i];
                    }
                    for (i = 0; i < 100; ++i) {
                        counts1.set(i, new Integer(n[i]));
                    }
                    System.out.println(String.valueOf("NT:").concat(String.valueOf(cs)));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            String query = QueryConstructor.makeTargetShareQuery(table, st, att);
            ResultSet rs = this.db.select(query);
            try {
                block8: while (rs.next()) {
                    String tv = rs.getString(1).trim();
                    String av = rs.getString(2).trim();
                    int c = rs.getInt(3);
                    if (!tv.equals(stv)) continue;
                    for (int i = 0; i < vals.size(); ++i) {
                        if (!av.equals((String)vals.get(i))) continue;
                        counts1.set(i, new Integer(c));
                        continue block8;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Vector vector = null;
                return vector;
            }
        }
        return counts1;
    }

    Vector getTargetMeans(Vector vals, Vector counts, String table, String att, String st, int type, int nr) {
        Vector<Double> counts1 = new Vector<Double>();
        int a = vals.size();
        if (a == 0) {
            a = 100;
        }
        for (int i = 0; i < a; ++i) {
            counts1.add(new Double(0.0));
        }
        boolean mode = false;
        if (type == 3 && nr > 100) {
            String query = QueryConstructor.makeTargetMeanContQuery(table, st, att, this.getMin(table, att), this.getMax(table, att));
            ResultSet rs = this.db.select(query);
            double[] n = new double[100];
            try {
                while (rs.next()) {
                    int i;
                    n[0] = rs.getDouble(1);
                    double cs = n[0];
                    for (i = 1; i < 100; ++i) {
                        n[i] = rs.getDouble(i + 1) - cs;
                        cs += n[i];
                    }
                    for (i = 0; i < 100; ++i) {
                        double ni = ((Integer)counts.get(i)).doubleValue();
                        double av = 0.0;
                        if (ni > 0.0) {
                            av = n[i] / ni;
                        }
                        counts1.set(i, new Double(av));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            String query = QueryConstructor.makeTargetMeanQuery(table, st, att);
            ResultSet rs = this.db.select(query);
            try {
                block8: while (rs.next()) {
                    String av = rs.getString(1).trim();
                    double d = rs.getDouble(2);
                    for (int i = 0; i < vals.size(); ++i) {
                        if (!av.equals((String)vals.get(i))) continue;
                        counts1.set(i, new Double(d));
                        continue block8;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Vector vector = null;
                return vector;
            }
        }
        return counts1;
    }
}

