/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining;

import database.Database;
import java.sql.ResultSet;
import java.util.Collections;
import javax.swing.JTextArea;
import subgroupmining.DataChooserPanel;
import subgroupmining.HypothesisStore;
import subgroupmining.QueryConstructor;
import subgroupmining.RelationGraph;
import subgroupmining.Subgroup;
import subgroupmining.visualization.TwoKeyPlot;

public class CausalNet {
    protected String key;
    protected DataChooserPanel dcp;
    protected Database db;
    protected String target;
    protected String targetval;
    protected int targets;
    private String table;
    private HypothesisStore bestHypothesisList;
    private JTextArea resultArea;
    protected Subgroup rootHypothesis;
    protected double populationSize;
    protected RelationGraph theRelationGraph;
    private double minsim;
    private int[][][] counts = new int[99][][];
    private int[][] adjacent = new int[100][];
    private int[][] sepset = new int[100][];
    private float[][] chi2 = new float[100][];
    private float[][] sim = new float[99][];
    private int[][] clust = new int[99][];
    private int nsubgroups;
    private float clusterThreshold;
    private int countflag = 0;
    private float thresh = 4.0f;
    private float efak = 0.03f;
    private TwoKeyPlot twoKeyPlot;

    public CausalNet(String key, Database db, String target, String targetval, int targets, String table, HypothesisStore bestHypothesisList1, JTextArea resultArea, Subgroup rootHypothesis, double populationSize, double minsim, RelationGraph theRelationGraph, DataChooserPanel dcp, TwoKeyPlot tkp) {
        int i;
        Collections.sort(bestHypothesisList1);
        resultArea.append(String.valueOf(bestHypothesisList1.toString()).concat(String.valueOf("\n")));
        this.dcp = dcp;
        this.key = key;
        this.db = db;
        this.target = target;
        this.targetval = targetval;
        this.targets = targets;
        this.table = table;
        this.bestHypothesisList = bestHypothesisList1;
        this.resultArea = resultArea;
        this.rootHypothesis = rootHypothesis;
        this.populationSize = populationSize;
        this.theRelationGraph = theRelationGraph;
        this.twoKeyPlot = tkp;
        this.minsim = minsim;
        this.nsubgroups = this.bestHypothesisList.size() > 100 ? 100 : this.bestHypothesisList.size();
        for (i = 0; i < this.nsubgroups; ++i) {
            this.adjacent[i] = new int[this.nsubgroups - i];
            this.sepset[i] = new int[this.nsubgroups - i];
            this.clust[i] = new int[this.nsubgroups - i + 2];
            this.chi2[i] = new float[this.nsubgroups - i];
        }
        for (i = 0; i < this.nsubgroups - 1; ++i) {
            this.counts[i] = new int[this.nsubgroups - 1 - i][2];
            this.sim[i] = new float[this.nsubgroups - 1 - i];
            for (int j = 0; j < this.nsubgroups - 1 - i; ++j) {
                this.counts[i][j][0] = 0;
                this.counts[i][j][1] = 0;
            }
        }
    }

    public int cluster(int ncluster) {
        int j3;
        int i0;
        if (this.countflag == 0) {
            this.dbTargetValueQuery2();
            this.countflag = 1;
        }
        if (ncluster == 0) {
            this.calcsim(this.populationSize);
            for (int i = 0; i < this.nsubgroups; ++i) {
                for (int j = 0; j < this.nsubgroups - i + 1; ++j) {
                    this.clust[i][j] = j == 0 ? i : -1;
                }
            }
            ncluster = this.nsubgroups;
        }
        int[] ij = new int[2];
        if (ncluster < 2) {
            return -1;
        }
        int n = ncluster;
        ij = this.calcmaxij(n);
        float max = this.sim[ij[0]][ij[1]];
        this.clusterThreshold = max - 0.1f;
        if ((double)this.clusterThreshold < this.minsim - 0.1) {
            return -1;
        }
        while (n > 1 && max >= this.clusterThreshold) {
            String text = "Clustering ";
            text = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(text).concat(String.valueOf(n))).concat(String.valueOf(" Subgroups: Largest Overlap between Subgroup "))).concat(String.valueOf(ij[0] + 1))).concat(String.valueOf(" and Subgroup "))).concat(String.valueOf(ij[0] + ij[1] + 2))).concat(String.valueOf(": "))).concat(String.valueOf(max))).concat(String.valueOf("\n"));
            this.resultArea.append(text);
            for (int i = 0; i < n; ++i) {
                int j;
                if (i < ij[0]) {
                    for (j = 0; j < n - 1 - i; ++j) {
                        if (j == ij[0] - i - 1) {
                            this.sim[i][j] = Math.min(this.sim[i][j], this.sim[i][ij[0] + ij[1] - i]);
                        }
                        if (j <= ij[0] + ij[1] - i) continue;
                        this.sim[i][j - 1] = this.sim[i][j];
                    }
                }
                if (i == ij[0]) {
                    int j0 = 0;
                    while (this.clust[i][j0] != -1) {
                        ++j0;
                    }
                    int j1 = 0;
                    while (this.clust[i + ij[1] + 1][j1] != -1) {
                        this.clust[i][j0] = this.clust[i + ij[1] + 1][j1];
                        ++j0;
                        ++j1;
                    }
                    for (int j2 = 0; j2 < n - 1 - i; ++j2) {
                        if (j2 < ij[1]) {
                            this.sim[i][j2] = Math.min(this.sim[i][j2], this.sim[i + j2 + 1][ij[1] - 1 - j2]);
                        }
                        if (j2 <= ij[1]) continue;
                        this.sim[i][j2 - 1] = Math.min(this.sim[i][j2], this.sim[i + ij[1] + 1][j2 - ij[1] - 1]);
                    }
                }
                if (i > ij[0] && i < ij[0] + ij[1] + 1) {
                    for (j = 0; j < n - 1 - i; ++j) {
                        if (j <= ij[0] + ij[1] - i) continue;
                        this.sim[i][j - 1] = this.sim[i][j];
                    }
                }
                if (i <= ij[0] + ij[1] + 1) continue;
                int j2 = 0;
                while (this.clust[i][j2] != -1) {
                    this.clust[i - 1][j2] = this.clust[i][j2];
                    ++j2;
                }
                for (int jjj = j2; jjj < this.nsubgroups - i + 2; ++jjj) {
                    this.clust[i - 1][jjj] = -1;
                }
                for (int j4 = 0; j4 < n - 1 - i; ++j4) {
                    this.sim[i - 1][j4] = this.sim[i][j4];
                }
            }
            this.clust[n - 1][0] = -1;
            ij = this.calcmaxij(--n);
            max = this.sim[ij[0]][ij[1]];
            for (i0 = 0; i0 < this.nsubgroups - 1; ++i0) {
                j3 = 0;
                while (this.clust[i0][j3] != -1) {
                    ++j3;
                }
            }
            ncluster = n;
        }
        int cflag = 0;
        for (i0 = 0; i0 < this.nsubgroups - 1; ++i0) {
            j3 = 0;
            String text = String.valueOf(String.valueOf("Cluster ").concat(String.valueOf(i0 + 1))).concat(String.valueOf(": "));
            while (this.clust[i0][j3] != -1) {
                text = String.valueOf(String.valueOf(text).concat(String.valueOf(this.clust[i0][j3] + 1))).concat(String.valueOf(" "));
                ++j3;
            }
            text = String.valueOf(text).concat(String.valueOf("\n"));
            if (j3 > 0) {
                this.resultArea.append(text);
            }
            if (j3 <= 1) continue;
            ++cflag;
            for (int i9 = 0; i9 < j3; ++i9) {
                Subgroup s = (Subgroup)this.bestHypothesisList.get(this.clust[i0][i9]);
                s.setCluster(cflag);
            }
        }
        if (cflag > 0) {
            this.resultArea.append("\n");
            this.twoKeyPlot.setCluster();
        }
        return ncluster;
    }

    public int getclust(int i, int j) {
        return this.clust[i][j];
    }

    public int[] calcmaxij(int n) {
        int[] ij = new int[]{0, 0};
        float max = this.sim[0][0];
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n - 1 - i; ++j) {
                if (!(this.sim[i][j] > max)) continue;
                ij[0] = i;
                ij[1] = j;
                max = this.sim[i][j];
            }
        }
        return ij;
    }

    public int suppress() {
        if (this.countflag == 0) {
            this.dbTargetValueQuery2();
            this.countflag = 1;
        }
        for (int i = 0; i < this.nsubgroups; ++i) {
            for (int j = 0; j < this.nsubgroups - i; ++j) {
                this.adjacent[i][j] = 1;
                this.sepset[i][j] = -1;
            }
        }
        this.independencies();
        this.condIndSubgrTargetGivenSubgr();
        int ns = this.printadj1();
        return ns;
    }

    public int suppress1() {
        if (this.countflag == 0) {
            this.dbTargetValueQuery2();
            this.countflag = 1;
        }
        for (int i = 0; i < this.nsubgroups; ++i) {
            for (int j = 0; j < this.nsubgroups - i; ++j) {
                this.adjacent[i][j] = 1;
                this.sepset[i][j] = -1;
            }
        }
        this.modelbasedsup();
        int ns = this.printadj1();
        return ns;
    }

    public int derive() {
        if (this.countflag == 0) {
            this.dbTargetValueQuery2();
            this.countflag = 1;
        }
        for (int i = 0; i < this.nsubgroups; ++i) {
            for (int j = 0; j < this.nsubgroups - i; ++j) {
                this.adjacent[i][j] = 1;
                this.sepset[i][j] = -1;
            }
        }
        this.independencies();
        this.condIndSubgrTargetGivenSubgr();
        if (this.targetval != "MEANPATTERN") {
            this.condIndSubgrSubgrGivenTarget();
        }
        this.condIndSubgrSubgrGivenSubgr();
        this.printadj();
        this.analyseSepset();
        this.printdir1();
        this.analyseUndir();
        this.printdir2();
        return 0;
    }

    protected void dbTargetValueQuery2() {
        String query = this.theRelationGraph != null ? QueryConstructor.makeTargetSupportQuery2(this.key, this.target, this.targetval, this.table, this.bestHypothesisList, this.nsubgroups, this.theRelationGraph, this.dcp) : QueryConstructor.makeTargetSupportQuery2(this.target, this.targetval, this.table, this.bestHypothesisList, this.nsubgroups, this.dcp);
        ResultSet rs = this.db.select(query);
        try {
            int j;
            int i;
            while (rs.next()) {
                i = rs.getInt(1);
                j = rs.getInt(2);
                int j0 = j - i - 1;
                if (this.targetval == "MEANPATTERN") {
                    this.counts[i][j0][0] = rs.getInt(3);
                    double d = 0.0;
                    if (this.counts[i][j0][0] > 0) {
                        d = rs.getDouble(4) * (double)1000 / (double)this.counts[i][j0][0];
                    }
                    this.counts[i][j0][1] = (int)d;
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Intersection ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j))).concat(String.valueOf(" : Size "))).concat(String.valueOf(this.counts[i][j0][0]))).concat(String.valueOf(" 1000*Targetmean "))).concat(String.valueOf(this.counts[i][j0][1])));
                    continue;
                }
                String t = rs.getString(3).trim();
                int c = rs.getInt(4);
                if (this.targetval.equals(t)) {
                    this.counts[i][j0][0] = c;
                    continue;
                }
                int[] nArray = this.counts[i][j0];
                nArray[1] = nArray[1] + c;
            }
            if (this.targetval != "MEANPATTERN") {
                for (i = 0; i < this.nsubgroups - 1; ++i) {
                    for (j = i + 1; j < this.nsubgroups; ++j) {
                        System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Intersection ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j))).concat(String.valueOf(" : +Target "))).concat(String.valueOf(this.counts[i][j - i - 1][0]))).concat(String.valueOf(" Complement "))).concat(String.valueOf(this.counts[i][j - i - 1][1])));
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void independencies() {
        for (int i = 0; i < this.nsubgroups; ++i) {
            double ab;
            double b;
            Subgroup si = (Subgroup)this.bestHypothesisList.get(i);
            double a = si.getConceptSize();
            for (int j = i + 1; j < this.nsubgroups; ++j) {
                int j0 = j - i - 1;
                Subgroup sj = (Subgroup)this.bestHypothesisList.get(j);
                b = sj.getConceptSize();
                ab = this.targetval == "MEANPATTERN" ? (double)this.counts[i][j0][0] : (double)this.counts[i][j0][0] + (double)this.counts[i][j0][1];
                this.chi2[i][j0] = this.chi2calc(a, b, ab, this.populationSize);
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("CHi2 (a,b,ab,chi2,n) ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j))).concat(String.valueOf(":  "))).concat(String.valueOf(a))).concat(String.valueOf(" "))).concat(String.valueOf(b))).concat(String.valueOf(" "))).concat(String.valueOf(ab))).concat(String.valueOf(" "))).concat(String.valueOf(this.chi2[i][j0]))).concat(String.valueOf(" "))).concat(String.valueOf(this.populationSize)));
                if (!(this.chi2[i][j0] < this.thresh)) continue;
                this.adjacent[i][j0] = 0;
            }
            if (this.targetval == "MEANPATTERN") {
                this.chi2[i][this.nsubgroups - i - 1] = 0.0f;
                continue;
            }
            b = this.rootHypothesis.getSubgroupSize(0);
            ab = si.getSubgroupSize(0);
            this.chi2[i][this.nsubgroups - i - 1] = this.chi2calc(a, b, ab, this.populationSize);
            System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("CHi2 (a,b,ab,chi2,n) ").concat(String.valueOf(i))).concat(String.valueOf(" target group:  "))).concat(String.valueOf(a))).concat(String.valueOf(" "))).concat(String.valueOf(b))).concat(String.valueOf(" "))).concat(String.valueOf(ab))).concat(String.valueOf(" "))).concat(String.valueOf(this.chi2[i][this.nsubgroups - i - 1]))).concat(String.valueOf(" "))).concat(String.valueOf(this.populationSize)));
        }
    }

    public void calcsim(double n) {
        for (int i = 0; i < this.nsubgroups - 1; ++i) {
            Subgroup si = (Subgroup)this.bestHypothesisList.get(i);
            double a = si.getConceptSize();
            for (int j = i + 1; j < this.nsubgroups; ++j) {
                int j0 = j - i - 1;
                double c = this.targetval == "MEANPATTERN" ? (double)this.counts[i][j0][0] : (double)(this.counts[i][j0][0] + this.counts[i][j0][1]);
                Subgroup sj = (Subgroup)this.bestHypothesisList.get(j);
                double b = sj.getConceptSize();
                this.sim[i][j0] = (float)c / (float)Math.max(a, b);
            }
        }
    }

    public float mdiffcalc(double n, double n1, double m, int s1) {
        double c;
        double v = this.rootHypothesis.getVariance();
        if (n1 < n && n1 > 0.0 && v > 0.0) {
            double m1 = (double)s1 / (double)1000;
            c = n1 * (n / (n - n1)) * Math.pow(m1 - m, 2.0) / v;
        } else {
            c = 0.0;
        }
        return (float)c;
    }

    public float chi2calc(double a, double b, double ab, double n) {
        double c = a < n && b < n && a > 0.0 && b > 0.0 ? n * Math.pow(ab * n - a * b, 2.0) / (a * b * (n - a) * (n - b)) : 0.0;
        return (float)c;
    }

    private void modelbasedsup() {
        double c2;
        double mod;
        int k;
        double o12;
        double n12;
        double n2;
        Subgroup sj;
        int j1;
        int j;
        double a1;
        double n1;
        Subgroup si;
        int i;
        String text = "";
        double n = this.populationSize;
        double a = this.rootHypothesis.getConfidence();
        double v = this.rootHypothesis.getVariance();
        for (i = 0; i < this.nsubgroups; ++i) {
            if (this.adjacent[i][this.nsubgroups - i - 1] == 0) continue;
            si = (Subgroup)this.bestHypothesisList.get(i);
            n1 = si.getConceptSize();
            a1 = si.getConfidence();
            for (j = i + 1; j < this.nsubgroups; ++j) {
                j1 = j - i - 1;
                if (this.adjacent[j][this.nsubgroups - j - 1] == 0) continue;
                sj = (Subgroup)this.bestHypothesisList.get(j);
                n2 = sj.getConceptSize();
                if (this.targetval == "MEANPATTERN") {
                    n12 = this.counts[i][j1][0];
                    o12 = this.counts[i][j1][1] / 1000;
                } else {
                    n12 = (double)this.counts[i][j1][0] + (double)this.counts[i][j1][1];
                    o12 = 0.0;
                    if (n12 > 0.0) {
                        o12 = (double)this.counts[i][j1][0] / n12;
                    }
                }
                if (n12 > (1.0 - (double)this.efak) * n1 && n12 > (1.0 - (double)this.efak) * n2 || n12 < (double)this.efak * n1 && n2 - n12 > (1.0 - (double)this.efak) * (this.populationSize - n1)) {
                    text = String.valueOf(String.valueOf(String.valueOf(String.valueOf("Subgroup ").concat(String.valueOf(i + 1))).concat(String.valueOf(" is nearly equal to Subgroup "))).concat(String.valueOf(j + 1))).concat(String.valueOf(" (cancelled)"));
                    this.resultArea.append(String.valueOf(text).concat(String.valueOf("\n")));
                    for (k = 0; k < j; ++k) {
                        this.adjacent[k][j - k - 1] = 0;
                    }
                    for (k = j + 1; k < this.nsubgroups + 1; ++k) {
                        this.adjacent[j][k - j - 1] = 0;
                    }
                    continue;
                }
                mod = a1 * (n * n12 - n1 * n2) / ((n - n1) * n2) + a * n * (n2 - n12) / ((n - n1) * n2);
                c2 = Math.pow(sj.getConfidence() - mod, 2.0) * n2 * n / ((n - n2) * v);
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" ").concat(String.valueOf(i + 1))).concat(String.valueOf(" "))).concat(String.valueOf(j + 1))).concat(String.valueOf(" "))).concat(String.valueOf(mod))).concat(String.valueOf(" "))).concat(String.valueOf(c2)));
                if (c2 > (double)this.thresh) continue;
                this.adjacent[j][this.nsubgroups - j - 1] = 0;
                this.sepset[j][this.nsubgroups - j - 1] = i;
            }
        }
        for (i = 0; i < this.nsubgroups; ++i) {
            if (this.adjacent[i][this.nsubgroups - i - 1] == 0) continue;
            si = (Subgroup)this.bestHypothesisList.get(i);
            n1 = si.getConceptSize();
            a1 = si.getConfidence();
            for (j = i + 1; j < this.nsubgroups; ++j) {
                j1 = j - i - 1;
                if (this.adjacent[j][this.nsubgroups - j - 1] == 0) continue;
                sj = (Subgroup)this.bestHypothesisList.get(j);
                n2 = sj.getConceptSize();
                double a2 = sj.getConfidence();
                if (this.targetval == "MEANPATTERN") {
                    n12 = this.counts[i][j1][0];
                    o12 = this.counts[i][j1][1] / 1000;
                } else {
                    n12 = (double)this.counts[i][j1][0] + (double)this.counts[i][j1][1];
                    o12 = 0.0;
                    if (n12 > 0.0) {
                        o12 = (double)this.counts[i][j1][0] / n12;
                    }
                }
                double v2 = this.fc(n1, n12, a1, o12);
                double v3 = this.fc(n2, n12, a2, o12);
                double v4 = this.f3c(n, n12, n1 - n12, n2 - n12, a, o12, v2, v3);
                for (k = j + 1; k < this.nsubgroups; ++k) {
                    if (this.adjacent[k][this.nsubgroups - k - 1] == 0) continue;
                    Subgroup sk = (Subgroup)this.bestHypothesisList.get(k);
                    double n3 = sk.getConceptSize();
                    double a3 = sk.getConfidence();
                    double n13 = this.targetval == "MEANPATTERN" ? (double)this.counts[i][k - i - 1][0] : (double)this.counts[i][k - i - 1][0] + (double)this.counts[i][k - i - 1][1];
                    double n23 = this.targetval == "MEANPATTERN" ? (double)this.counts[j][k - j - 1][0] : (double)this.counts[j][k - j - 1][0] + (double)this.counts[j][k - j - 1][1];
                    double m1 = this.getdb(i, j, k);
                    double m2 = n13 - m1;
                    double m3 = n23 - m1;
                    double m4 = n3 - n13 - n23 + m1;
                    mod = m1 * o12 / n3 + m2 * v2 / n3 + m3 * v3 / n3 + m4 * v4 / n3;
                    c2 = Math.pow(sk.getConfidence() - mod, 2.0) * n3 * n / ((n - n3) * v);
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" ").concat(String.valueOf(i + 1))).concat(String.valueOf(" "))).concat(String.valueOf(j + 1))).concat(String.valueOf(" "))).concat(String.valueOf(k + 1))).concat(String.valueOf(" "))).concat(String.valueOf(mod))).concat(String.valueOf(" "))).concat(String.valueOf(c2)));
                    if (c2 > (double)this.thresh) continue;
                    this.adjacent[k][this.nsubgroups - k - 1] = 0;
                    this.sepset[k][this.nsubgroups - k - 1] = 100 * (i + 1) + j + 1;
                }
            }
        }
    }

    private double fc(double n, double n1, double v, double v1) {
        double v2 = n1 < n ? (n * v - n1 * v1) / (n - n1) : 0.0;
        return v2;
    }

    private double f3c(double n, double n1, double n2, double n3, double v, double v1, double v2, double v3) {
        double v4 = n1 + n2 + n3 < n ? (n * v - n1 * v1 - n2 * v2 - n3 * v3) / (n - n1 - n2 - n3) : 0.0;
        return v4;
    }

    private void condIndSubgrTargetGivenSubgr() {
        String text = "";
        double b = 0.0;
        double b1 = 0.0;
        double ab = 0.0;
        for (int i = this.nsubgroups - 1; i >= 0; --i) {
            boolean flag = false;
            if (this.adjacent[i][this.nsubgroups - i - 1] == 0) continue;
            Subgroup si = (Subgroup)this.bestHypothesisList.get(i);
            double n1 = si.getConceptSize();
            for (int j = 0; j < this.nsubgroups; ++j) {
                double ab1;
                float c2;
                float c1;
                double a;
                int i1 = i;
                int j1 = j - i - 1;
                if (i == j) continue;
                if (i > j) {
                    i1 = j;
                    j1 = i - j - 1;
                }
                if (this.adjacent[j][this.nsubgroups - j - 1] == 0 && this.adjacent[i1][j1] == 0) continue;
                Subgroup sj = (Subgroup)this.bestHypothesisList.get(j);
                double n2 = sj.getConceptSize();
                if (this.targetval == "MEANPATTERN") {
                    a = this.counts[i1][j1][0];
                } else {
                    a = (double)this.counts[i1][j1][0] + (double)this.counts[i1][j1][1];
                    b = sj.getSubgroupSize(0);
                    ab = this.counts[i1][j1][0];
                }
                if (i < j && (a > (1.0 - (double)this.efak) * n1 && a > (1.0 - (double)this.efak) * n2 || a < (double)this.efak * n1 && n2 - a > (1.0 - (double)this.efak) * (this.populationSize - n1))) {
                    int k;
                    text = String.valueOf(String.valueOf(String.valueOf(String.valueOf("Subgroup ").concat(String.valueOf(i + 1))).concat(String.valueOf(" is nearly equal to Subgroup "))).concat(String.valueOf(j + 1))).concat(String.valueOf(" (cancelled)"));
                    this.resultArea.append(String.valueOf(text).concat(String.valueOf("\n")));
                    for (k = 0; k < j; ++k) {
                        this.adjacent[k][j - k - 1] = 0;
                    }
                    for (k = j + 1; k < this.nsubgroups + 1; ++k) {
                        this.adjacent[j][k - j - 1] = 0;
                    }
                    continue;
                }
                if (flag) continue;
                double a1 = n1 - a;
                if (this.targetval == "MEANPATTERN") {
                    c1 = this.mdiffcalc(n2, a, sj.getConfidence(), this.counts[i1][j1][1]);
                    double avjc = (this.populationSize * this.rootHypothesis.getConfidence() - n2 * sj.getConfidence()) / (this.populationSize - n2);
                    double avijc = 0.0;
                    if (a < n1) {
                        avijc = (n1 * si.getConfidence() - a * (double)this.counts[i1][j1][1] / (double)1000) / (n1 - a);
                    }
                    int ia = (int)((double)1000 * avijc);
                    c2 = this.mdiffcalc(this.populationSize - n2, a1, avjc, ia);
                } else {
                    c1 = this.chi2calc(a, b, ab, n2);
                    b1 = this.rootHypothesis.getSubgroupSize(0) - b;
                    ab1 = si.getSubgroupSize(0) - ab;
                    c2 = this.chi2calc(a1, b1, ab1, this.populationSize - n2);
                }
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("<Si,T>|Sj   and <Si,T>|compl(Sj): ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j))).concat(String.valueOf(" "))).concat(String.valueOf(c1))).concat(String.valueOf(" "))).concat(String.valueOf(c2)));
                if (c1 + c2 > (float)2 * this.thresh || (c1 == 0.0f || c2 == 0.0f) && c1 + c2 > this.thresh) continue;
                System.out.println("*****");
                text = String.valueOf(String.valueOf(String.valueOf("\n Subgroup ").concat(String.valueOf(i + 1))).concat(String.valueOf(" is provisionally suppressed by Subgroup "))).concat(String.valueOf(j + 1));
                this.resultArea.append(String.valueOf(text).concat(String.valueOf("\n")));
                if (this.targetval != "MEANPATTERN") {
                    text = String.valueOf("Intersection: Targetshare= ").concat(String.valueOf(ab / a));
                    this.resultArea.append(String.valueOf(text).concat(String.valueOf("\n")));
                    text = String.valueOf(String.valueOf(String.valueOf("Subgroup ").concat(String.valueOf(i + 1))).concat(String.valueOf(" -Intersection: "))).concat(String.valueOf((si.getSubgroupSize(0) - ab) / (n1 - a)));
                    this.resultArea.append(String.valueOf(text).concat(String.valueOf("\n")));
                    text = String.valueOf(String.valueOf(String.valueOf("Subgroup ").concat(String.valueOf(j + 1))).concat(String.valueOf(" -Intersection: "))).concat(String.valueOf((sj.getSubgroupSize(0) - ab) / (n2 - a)));
                    this.resultArea.append(String.valueOf(text).concat(String.valueOf("\n")));
                    text = String.valueOf(String.valueOf(String.valueOf("Complementary group to Subgroup ").concat(String.valueOf(j + 1))).concat(String.valueOf(" : "))).concat(String.valueOf(b1 / (this.populationSize - n2)));
                    this.resultArea.append(String.valueOf(text).concat(String.valueOf("\n")));
                }
                if (j < i && this.adjacent[j][this.nsubgroups - j - 1] == 0 && this.sepset[j][this.nsubgroups - j - 1] == i) {
                    float c2o;
                    float c1o;
                    a1 = n2 - a;
                    if (this.targetval == "MEANPATTERN") {
                        c1o = this.mdiffcalc(n1, a, si.getConfidence(), this.counts[i1][j1][1]);
                        double avic = (this.populationSize * this.rootHypothesis.getConfidence() - n1 * si.getConfidence()) / (this.populationSize - n1);
                        double avjic = 0.0;
                        if (a < n2) {
                            avjic = (n2 * sj.getConfidence() - a * (double)this.counts[i1][j1][1] / (double)1000) / (n1 - a);
                        }
                        int ia1 = (int)((double)1000 * avjic);
                        c2o = this.mdiffcalc(this.populationSize - n1, a1, avic, ia1);
                    } else {
                        b = si.getSubgroupSize(0);
                        c1o = this.chi2calc(a, b, ab, n1);
                        b1 = this.rootHypothesis.getSubgroupSize(0) - b;
                        ab1 = sj.getSubgroupSize(0) - ab;
                        c2o = this.chi2calc(a1, b1, ab1, this.populationSize - n1);
                    }
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" ").concat(String.valueOf(j))).concat(String.valueOf(" "))).concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(c1o))).concat(String.valueOf(" "))).concat(String.valueOf(c2o)));
                    if (c1o + c2o > c1 + c2) continue;
                    this.adjacent[j][this.nsubgroups - j - 1] = 1;
                    this.sepset[j][this.nsubgroups - j - 1] = -1;
                    System.out.println("symmetrical suppression: new one is better");
                }
                this.adjacent[i][this.nsubgroups - i - 1] = 0;
                this.sepset[i][this.nsubgroups - i - 1] = j;
                flag = true;
            }
        }
    }

    private void condIndSubgrSubgrGivenTarget() {
        block0: for (int i = 0; i < this.nsubgroups; ++i) {
            Subgroup si = (Subgroup)this.bestHypothesisList.get(i);
            double n1 = si.getConceptSize();
            for (int j = i + 1; j < this.nsubgroups; ++j) {
                System.out.println(String.valueOf(String.valueOf(String.valueOf("condIndSubgrSubgrGivenTarget  i,j: ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j)));
                int j0 = j - i - 1;
                if (this.adjacent[i][j0] == 0 || this.adjacent[i][this.nsubgroups - i - 1] == 0 && this.adjacent[j][this.nsubgroups - j - 1] == 0) continue;
                Subgroup sj = (Subgroup)this.bestHypothesisList.get(j);
                double n2 = this.rootHypothesis.getSubgroupSize(0);
                double a = si.getSubgroupSize(0);
                double b = sj.getSubgroupSize(0);
                double ab = this.counts[i][j0][0];
                float c1 = this.chi2calc(a, b, ab, n2);
                a = n1 - a;
                b = sj.getConceptSize() - b;
                ab = this.counts[i][j0][1];
                float c2 = this.chi2calc(a, b, ab, this.populationSize - n2);
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j))).concat(String.valueOf(" "))).concat(String.valueOf(c1))).concat(String.valueOf(" "))).concat(String.valueOf(c2)));
                if (c1 + c2 > (float)2 * this.thresh) continue;
                this.adjacent[i][j0] = 0;
                this.sepset[i][j0] = this.nsubgroups;
                continue block0;
            }
        }
    }

    private void condIndSubgrSubgrGivenSubgr() {
        for (int i = 0; i < this.nsubgroups; ++i) {
            Subgroup si = (Subgroup)this.bestHypothesisList.get(i);
            double ni = si.getConceptSize();
            block1: for (int j = i + 1; j < this.nsubgroups; ++j) {
                int j0 = j - i - 1;
                if (this.adjacent[i][j0] == 0) continue;
                for (int k = 0; k < this.nsubgroups; ++k) {
                    if (i == k || j == k) continue;
                    int i1 = i;
                    int j1 = j;
                    int k1i = k - i - 1;
                    int k1j = k - j - 1;
                    if (i > k) {
                        i1 = k;
                        k1i = i - k - 1;
                    }
                    if (j > k) {
                        j1 = k;
                        k1j = j - k - 1;
                    }
                    if (this.adjacent[i1][k1i] == 0 && this.adjacent[j1][k1j] == 0) continue;
                    Subgroup sj = (Subgroup)this.bestHypothesisList.get(j);
                    double nj = sj.getConceptSize();
                    Subgroup sk = (Subgroup)this.bestHypothesisList.get(k);
                    double nk = sk.getConceptSize();
                    double a = this.targetval == "MEANPATTERN" ? (double)this.counts[i1][k1i][0] : (double)this.counts[i1][k1i][0] + (double)this.counts[i1][k1i][1];
                    double b = this.targetval == "MEANPATTERN" ? (double)this.counts[j1][k1j][0] : (double)this.counts[j1][k1j][0] + (double)this.counts[j1][k1j][1];
                    double ab = this.getdb(i, j, k);
                    float c1 = this.chi2calc(a, b, ab, nk);
                    a = ni - a;
                    b = nj - b;
                    double ab11 = this.targetval == "MEANPATTERN" ? (double)this.counts[i][j0][0] : (double)this.counts[i][j0][0] + (double)this.counts[i][j0][1];
                    ab = ab11 - ab;
                    float c2 = this.chi2calc(a, b, ab, this.populationSize - nk);
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j))).concat(String.valueOf(" "))).concat(String.valueOf(k))).concat(String.valueOf(" "))).concat(String.valueOf(c1))).concat(String.valueOf(" "))).concat(String.valueOf(c2)));
                    if (c1 + c2 > (float)2 * this.thresh) continue;
                    this.adjacent[i][j0] = 0;
                    this.sepset[i][j0] = k;
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Si is conditionall independent from Sj given Sk ").concat(String.valueOf(a))).concat(String.valueOf(" "))).concat(String.valueOf(b))).concat(String.valueOf(" "))).concat(String.valueOf(ab))).concat(String.valueOf(" "))).concat(String.valueOf(nk))).concat(String.valueOf(" "))).concat(String.valueOf(this.populationSize)));
                    continue block1;
                }
            }
        }
    }

    private double getdb(int i, int j, int k) {
        String query = this.theRelationGraph != null ? QueryConstructor.makeijkQuery(this.key, i, j, k, this.table, this.bestHypothesisList, this.theRelationGraph, this.dcp) : QueryConstructor.makeijkQuery(i, j, k, this.table, this.bestHypothesisList, this.dcp);
        System.out.println(query);
        ResultSet rs = this.db.select(query);
        double c = 0.0;
        try {
            rs.next();
            c = rs.getDouble(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return c;
    }

    private int set2(int old) {
        if (old == 1) {
            return 2000;
        }
        if (old < 3000) {
            return old + 1;
        }
        if (old == 3000) {
            return 1;
        }
        return old - 1;
    }

    private int set3(int old) {
        if (old == 1) {
            return 3000;
        }
        if (old > 2999) {
            return old + 1;
        }
        if (old > 2000) {
            return old - 1;
        }
        return 1;
    }

    private void analyseSepset() {
        for (int i = 0; i < this.nsubgroups - 1; ++i) {
            for (int j = i + 1; j <= this.nsubgroups; ++j) {
                int k0;
                int k;
                int j0 = j - i - 1;
                if (this.adjacent[i][j0] == 0) continue;
                for (k = j + 1; k <= this.nsubgroups; ++k) {
                    int k0j;
                    int k0i = k - i - 1;
                    if (this.adjacent[i][k0i] == 0 || this.adjacent[j][k0j = k - j - 1] > 0 || this.sepset[j][k0j] == i) continue;
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("i does not separate j,k  i: ").concat(String.valueOf(i))).concat(String.valueOf("j: "))).concat(String.valueOf(j))).concat(String.valueOf("k: "))).concat(String.valueOf(k)));
                    this.adjacent[i][j0] = this.set2(this.adjacent[i][j0]);
                    System.out.println(String.valueOf("dir i,j  from higher to lower:  2 ").concat(String.valueOf(this.adjacent[i][j0])));
                    this.adjacent[i][k0i] = this.set2(this.adjacent[i][k0i]);
                    System.out.println(String.valueOf("dir i,k  from higher to lower:  2 ").concat(String.valueOf(this.adjacent[i][k0i])));
                }
                for (k = i + 1; k < j; ++k) {
                    int j0k = j - k - 1;
                    if (this.adjacent[k][j0k] == 0 || this.adjacent[i][k0 = k - i - 1] > 0 || this.sepset[i][k0] == j) continue;
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("j does not separate i,k  i: ").concat(String.valueOf(i))).concat(String.valueOf("j: "))).concat(String.valueOf(j))).concat(String.valueOf("k: "))).concat(String.valueOf(k)));
                    this.adjacent[i][j0] = this.set3(this.adjacent[i][j0]);
                    System.out.println(String.valueOf("dir i,j  from lower to higher:  3 ").concat(String.valueOf(this.adjacent[i][j0])));
                    this.adjacent[k][j0k] = this.set3(this.adjacent[k][j0k]);
                    System.out.println(String.valueOf("dir k,j  from lower to higher:  3 ").concat(String.valueOf(this.adjacent[k][j0k])));
                }
                for (k = j + 1; k <= this.nsubgroups; ++k) {
                    int k0j = k - j - 1;
                    if (this.adjacent[j][k0j] == 0 || this.adjacent[i][k0 = k - i - 1] > 0 || this.sepset[i][k0] == j) continue;
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("j does not separate i,k  i: ").concat(String.valueOf(i))).concat(String.valueOf("j: "))).concat(String.valueOf(j))).concat(String.valueOf("k: "))).concat(String.valueOf(k)));
                    this.adjacent[i][j0] = this.set3(this.adjacent[i][j0]);
                    System.out.println(String.valueOf("dir i,j  from lower to higher:  3 ").concat(String.valueOf(this.adjacent[i][j0])));
                    this.adjacent[j][k0j] = this.set2(this.adjacent[j][k0j]);
                    System.out.println(String.valueOf("dir j,k  from higher to lower:  2 ").concat(String.valueOf(this.adjacent[j][k0j])));
                }
            }
        }
    }

    private void analyseUndir() {
        for (int i = 0; i < this.nsubgroups; ++i) {
            for (int j = i + 1; j <= this.nsubgroups; ++j) {
                int j0k;
                int k0i;
                int k;
                int j0 = j - i - 1;
                if (this.adjacent[i][j0] > 2999) {
                    for (k = j + 1; k <= this.nsubgroups; ++k) {
                        int k0j;
                        k0i = k - i - 1;
                        if (this.adjacent[i][k0i] > 0 || this.adjacent[j][k0j = k - j - 1] != 1) continue;
                        this.adjacent[j][k0j] = 3000;
                        System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("undir: ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j))).concat(String.valueOf(" "))).concat(String.valueOf(k)));
                    }
                    for (k = 0; k < j; ++k) {
                        if (k < i && this.adjacent[k][i - k - 1] > 0 || k == i || k > i && this.adjacent[i][k - i - 1] > 0 || this.adjacent[k][j0k = j - k - 1] != 1) continue;
                        this.adjacent[k][j0k] = 2000;
                        System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("undir: ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j))).concat(String.valueOf(" "))).concat(String.valueOf(k)));
                    }
                }
                if (this.adjacent[i][j0] <= 1999 || this.adjacent[i][j0] >= 3000) continue;
                for (k = i + 1; k <= this.nsubgroups; ++k) {
                    if (k < j && this.adjacent[k][j - k - 1] > 0 || k == j || k > j && this.adjacent[j][k - j - 1] > 0 || this.adjacent[i][k0i = k - i - 1] != 1) continue;
                    this.adjacent[i][k0i] = 3000;
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("undir: ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j))).concat(String.valueOf(" "))).concat(String.valueOf(k)));
                }
                for (k = 0; k < i; ++k) {
                    int i0k;
                    j0k = j - k - 1;
                    if (this.adjacent[k][j0k] > 0 || this.adjacent[k][i0k = i - k - 1] != 1) continue;
                    this.adjacent[k][i0k] = 2000;
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("undir: ").concat(String.valueOf(i))).concat(String.valueOf(" "))).concat(String.valueOf(j))).concat(String.valueOf(" "))).concat(String.valueOf(k)));
                }
            }
        }
    }

    private int printadj1() {
        String text;
        int i;
        int ns = 0;
        for (i = 0; i < this.nsubgroups; ++i) {
            String t1;
            String str = String.valueOf(i).concat(String.valueOf(" is adjacent to: "));
            int j = this.nsubgroups - i - 1;
            if (this.adjacent[i][j] == 1) {
                str = String.valueOf(str).concat(String.valueOf(String.valueOf(i + j + 1).concat(String.valueOf(" "))));
                System.out.println(str);
                continue;
            }
            ++ns;
            int s = this.sepset[i][j];
            if (s > 100) {
                int mi = (int)Math.floor((double)s / (double)100);
                int mj = s - mi * 100;
                t1 = String.valueOf(String.valueOf(String.valueOf(" ").concat(String.valueOf(mi))).concat(String.valueOf(" and "))).concat(String.valueOf(mj));
            } else {
                t1 = String.valueOf(" ").concat(String.valueOf(s + 1));
            }
            text = String.valueOf(String.valueOf("Subgroup ").concat(String.valueOf(i + 1))).concat(String.valueOf(" is "));
            text = s < 0 ? String.valueOf(text).concat(String.valueOf("cancelled\n")) : String.valueOf(text).concat(String.valueOf(String.valueOf(String.valueOf("suppressed by Subgroup").concat(String.valueOf(t1))).concat(String.valueOf("\n"))));
            this.resultArea.append(text);
        }
        this.resultArea.append("\n");
        text = "Causal Subgroups:  ";
        for (i = 0; i < this.nsubgroups; ++i) {
            int j = this.nsubgroups - i - 1;
            if (this.adjacent[i][j] != 1) continue;
            text = String.valueOf(text).concat(String.valueOf(String.valueOf(i + 1).concat(String.valueOf(" "))));
        }
        this.resultArea.append(String.valueOf(String.valueOf(text).concat(String.valueOf("\n"))).concat(String.valueOf("\n")));
        return ns;
    }

    private void printadj() {
        for (int i = 0; i < this.nsubgroups; ++i) {
            String str = String.valueOf(i).concat(String.valueOf(" is adjacent to: "));
            for (int j = 0; j < this.nsubgroups - i; ++j) {
                if (this.adjacent[i][j] != 1) continue;
                str = String.valueOf(str).concat(String.valueOf(String.valueOf(i + j + 1).concat(String.valueOf(" "))));
            }
            System.out.println(str);
        }
    }

    private void printdir1() {
        for (int i = 0; i < this.nsubgroups; ++i) {
            String str1 = String.valueOf(i).concat(String.valueOf(" is directed to:   "));
            String str2 = String.valueOf(i).concat(String.valueOf(" is directed from: "));
            for (int j = 0; j < this.nsubgroups - i; ++j) {
                if (this.adjacent[i][j] > 2999) {
                    str1 = String.valueOf(str1).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(i + j + 1).concat(String.valueOf(" ("))).concat(String.valueOf(this.adjacent[i][j]))).concat(String.valueOf(") "))));
                    continue;
                }
                if (this.adjacent[i][j] <= 1999) continue;
                str2 = String.valueOf(str2).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(i + j + 1).concat(String.valueOf(" ("))).concat(String.valueOf(this.adjacent[i][j]))).concat(String.valueOf(") "))));
            }
            System.out.println(str1);
            System.out.println(str2);
        }
    }

    private void printdir2() {
        for (int i = 0; i < this.nsubgroups; ++i) {
            String str1 = String.valueOf(i).concat(String.valueOf(" is directed to:   "));
            String str2 = String.valueOf(i).concat(String.valueOf(" is directed from: "));
            String str3 = String.valueOf(i).concat(String.valueOf(" is adjacent to: "));
            for (int j = 0; j < this.nsubgroups - i; ++j) {
                if (this.adjacent[i][j] > 2999) {
                    str1 = String.valueOf(str1).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(i + j + 1).concat(String.valueOf(" ("))).concat(String.valueOf(this.adjacent[i][j]))).concat(String.valueOf(") "))));
                    continue;
                }
                if (this.adjacent[i][j] > 1999) {
                    str2 = String.valueOf(str2).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(i + j + 1).concat(String.valueOf(" ("))).concat(String.valueOf(this.adjacent[i][j]))).concat(String.valueOf(") "))));
                    continue;
                }
                if (this.adjacent[i][j] != 1) continue;
                str3 = String.valueOf(str3).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(i + j + 1).concat(String.valueOf(" ("))).concat(String.valueOf(this.adjacent[i][j]))).concat(String.valueOf(") "))));
            }
            System.out.println(str1);
            System.out.println(str2);
        }
    }
}

