/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DBConnectDialog;
import database.DBConnectionDescriptor;
import database.DBConsole;
import database.Database;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.JOptionPane;

public class JDBCServer {
    Socket socket;
    PrintWriter out;
    DBConnectDialog dbc;
    ServerSocket server;
    Database db;
    static final int WAIT_FOR_REQUEST = 0;
    static final int PROCESS = 1;
    static final int SHUTDOWN = 2;
    static final int CONNECT = 3;
    private int state = 3;
    private int port = 0;
    private BufferedReader in;

    public JDBCServer(int port) {
        this.port = port;
        this.startupServer();
    }

    public JDBCServer(DBConnectionDescriptor descriptor) {
        this.db = new Database(descriptor);
        if (this.db != null && this.db.getConnection() != null) {
            this.initializeServer();
            this.handleConnection();
        }
    }

    public JDBCServer() {
        this.startupServer();
    }

    private void startupServer() {
        this.makeDBConnection();
        if (this.db != null && this.db.getConnection() != null) {
            this.initializeServer();
            DBConsole f = new DBConsole(this.db);
            f.setVisible(true);
            this.handleConnection();
        }
    }

    void initializeServer() {
        System.out.println("GO");
        try {
            this.server = new ServerSocket(this.port);
            this.port = this.server.getLocalPort();
            System.out.println(String.valueOf("JDBCServer is Listening on port ").concat(String.valueOf(this.port)));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    void handleConnection() {
        block9: {
            while (this.state != 2) {
                this.socket = this.server.accept();
                System.out.println("Client accepted");
                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())));
                this.handleCommand();
            }
            Object var3_1 = null;
            try {
                this.socket.close();
                System.out.println("Bye");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block9;
            {
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.getMessage());
                    Object var3_2 = null;
                    try {
                        this.socket.close();
                        System.out.println("Bye");
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.socket.close();
                    System.out.println("Bye");
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public int getPort() {
        return this.server.getLocalPort();
    }

    public String getHost() {
        return this.server.getInetAddress().getHostName();
    }

    public void makeDBConnection() {
        this.dbc = new DBConnectDialog(null, "", true);
        this.dbc.setVisible(true);
        if (this.dbc.getDescriptor() != null) {
            this.db = new Database(this.dbc.getDescriptor());
        }
    }

    int handleCommand() {
        this.state = 1;
        try {
            while (this.state == 1) {
                this.state = this.processCommand(this.in.readLine());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.state;
    }

    int processCommand(String command) {
        if (command.toUpperCase().startsWith("JDBC")) {
            this.dbc = new DBConnectDialog();
            this.dbc.setVisible(true);
            return 1;
        }
        if (command.toUpperCase().startsWith("SELECT")) {
            return 1;
        }
        if (command.toUpperCase().startsWith("IS_OPEN")) {
            if (this.db == null) {
                this.dbc = new DBConnectDialog();
                this.dbc.setVisible(true);
            }
            return 1;
        }
        if (command.toUpperCase().startsWith("FLUSH")) {
            return 1;
        }
        if (command.toUpperCase().startsWith("GET_TABLES")) {
            return 1;
        }
        if (command.toUpperCase().startsWith("CLOSE")) {
            System.out.println(command);
            this.db.disconnect();
            return 0;
        }
        if (command.toUpperCase().startsWith("SHUTDOWN")) {
            System.out.println("SHUTDOWN");
            this.db.disconnect();
            return 2;
        }
        System.out.println("unrecognized command");
        System.out.println(command);
        return 1;
    }

    public void socketWrite(String s) {
        try {
            this.out.println(s);
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

