/*
 * Decompiled with CFR 0.152.
 */
package database;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Vector;
import javax.swing.JOptionPane;

public class DBDataSet {
    private ResultSet rs;
    private int columns;
    private static int NUMERIC = 1;
    private static int STRING = 2;
    private static int DATE = 3;
    private File targetFile;
    private String dir = System.getProperty("TEMP", "c:\\temp");
    private boolean verbose = true;
    private PrintWriter outFile;

    public DBDataSet() {
    }

    public DBDataSet(ResultSet rs) {
        this.setData(rs);
    }

    protected File getFileName(String fileName) {
        int i = 1;
        boolean fileOK = false;
        File dirFile = new File(this.dir);
        boolean trialNumber = false;
        while (!dirFile.isDirectory()) {
            if (dirFile.isFile()) continue;
            if (!trialNumber) {
                this.dir = "/tmp";
                dirFile = new File("/tmp");
                trialNumber = true;
                continue;
            }
            if (trialNumber) {
                this.dir = "c:\\Windows\\Temp";
                dirFile = new File(this.dir);
                trialNumber = true;
                continue;
            }
            return null;
        }
        File file = new File(this.dir, String.valueOf(String.valueOf(fileName).concat(String.valueOf(i))).concat(String.valueOf(".pl")));
        while (!fileOK) {
            if (!file.exists()) {
                fileOK = true;
                continue;
            }
            file = new File(this.dir, String.valueOf(String.valueOf(fileName).concat(String.valueOf(++i))).concat(String.valueOf(".pl")));
        }
        return file;
    }

    protected String getColumnTypeName(int jdbcColType) {
        int colType = this.getColumnType(jdbcColType);
        if (colType == NUMERIC) {
            return "number";
        }
        if (colType == STRING) {
            return "string";
        }
        return "date";
    }

    protected int getColumnType(int colType) {
        if (colType == 2 || colType == -7 || colType == -6 || colType == 5 || colType == 4 || colType == -5 || colType == 6 || colType == 7 || colType == 8 || colType == 3) {
            return NUMERIC;
        }
        if (colType == 91) {
            return DATE;
        }
        return STRING;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File transferToFile(String fileStem, String tableName) {
        int i = 0;
        int counter = 0;
        long t = 0L;
        long t1 = 0L;
        long t2 = 0L;
        this.targetFile = this.getFileName(tableName);
        if (this.verbose) {
            t1 = System.currentTimeMillis();
        }
        try {
            this.outFile = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.targetFile), 100000));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        try {
            try {
                ResultSetMetaData metaData = this.rs.getMetaData();
                tableName = String.valueOf(String.valueOf("'").concat(String.valueOf(tableName))).concat(String.valueOf("'"));
                StringBuffer desc = new StringBuffer("");
                desc.append(String.valueOf(String.valueOf("schema_key(").concat(String.valueOf(tableName))).concat(String.valueOf(",[")));
                for (int j = 1; j <= this.columns; ++j) {
                    desc.append(String.valueOf(String.valueOf(String.valueOf("'").concat(String.valueOf(metaData.getColumnName(j)))).concat(String.valueOf("':"))).concat(String.valueOf(this.getColumnTypeName(metaData.getColumnType(j)))));
                    if (j >= this.columns) continue;
                    desc.append(",");
                }
                desc.append("],[[]]).\n");
                this.outFile.println(desc);
                while (this.rs.next()) {
                    Object object;
                    if (this.verbose && counter % 5000 == 0) {
                        System.out.println(counter);
                    }
                    ++counter;
                    StringBuffer row = new StringBuffer(String.valueOf(tableName).concat(String.valueOf("(")));
                    for (i = 1; i < this.columns; ++i) {
                        object = this.rs.getObject(i);
                        if (object == null) {
                            row.append("'?',");
                            continue;
                        }
                        if (this.getColumnType(metaData.getColumnType(i)) != NUMERIC) {
                            row.append(String.valueOf(String.valueOf("'").concat(String.valueOf(object.toString()))).concat(String.valueOf("',")));
                            continue;
                        }
                        row.append(String.valueOf(object.toString()).concat(String.valueOf(",")));
                    }
                    object = this.rs.getObject(this.columns);
                    if (object == null) {
                        row.append("'?').");
                    } else if (this.getColumnType(metaData.getColumnType(i)) != NUMERIC) {
                        row.append(String.valueOf(String.valueOf("'").concat(String.valueOf(object.toString()))).concat(String.valueOf("').")));
                    } else {
                        row.append(String.valueOf(object.toString()).concat(String.valueOf(").")));
                    }
                    this.socketWrite(row.toString());
                }
                if (this.verbose) {
                    t2 = System.currentTimeMillis();
                    System.out.println(String.valueOf("Time: ").concat(String.valueOf(t)));
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage());
                Object var19_16 = null;
                try {
                    this.outFile.close();
                    return this.targetFile;
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, e2.getMessage());
                    return null;
                }
            }
            Object var19_15 = null;
        }
        catch (Throwable throwable) {
            Object var19_17 = null;
            try {}
            catch (Exception e2) {
                JOptionPane.showMessageDialog(null, e2.getMessage());
                return null;
            }
            this.outFile.close();
            return this.targetFile;
        }
        try {}
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, e2.getMessage());
            return null;
        }
        this.outFile.close();
        return this.targetFile;
    }

    void socketWrite(String s) {
        try {
            this.outFile.println(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Vector result2Vector(ResultSet rs) {
        Vector table = new Vector();
        int i = 0;
        try {
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                Vector<Object> row = new Vector<Object>(columns);
                for (i = 1; i <= columns; ++i) {
                    row.addElement(rs.getObject(i));
                }
                table.addElement(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return table;
    }

    public void setData(ResultSet rs) {
        this.rs = rs;
        try {
            this.columns = rs.getMetaData().getColumnCount();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ResultSet getData() {
        return this.rs;
    }

    public Vector getRow() {
        Vector<Object> row = new Vector<Object>(this.columns);
        try {
            if (this.rs.next()) {
                // empty if block
            }
            for (int i = 1; i <= this.columns; ++i) {
                row.addElement(this.rs.getObject(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row;
    }

    public String getRowString() {
        String row;
        block3: {
            row = null;
            try {
                if (!this.rs.next()) break block3;
                row = "";
                for (int i = 1; i <= this.columns; ++i) {
                    Object object = this.rs.getObject(i);
                    if (object == null) continue;
                    row = String.valueOf(row).concat(String.valueOf(String.valueOf(object.toString()).concat(String.valueOf(" "))));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return row;
    }
}

