/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DBConnectionDescriptor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class DBConnectDialog
extends JDialog {
    JLabel userLabel = new JLabel();
    JLabel passwordLabel = new JLabel();
    JLabel connectionLabel = new JLabel();
    JLabel driverLabel = new JLabel();
    JLabel connectStringLabel = new JLabel();
    JLabel typeLabel = new JLabel();
    JLabel nameLabel = new JLabel();
    JTextField userField = new JTextField();
    JTextField driverTextField = new JTextField();
    JTextField connectString = new JTextField();
    JTextField nameTextField = new JTextField();
    JPasswordField passwordField = new JPasswordField();
    JComboBox connectionComboBox = new JComboBox();
    JComboBox typeComboBox = new JComboBox();
    JButton newButton = new JButton();
    JButton editButton = new JButton();
    JButton deleteButton = new JButton();
    JButton closeButton = new JButton();
    JButton saveButton = new JButton();
    JButton templateButton = new JButton();
    JButton connectButton = new JButton();
    JPanel configurePanel = new JPanel();
    JPanel connectPanel = new JPanel();
    Border etched = BorderFactory.createEtchedBorder();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    private String fileName = "DBConnectionCollection.ser";
    private Hashtable dbConnectionCollection = new Hashtable();
    private String[] dBType = new String[]{"Oracle", "ODBC", "Sybase"};
    private DBConnectionDescriptor dbc;

    public static void main(String[] args) {
        DBConnectDialog dbc = new DBConnectDialog();
        dbc.setVisible(true);
    }

    public DBConnectDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.load();
        this.updateConnections();
        for (int i = 0; i < this.dBType.length; ++i) {
            this.typeComboBox.addItem(this.dBType[i]);
        }
        this.configurePanel.setVisible(false);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    public DBConnectDialog(Frame f, String title, boolean modal) {
        super(f, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.load();
        this.updateConnections();
        for (int i = 0; i < this.dBType.length; ++i) {
            this.typeComboBox.addItem(this.dBType[i]);
        }
        this.configurePanel.setVisible(false);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout3);
        this.setSize(new Dimension(400, 300));
        this.setTitle("Database Connection");
        this.userLabel.setText("User");
        this.userLabel.setDisplayedMnemonic('U');
        this.userLabel.setLabelFor(this.userField);
        this.userField.setToolTipText("Enter user name for database");
        this.passwordLabel.setText("Password");
        this.passwordLabel.setDisplayedMnemonic('P');
        this.passwordLabel.setLabelFor(this.passwordField);
        this.passwordField.setToolTipText("Enter your password for the database");
        this.connectionLabel.setText("Connection");
        this.connectionLabel.setDisplayedMnemonic('t');
        this.connectionLabel.setLabelFor(this.connectionComboBox);
        this.connectionComboBox.setToolTipText("Select a database connection");
        this.connectionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBConnectDialog.this.connectionComboBox_actionPerformed(e);
            }
        });
        this.connectionComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DBConnectDialog.this.connectionComboBox_itemStateChanged(e);
            }
        });
        this.editButton.setToolTipText("Edit the currently selected  connection");
        this.editButton.setMnemonic('E');
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBConnectDialog.this.editButton_actionPerformed(e);
            }
        });
        this.newButton.setToolTipText("Configure a new database connection");
        this.newButton.setMnemonic('N');
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBConnectDialog.this.newButton_actionPerformed(e);
            }
        });
        this.deleteButton.setMnemonic('D');
        this.deleteButton.setToolTipText("Delete the currently selected connection");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBConnectDialog.this.deleteButton_actionPerformed(e);
            }
        });
        this.connectButton.setMnemonic('C');
        this.connectButton.setToolTipText("Connect to database");
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBConnectDialog.this.connectButton_actionPerformed(e);
            }
        });
        this.saveButton.setMnemonic('S');
        this.saveButton.setToolTipText("Save connection information");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBConnectDialog.this.saveButton_actionPerformed(e);
            }
        });
        this.templateButton.setMnemonic('m');
        this.templateButton.setToolTipText("Get a driver and connect string template for the chosen database type");
        this.templateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBConnectDialog.this.templateButton_actionPerformed(e);
            }
        });
        this.closeButton.setMnemonic('l');
        this.closeButton.setToolTipText("Close configuration menu");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBConnectDialog.this.closeButton_actionPerformed(e);
            }
        });
        this.nameLabel.setText("Name");
        this.nameLabel.setDisplayedMnemonic('a');
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.setToolTipText("Specify a new name for the connection");
        this.driverLabel.setText("Driver");
        this.driverLabel.setDisplayedMnemonic('r');
        this.driverLabel.setLabelFor(this.driverTextField);
        this.driverTextField.setToolTipText("Specify a valid JDBC driver");
        this.connectStringLabel.setText("Connect String");
        this.connectStringLabel.setDisplayedMnemonic('o');
        this.connectStringLabel.setLabelFor(this.connectString);
        this.connectString.setToolTipText("Specify a valid connect string (press TEMPLATE to get a template for the chosen type)");
        this.typeLabel.setText("Type");
        this.typeLabel.setDisplayedMnemonic('y');
        this.typeLabel.setLabelFor(this.typeComboBox);
        this.typeComboBox.setToolTipText("Specify a database type to get a template");
        this.connectPanel.setLayout(this.gridBagLayout2);
        this.connectPanel.setBorder(this.etched);
        this.configurePanel.setLayout(this.gridBagLayout1);
        this.configurePanel.setBorder(this.etched);
        this.getContentPane().add((Component)this.connectPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.connectPanel.add((Component)this.userLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.connectPanel.add((Component)this.userField, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.connectPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.connectPanel.add((Component)this.passwordField, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.connectPanel.add((Component)this.connectionLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.connectPanel.add((Component)this.connectionComboBox, new GridBagConstraints(1, 2, 4, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.connectPanel.add((Component)this.newButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.connectPanel.add((Component)this.editButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.connectPanel.add((Component)this.deleteButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.connectPanel.add((Component)this.connectButton, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.configurePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.configurePanel.add((Component)this.driverTextField, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.configurePanel.add((Component)this.connectString, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.configurePanel.add((Component)this.saveButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.configurePanel.add((Component)this.driverLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.configurePanel.add((Component)this.connectStringLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.configurePanel.add((Component)this.templateButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.configurePanel.add((Component)this.typeComboBox, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.configurePanel.add((Component)this.typeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.configurePanel.add((Component)this.closeButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.configurePanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.configurePanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
    }

    void updateConnections() {
        Enumeration e = this.dbConnectionCollection.keys();
        while (e.hasMoreElements()) {
            this.connectionComboBox.addItem((String)e.nextElement());
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void save() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.fileName));
            out.writeObject(this.dbConnectionCollection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.fileName));
            this.dbConnectionCollection = (Hashtable)in.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void showSelectedConnection() {
        DBConnectionDescriptor dbc = (DBConnectionDescriptor)this.dbConnectionCollection.get(this.connectionComboBox.getSelectedItem());
        this.nameTextField.setText(dbc.getName());
        this.driverTextField.setText(dbc.getDriver());
        this.connectString.setText(dbc.getHostString());
        this.userField.setText(dbc.getUser());
        this.passwordField.setText(dbc.getPassword());
        this.typeComboBox.setSelectedItem(dbc.getType());
    }

    public void setConnection(String connectionName) {
        DBConnectionDescriptor dbc = (DBConnectionDescriptor)this.dbConnectionCollection.get(connectionName);
        this.nameTextField.setText(dbc.getName());
        this.driverTextField.setText(dbc.getDriver());
        this.connectString.setText(dbc.getHostString());
        this.userField.setText(dbc.getUser());
        this.passwordField.setText(dbc.getPassword());
        this.typeComboBox.setSelectedItem(dbc.getType());
        this.connectionComboBox.setSelectedItem(connectionName);
    }

    void saveCollection() {
        int option;
        String name = this.nameTextField.getText().trim();
        if (name.equals("")) {
            return;
        }
        if (this.dbConnectionCollection.containsKey(name) && (option = JOptionPane.showConfirmDialog(this, String.valueOf(name).concat(String.valueOf(" exists. Really replace?")))) != 0) {
            return;
        }
        DBConnectionDescriptor dbc = new DBConnectionDescriptor(this.nameTextField.getText().trim(), this.connectString.getText().trim(), this.driverTextField.getText().trim(), (String)this.typeComboBox.getSelectedItem(), this.userField.getText().trim(), "");
        this.dbConnectionCollection.put(dbc.toString(), dbc);
        this.connectionComboBox.addItem(this.nameTextField.getText().trim());
        this.connectionComboBox.setSelectedItem(this.nameTextField.getText().trim());
        this.save();
        this.showSelectedConnection();
    }

    void newConnection() {
        this.userField.setText("");
        this.passwordField.setText("");
        this.nameTextField.setText("");
        this.driverTextField.setText("");
        this.connectString.setText("");
        this.configurePanel.setVisible(true);
        this.pack();
    }

    void delete() {
        int option = JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf("Really delete connection ").concat(String.valueOf(this.connectionComboBox.getSelectedItem()))).concat(String.valueOf("?")));
        if (option == 0) {
            this.dbConnectionCollection.remove(this.connectionComboBox.getSelectedItem());
            this.connectionComboBox.removeItem(this.connectionComboBox.getSelectedItem());
            this.save();
        }
    }

    void showTemplate() {
        String databaseType = (String)this.typeComboBox.getSelectedItem();
        if (databaseType.equals("Oracle")) {
            this.nameTextField.setText("myhost");
            this.driverTextField.setText("oracle.jdbc.driver.OracleDriver");
            this.connectString.setText("myhost.foo.com:1521:SID");
        }
        if (databaseType.equals("Sybase")) {
            this.nameTextField.setText("myhost");
            this.driverTextField.setText("com.sybase.jdbc.SybDriver");
            this.connectString.setText("myhost.foo.com:1521");
        }
        if (databaseType.equals("ODBC")) {
            this.nameTextField.setText("Access");
            this.driverTextField.setText("sun.jdbc.odbc.JdbcOdbcDriver");
            this.connectString.setText("DatabaseName");
        }
    }

    public DBConnectionDescriptor getDescriptor() {
        return this.dbc;
    }

    public void connect() {
        this.dbc = (DBConnectionDescriptor)this.dbConnectionCollection.get(this.connectionComboBox.getSelectedItem());
        this.dbc.setUser(this.userField.getText());
        this.setVisible(false);
    }

    void saveButton_actionPerformed(ActionEvent e) {
        this.saveCollection();
    }

    void newButton_actionPerformed(ActionEvent e) {
        this.newConnection();
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.configurePanel.setVisible(false);
        this.pack();
    }

    void editButton_actionPerformed(ActionEvent e) {
        this.showSelectedConnection();
        this.configurePanel.setVisible(true);
        this.pack();
    }

    void deleteButton_actionPerformed(ActionEvent e) {
        this.delete();
    }

    void connectButton_actionPerformed(ActionEvent e) {
        this.connect();
    }

    void connectionComboBox_itemStateChanged(ItemEvent e) {
        this.showSelectedConnection();
    }

    void templateButton_actionPerformed(ActionEvent e) {
        this.showTemplate();
    }

    void connectionComboBox_actionPerformed(ActionEvent e) {
        this.showSelectedConnection();
    }
}

