package Bachelorpackage;

/*
 * Copyright 2017 Andreas Sitta
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.ArrayList;

/**
 * User Objekt. Wird in Part2ReducedToInput erzeugt und dient als Eingabe fr das LinkContent Modell in Part3LinkContent
 * User besitzen Dokumente und Freunde(andere User)
 * @author Andreas Sitta
 * @version 1.0
 *
 */
public class User implements Comparable<User> {
	public int id;
	//TODOSTS public int nodes; 
	public String name;
	public ArrayList<Integer> friends = new ArrayList<Integer>();
	public ArrayList<Document> docs = new ArrayList<Document>();

	
	public User(String name) {
		this.name = name;
	}
	public User(int id, String name) {
		this.id = id;
		this.name = name;
	}
	public User(int id, String name, ArrayList<Integer>friends) {
		this.id = id;
		this.name = name;
		this.friends = friends;
	}


	@Override
	public int compareTo(User user) {
		return Integer.compare(this.id, user.id);
	}
	
}	