package Bachelorpackage;

/*
 * Copyright 2017 Andreas Sitta
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

/** Diese Klasse stellt Routinen zur Verfügung die gewonnenen Daten (latente Variablen) unter verschiedenen Gesichtspunkten in Dateien auszugeben.
*/
public class ReportOut {
	static BufferedWriter rS, rT, rE, rX, rW;
    static String fileID;

	/** exportNodesEdges exportiert Knoten und Kanten in eine Datei im Gephi xml Format
	* @param dirName				Pfad in dem die Datei erzeugt werden soll
	* @param userRankedCom 	Array aller User mit nach Wahrscheinlichkeit sortierter Community
	* @param users		  			Array der User mit Namen
	*/
	public static void exportNodesEdges(String dirName, ArrayList<Delta>[] userRankedCom, ArrayList<User> users)  throws IOException {
		int[] numUsersLinks = new int[users.size()];
		int[] numFriendLinks = new int[users.size()];
		int ff = 0, nf = 0, te = 0;
		for (int i = 0; i < users.size(); i++) {
			numFriendLinks[i] = users.get(i).friends.size();
			nf++;
			for (int j = 0; j < users.get(i).friends.size(); j++)
				if (users.get(i).friends.get(j) != i) {					
					numUsersLinks[users.get(i).friends.get(j)]++;
					te++;
				}
				else	{
 					numFriendLinks[i]--;
 					nf--;
 					ff++;
 					System.out.println(i+" i = j "+j);
				}	
		}
		System.out.println("FF = "+ff+" nf "+nf+" te "+te);
			
		gexfExport.open(dirName+"-NodesEdges", true); // mit Attributen
		
		for(int u=0;u<users.size();u++) 
			if ((numFriendLinks[u] >= 1) && (numFriendLinks[u] < 200) && (numUsersLinks[u] >= 1) &&  (numUsersLinks[u] < 200)) 
			     gexfExport.writeNode(u, users.get(u).id, users.get(u).name, userRankedCom[u].get(0).community);
		
		int id=0;
		for(int u=0;u<users.size();u++) {
			if (numFriendLinks[u] >=  1 && numFriendLinks[u] < 200 && numUsersLinks[u] >= 1 &&  numUsersLinks[u] < 200)
				for(int v=0;v<users.get(u).friends.size();v++) 
					if ((numFriendLinks[v] >= 1) && (numFriendLinks[v] < 200) && (numUsersLinks[v] >= 1) &&  (numUsersLinks[v] < 200)) {
						if (users.get(u).id != v) {
							id++;
							if(users.get(v).id > users.size()) 
								System.out.println(v+ " nicht da "+ users.get(v).id);
							gexfExport.writeEdge(id, users.get(u).id, users.get(v).id);
						}
						id++;
						if(users.get(u).id != u) 
						  System.out.println(u+" uid "+users.get(u).id);
						if(users.get(v).id > users.size()) 
						  System.out.println(v+ " nicht da "+ users.get(v).id);
				  }	
		}			
		gexfExport.close();
	}

	/** exportEdges exportiert Kanten in eine Datei im Gephi xml Format
	* @param dirName				Pfad in dem die Datei erzeugt werden soll
	* @param userRankedCom 	Array aller User mit nach Wahrscheinlichkeit sortierter Community
	* @param users		  			Array der User mit Namen
	*/
	public static void exportEdges(String dirName, ArrayList<Delta>[] UserRankedCom, ArrayList<User> users)  throws IOException {
		gexfExport.open(dirName+"-Edges", true); // mit Attributen
		int id=0;
		for(int u=0;u<users.size();u++) {
			for(int v=0;v<users.get(u).friends.size();v++) {
				gexfExport.writeEdge(id, users.get(u).id, users.get(v).id);
				id++;
				if(users.get(u).id != u) System.out.println(u+" uid "+users.get(u).id);
				if(users.get(v).id > users.size()) System.out.println(v+ " nicht da "+ users.get(v).id);
			}	
		}			
		gexfExport.close();
	}    

	/** exportNodes exportiert Knoten in eine Datei im Gephi xml Format
	* @param dirName				Pfad in dem die Datei erzeugt werden soll
	* @param userRankedCom 	Array aller User mit nach Wahrscheinlichkeit sortierter Community
	* @param users		  			Array der User mit Namen
	*/
	public static void exportNodes(String dirName, ArrayList<Delta>[] UserRankedCom, ArrayList<User> users)  throws IOException {
		gexfExport.open(dirName+"-Nodes", true); // mit Attributen
		for(int u=0;u<users.size();u++) {
			gexfExport.writeNode(u, users.get(u).id, users.get(u).name, UserRankedCom[u].get(0).community);
		}
		gexfExport.close();
	}    

	
	/** psiEdges exportiert Kanten basierend auf der latenten variablen psi in eine Datei im Gephi xml Format
	* @param dirName				Pfad in dem die Datei erzeugt werden soll
	* @param userRankedCom 	Array aller User mit nach Wahrscheinlichkeit sortierter Community
	* @param users		  			Array der User mit Namen
	*/
	public static void psiEdges(String dirName, ArrayList<Psi>[] psiComUsers, ArrayList<User> users)  throws IOException {
		gexfExport.open(dirName+"-PsiNodesEdgesCom", true); // Kopf mit Attributen
		for(int u=0;u<users.size();u++) {
			gexfExport.writeNode(u, users.get(u).id, users.get(u).name, psiComUsers[0].get(u).community);
		}
		int id=0;
		for(int u=0;u<users.size();u++) {
			for(int v=0;v<users.get(u).friends.size();v++) {
				gexfExport.writeEdge(id, users.get(u).id, users.get(v).id);
				id++;
				if(users.get(u).id != u) System.out.println(u+" uid "+users.get(u).id);
				if(users.get(v).id > users.size()) System.out.println(v+ " nicht da "+ users.get(v).id);
			}	
		}			
		gexfExport.close();
	}    
	
	/** reportDelta erstellt verschiedene Ausgaben
	* @param dirName				Pfad in dem die Datei erzeugt werden soll
	* @param UserRankedCom 	Array aller User mit nach Wahrscheinlichkeit sortierter Community
	* @param users		  			Array der User mit Namen
	* 
	* -Delta.txt								Ausgabe der User mit den Wahrscheinlichkeiten ihrer Zugehörigkeit zu einer Community absteigend sortiert
	* -Delta2.txt							Ausgave der User / Community
	* -Dedges.txt							Ausgabe der Kanten 
	* -Dweightededges.txt			Ausgabe der Kanten einschließlich der wahrscheinlichsten Community mit Wahrscheinlichkeit für beide Ecken 
	*/
	public static void reportDelta(String dirName, ArrayList<Delta>[] userRankedCom, ArrayList<User> users)  throws IOException {

		int uinc[] = new int[userRankedCom[0].size()+1];
		int sumu=0;
		for(int u=0;u<userRankedCom.length;u++) {
			uinc[userRankedCom[u].get(0).community]++;
			sumu++;
		}

		rW = new BufferedWriter(new FileWriter(dirName+"-Delta2.txt"));
		for(int c=0;c<userRankedCom[0].size();c++){
			System.out.print("Community "+c+" hat "+uinc[c]+" User, entspricht "+(100.0*uinc[c]/sumu)+"%"+"\r\n");
			rW.write("Community "+c+" hat "+uinc[c]+" User, entspricht "+(100.0*uinc[c]/sumu)+"%"+"\r\n");
		}	
		rW.write(sumu+" User\r\n");
		System.out.print(sumu+" User\r\n");	
        rW.close();
		
        rS = new BufferedWriter(new FileWriter(dirName+"-Dedges.txt"));
		rE = new BufferedWriter(new FileWriter(dirName+"-Dweightededges.txt"));
		rX = new BufferedWriter(new FileWriter(dirName+"-Delta.txt"));
		for(int u=0;u<users.size();u++){
        	for(int v=0;v<users.get(u).friends.size();v++){
        		rS.write(u+"\t"+users.get(u).friends.get(v)+"\r\n");
        		rE.write(u+"\t"+users.get(u).friends.get(v)+"\t"+userRankedCom[u].get(0).community+"\t"+userRankedCom[v].get(0).community+"\t"+userRankedCom[u].get(0).prob+"\t"+userRankedCom[v].get(0).prob+"\r\n");
        	}	
        	rX.write(userRankedCom[u].get(0).user+"\t"+userRankedCom[u].get(0).userString+"\t" + userRankedCom[u].get(0).community+"\t" + userRankedCom[u].get(0).prob);
     		for(int c=1;c<userRankedCom[u].size();c++) {
         		rX.write("\t"+userRankedCom[u].get(c).community+"\t" + userRankedCom[u].get(c).prob);
     		}
     		rX.newLine();
		}	
        rS.close();
        rE.close();
        rX.close();
}	
	
	/** reportTheta erstellt verschiedene Ausgaben
	* @param dirName				Pfad in dem die Datei erzeugt werden soll
	* @param ComRankedTopic 	Array aller Communities mit nach Wahrscheinlichkeit sortierten Topics
	* 
	* -Theta.tex							Ausgabe einer Matrix bestehend aus den Dimensionen Communitz und Topic mit den yugeh;rigen Wahrscheinlichkeiten 
	*/
public static void reportTheta(String dirName, ArrayList<Theta>[] ComRankedTopic)  throws IOException {
	rT = new BufferedWriter(new FileWriter(dirName+"Theta.tex"));

	rT.write("\\begin{table}[]\r\n");
	rT.write("\\centering\r\n");
	rT.write("\\label{ComvsTopicProbs}  \r\n");
	rT.write("\\begin{tabular}{lllllllllll}\r\n");
	for(int c=0;c<ComRankedTopic[0].size();c++) rT.write("& "+(c+1)+" ");
	rT.write("\\\\  \r\n");
	for(int t=0;t<ComRankedTopic.length;t++) {
		rT.write(t+" ");
		for(int c=0;c<ComRankedTopic[0].size();c++) {
			rT.write("&"+Math.round((ComRankedTopic[t].get(c).prob)*1000.0)/1000.0);	
		}
		rT.write("\\\\  \r\n");
	}
	rT.write("\\caption{My caption}\r\n");
	rT.write("\\end{tabular}\r\n");
	rT.write("\\end{table}\r\n");
	rT.write("\r\n");
	rT.write("\r\n");
	rT.write("\r\n");
	rT.write("\r\n");
	rT.close();
	}

/** reportPhi erstellt verschiedene Ausgaben
* @param dirName					Pfad in dem die Datei erzeugt werden soll
* @param TopicRankedWord 	Array aller Topics mit nach Wahrscheinlichkeit sortierter W;rtern
* 
* -phiWortlistProbs.txt				Ausgabe einer Tabelle der top 50 Wörter für die Topics mit den zugehörigen Wahrscheinlichkeiten
* -phiWortliste.txt					Ausgabe einer Tabelle der top 50 Wörter für die Topics 
* -phiWortliste.tex					Ausgabe einer Tabelle der top 50 Wörter für die Topics als TEX-Tabellenformat 
* */
public static void reportPhi(String dirName, ArrayList<Phi>[] TopicRankedWord)  throws IOException {
	rS = new BufferedWriter(new FileWriter(dirName+"-phiWortlistProbs.txt"));
	rE = new BufferedWriter(new FileWriter(dirName+"-phiWortliste.txt"));
	rT = new BufferedWriter(new FileWriter(dirName+"-phiWortliste.tex"));
	
	rT.write("\\begin{table}[]\r\n");
	if 	((TopicRankedWord.length <= 5) && 
		(TopicRankedWord.length >= 4)) rT.write("\\small\r\n");
	if 	(TopicRankedWord.length > 5) rT.write("\\tiny\r\n");
	rT.write("\\centering\r\n");
	rT.write("\\label{ComvsTopicProbs}  \r\n");
	rT.write("\\begin{tabular}{");
	for(int i=0;i<TopicRankedWord.length;i++) 	rT.write("l");
	rT.write("}\r\n");
	
	rT.write("\\textbf{Topic 1}");
	rS.write("Topic 1");
	rE.write("Topic 1");
	for(int i=1;i<TopicRankedWord.length;i++) {
		rT.write("&\\textbf{Topic "+(i+1)+"}");
		rS.write("\tTopic "+(i+1));
		rE.write("\tTopic "+(i+1));
	}
	rT.write("\\\\ \r\n");
	rS.write(" \r\n");
	rE.write(" \r\n");
	
	rT.write("\\textbf{ Hier Text  } ");
	for(int i=1;i<TopicRankedWord.length;i++)  rT.write("&\\textbf{  Hier Text  } ");
	rT.write("\\\\ \r\n");
	
	for(int w=0;w<50;w++){
		rT.write(TopicRankedWord[0].get(w).wordString);
		rS.write(TopicRankedWord[0].get(w).wordString+"\t"+Math.round((TopicRankedWord[0].get(w).prob)*1000.0)/1000.0);
		rE.write(TopicRankedWord[0].get(w).wordString);
		for(int i=1;i<TopicRankedWord.length;i++) {
			rT.write("&"+TopicRankedWord[i].get(w).wordString);
			rS.write("\t"+TopicRankedWord[i].get(w).wordString+"\t"+Math.round((TopicRankedWord[i].get(w).prob)*1000.0)/1000.0);
			rE.write("\t"+TopicRankedWord[i].get(w).wordString);
		}
		rT.write("\\\\ \r\n");
		rS.newLine();
		rE.newLine();
		}
	rS.newLine();
	rE.newLine();
	rT.write("\\end{tabular}\r\n");
    rT.write("\\caption{My caption}\r\n");
	rT.write("\\end{table}\r\n");
	rT.write("\r\n");
	rT.write("\r\n");
	rT.write("\r\n");
	rT.write("\r\n");

	rT.close();
	rS.close();
	rE.close();
}

/**
 *  reportPsi erstellt verschiedene Ausgaben
 * @param fileName					Dateiname
 * @param ComRankedUser		Sortiertes Array Community vs. User
 * @throws IOException
 * 
 * -psi.txt					Ausgabe einer Tabelle der top 50 User für die Communities 
 * -psi.tex					Ausgabe einer Tabelle der top 50 User für die Communities als TEX-Tabellenformat 
 */
public static void reportPsi(String fileName, ArrayList<Psi>[] ComRankedUser)  throws IOException {
	rS = new BufferedWriter(new FileWriter(fileName+"-psi.txt"));
	rT = new BufferedWriter(new FileWriter( fileName+"-psi.tex"));
	
	rT.write("\\begin{table}[]\r\n");
	rT.write("\\centering\r\n");
	rT.write("\\label{ComvsTopicProbs}  \r\n");
	rT.write("\\begin{tabular}{");
	for(int i=0;i<ComRankedUser.length;i++) 	rT.write("l");
	rT.write("}\r\n");
	for(int i=0;i<ComRankedUser.length;i++) {
		rT.write("Community "+i+"\t");
		rS.write("Community "+i+"\t");
	}
	rT.write("\r\n");
	rS.newLine();
	
	for(int w=0;w<50;w++){
		rT.write(ComRankedUser[0].get(w).userString);
		rS.write(ComRankedUser[0].get(w).userString+"\t"+Math.round((ComRankedUser[0].get(w).prob)*1000.0)/1000.0);
		for(int i=1;i<ComRankedUser.length;i++) {
			rT.write("&"+ComRankedUser[i].get(w).userString);
			rS.write("\t"+ComRankedUser[i].get(w).userString+"\t"+Math.round((ComRankedUser[i].get(w).prob)*1000.0)/1000.0);
		}
		rT.write("\\\\ \r\n");
		rS.newLine();
	}
	rS.newLine();
    rT.write("\\caption{My caption}\r\n");
	rT.write("\\end{tabular}\r\n");
	rT.write("\\end{table}\r\n");
	rT.write("\r\n");
	rT.write("\r\n");
	rT.write("\r\n");
	rT.write("\r\n");
	rT.close();
	rS.close();
}

/**
 * Erstellt Datei mit Wortliste sortiert nach Häufigkeit
 * @param dName				Pfadname
 * @param vocabulary			Vokabular, nicht komprimiert
 * @throws IOException
 */
public static void writeWordFreqList(String dName,  ArrayList<String> vocabulary) throws IOException{
	BufferedWriter  bWL1,bWL2 ;
	Collections.sort(vocabulary); 
	ArrayList<Word> idFreqLists = new ArrayList<Word>();
	String currentWord = vocabulary.get(0);
	int wordCount = 1;
	for (int i = 1; i < vocabulary.size(); i++) {
		if (currentWord.equals(vocabulary.get(i)))
			wordCount++;
		else {
			Word newword = new Word(Collections.binarySearch(vocabulary, currentWord), wordCount);
			if (! idFreqLists.contains(newword))
				idFreqLists.add(newword);
			wordCount = 1;
			currentWord = vocabulary.get(i);
		}
	}
	Word newword = new Word(Collections.binarySearch(vocabulary, currentWord), wordCount);
	if (! idFreqLists.contains(newword))
		idFreqLists.add(newword);
	//Collections.sort(idFreqLists, Collections.reverseOrder());
	
	Collections.sort(idFreqLists, new FreqComparator().reversed());
	bWL1 = new BufferedWriter(new FileWriter(dName+"-Full.txt"));
	bWL2 = new BufferedWriter(new FileWriter(dName+"-Part.txt"));

	int pMod = idFreqLists.size() / 100;

	for (int i = 0; i < idFreqLists.size() / 3; i++) {
		bWL1.write(vocabulary.get(idFreqLists.get(i).id)+"\t "+idFreqLists.get(i).freq+" \r\n");
		if ((pMod > 0) && (i % pMod == 0))
			bWL2.write(i+"\t "+idFreqLists.get(i).freq+" \r\n");
	}
	bWL1.close();
	bWL2.close();
}

}