/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.exercise.fpGrowth;

import edu.udo.cs.yale.operator.exercise.fpGrowth.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FPTreeNode {
    protected int frequency = 0;
    protected Item nodeItem;
    protected FPTreeNode sibling;
    protected FPTreeNode father;
    protected Map<Item, FPTreeNode> children;

    public FPTreeNode() {
        this.children = new HashMap<Item, FPTreeNode>();
    }

    public FPTreeNode(FPTreeNode father, Item nodeItem) {
        this.father = father;
        this.children = new HashMap<Item, FPTreeNode>();
        this.nodeItem = nodeItem;
    }

    public void addItemSet(Collection<Item> itemSet, int weight, Map<Item, FPTreeNode> siblingChain) {
        Iterator<Item> iterator = itemSet.iterator();
        if (iterator.hasNext()) {
            FPTreeNode childNode;
            Item currentItem = iterator.next();
            if (!this.children.containsKey(currentItem)) {
                childNode = this.createChildNode(currentItem);
                this.children.put(currentItem, childNode);
                if (!siblingChain.containsKey(currentItem)) {
                    siblingChain.put(currentItem, childNode);
                } else {
                    FPTreeNode currentNode = siblingChain.get(currentItem);
                    while (currentNode.hasSibling()) {
                        currentNode = currentNode.getSibling();
                    }
                    currentNode.setSibling(childNode);
                }
            } else {
                childNode = this.children.get(currentItem);
            }
            itemSet.remove(currentItem);
            childNode = this.children.get(currentItem);
            childNode.increaseFrequency(weight);
            childNode.addItemSet(itemSet, weight, siblingChain);
        }
    }

    public void prune(double minSupport, int numberOfTransactions) {
        Collection items = this.children.keySet();
        ArrayList<Item> removeItems = new ArrayList<Item>();
        Iterator iterator = items.iterator();
        int minFrequency = (int)((double)numberOfTransactions * minSupport);
        while (iterator.hasNext()) {
            Item currentItem = (Item)iterator.next();
            FPTreeNode currentNode = this.children.get(currentItem);
            if (currentNode.getFrequency() < minFrequency) {
                removeItems.add(currentItem);
                continue;
            }
            currentNode.prune(minSupport, numberOfTransactions);
        }
        iterator = removeItems.iterator();
        while (iterator.hasNext()) {
            this.children.remove(iterator.next());
        }
    }

    public FPTreeNode getFather() {
        return this.father;
    }

    public boolean hasFather() {
        return this.father != null;
    }

    public FPTreeNode getSibling() {
        return this.sibling;
    }

    public FPTreeNode getLastSibling() {
        FPTreeNode currentNode = this;
        while (currentNode.hasSibling()) {
            currentNode = currentNode.getSibling();
        }
        return currentNode;
    }

    public void setSibling(FPTreeNode sibling) {
        this.sibling = sibling;
    }

    public boolean hasSibling() {
        return this.sibling != null;
    }

    public void increaseFrequency(int weight) {
        this.frequency += weight;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public Item getNodeItem() {
        return this.nodeItem;
    }

    public Map<Item, FPTreeNode> getChildren() {
        return this.children;
    }

    public FPTreeNode getChild() {
        if (this.children.size() != 1) {
            return null;
        }
        return this.children.get(this.children.keySet().iterator().next());
    }

    public FPTreeNode createChildNode(Item nodeItem) {
        return new FPTreeNode(this, nodeItem);
    }
}

