/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.exercise.fpGrowth;

import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.exercise.fpGrowth.FPTreeNode;
import edu.udo.cs.yale.operator.exercise.fpGrowth.FrequentItemSets;
import edu.udo.cs.yale.operator.exercise.fpGrowth.Item;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FPTree
extends FPTreeNode {
    protected double minSupport;
    protected int numberOfTransactions;
    protected FrequentItemSets rules;
    protected Map<Item, FPTreeNode> siblingChain = new HashMap<Item, FPTreeNode>();
    protected Collection<Item> conditionalItems;
    private Class treeMinerClass;

    public FPTree() {
        this.children = new HashMap();
        this.conditionalItems = new LinkedList<Item>();
    }

    public void addItemSet(Collection<Item> itemSet, int weight) {
        this.addItemSet(itemSet, weight, this.siblingChain);
    }

    public abstract void mineTree(FrequentItemSets var1) throws UserError;

    protected boolean isSinglePath(FPTree tree) {
        if (this.children.size() > 1) {
            return false;
        }
        FPTreeNode currentNode = (FPTreeNode)this.children.get(this.children.keySet().iterator().next());
        while (currentNode.getChildren().size() == 1) {
            currentNode = currentNode.getChild();
        }
        return currentNode.getChildren().size() == 0;
    }

    protected Collection<Item> getPrefixOfNode(FPTreeNode node) {
        LinkedList<Item> prefix = new LinkedList<Item>();
        FPTreeNode currentNode = node;
        while (currentNode.hasFather()) {
            currentNode = currentNode.getFather();
            prefix.add(currentNode.getNodeItem());
        }
        Collections.reverse(prefix);
        return prefix;
    }

    public FPTree getEmptyConditionalTree(Collection<Item> condition) throws UserError {
        try {
            FPTree tree = (FPTree)this.treeMinerClass.newInstance();
            tree.setTreeClass(this.treeMinerClass);
            tree.setConditionalItems(condition);
            tree.setMinimalSupport(this.minSupport);
            tree.setNumberOfTransactions(this.numberOfTransactions);
            tree.setRulesContainer(this.rules);
            return tree;
        }
        catch (InstantiationException exception) {
            throw new UserError(null, 904, (Object)this.treeMinerClass.getName(), (Object)exception.getMessage());
        }
        catch (IllegalAccessException exception) {
            throw new UserError(null, 904, (Object)this.treeMinerClass.getName(), (Object)exception.getMessage());
        }
    }

    @Override
    public FPTreeNode createChildNode(Item nodeItem) {
        return new FPTreeNode(null, nodeItem);
    }

    public void setMinimalSupport(double minSupport) {
        this.minSupport = minSupport;
    }

    public void setNumberOfTransactions(int numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
    }

    public void setRulesContainer(FrequentItemSets rules) {
        this.rules = rules;
    }

    public void setConditionalItems(Collection<Item> conditionalItems) {
        this.conditionalItems = conditionalItems;
    }

    public void setTreeClass(Class treeMinerClass) {
        this.treeMinerClass = treeMinerClass;
    }
}

