/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.exercise.fpGrowth;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.exercise.fpGrowth.FPTree;
import edu.udo.cs.yale.operator.exercise.fpGrowth.FrequentItemSets;
import edu.udo.cs.yale.operator.exercise.fpGrowth.Item;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.Tools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FPGrowth
extends Operator {
    private double minSupport;

    public FPGrowth(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        String treeMiner = this.getParameterAsString("name_of_implementing_class");
        try {
            Class treeMinerClass = Tools.classForName((String)treeMiner);
            ExampleSet exampleSet = (ExampleSet)this.getInput(ExampleSet.class);
            FrequentItemSets rules = new FrequentItemSets();
            this.minSupport = this.getParameterAsDouble("min_support");
            int minFrequency = (int)(this.minSupport * (double)exampleSet.size());
            int numberOfAttributes = exampleSet.getNumberOfAttributes();
            boolean[] useAttributes = this.isBooleanAttribute(exampleSet);
            Map<Attribute, Item> mapping = this.getAttributeMapping(exampleSet, useAttributes);
            this.getFrequentItems(exampleSet, mapping, useAttributes);
            int i = 0;
            while (i < numberOfAttributes) {
                useAttributes[i] = useAttributes[i] && mapping.get(exampleSet.getAttribute(i)).getFrequency() >= minFrequency;
                ++i;
            }
            FPTree tree = this.getFPTree(exampleSet, mapping, useAttributes, rules, treeMinerClass);
            tree.mineTree(rules);
            return new IOObject[]{rules};
        }
        catch (ClassNotFoundException exception) {
            throw new UserError(null, 904, (Object)treeMiner, (Object)exception.getMessage());
        }
    }

    private FPTree getFPTree(ExampleSet exampleSet, Map<Attribute, Item> mapping, boolean[] useAttributes, FrequentItemSets rules, Class treeMinerClass) throws UserError {
        try {
            FPTree tree = (FPTree)treeMinerClass.newInstance();
            tree.setTreeClass(treeMinerClass);
            tree.setMinimalSupport(this.minSupport);
            tree.setNumberOfTransactions(exampleSet.size());
            tree.setRulesContainer(rules);
            int numberOfAttributes = exampleSet.getNumberOfAttributes();
            for (Example currentExample : exampleSet) {
                ArrayList<Item> itemSet = new ArrayList<Item>();
                int i = 0;
                while (i < numberOfAttributes) {
                    Attribute currentAttribute = exampleSet.getAttribute(i);
                    if (useAttributes[i] && currentExample.getValue(currentAttribute) == (double)exampleSet.getAttribute(i).mapString("true")) {
                        itemSet.add(mapping.get(currentAttribute));
                    }
                    ++i;
                }
                Collections.sort(itemSet);
                tree.addItemSet(itemSet, 1);
            }
            return tree;
        }
        catch (InstantiationException exception) {
            throw new UserError(null, 904, (Object)treeMinerClass.getName(), (Object)exception.getMessage());
        }
        catch (IllegalAccessException exception) {
            throw new UserError(null, 904, (Object)treeMinerClass.getName(), (Object)exception.getMessage());
        }
    }

    private boolean[] isBooleanAttribute(ExampleSet exampleSet) {
        int numberofAttributes = exampleSet.getNumberOfAttributes();
        boolean[] useAttributes = new boolean[numberofAttributes];
        int i = 0;
        while (i < numberofAttributes) {
            useAttributes[i] = exampleSet.getAttribute(i).isBooleanClassification();
            ++i;
        }
        return useAttributes;
    }

    private Map<Attribute, Item> getAttributeMapping(ExampleSet exampleSet, boolean[] useAttributes) {
        int numberOfAttributes = useAttributes.length;
        HashMap<Attribute, Item> mapping = new HashMap<Attribute, Item>();
        Attribute[] attributes = new Attribute[numberOfAttributes];
        int i = 0;
        while (i < numberOfAttributes) {
            attributes[i] = exampleSet.getAttribute(i);
            if (useAttributes[i]) {
                mapping.put(attributes[i], new Item(attributes[i].getName()));
            }
            ++i;
        }
        return mapping;
    }

    private void getFrequentItems(ExampleSet exampleSet, Map<Attribute, Item> mapping, boolean[] useAttributes) {
        int numberOfAttributes = exampleSet.getNumberOfAttributes();
        for (Example currentExample : exampleSet) {
            int i = 0;
            while (i < numberOfAttributes) {
                if (useAttributes[i] && currentExample.getValue(exampleSet.getAttribute(i)) == (double)exampleSet.getAttribute(i).mapString("true")) {
                    mapping.get(exampleSet.getAttribute(i)).increaseFrequency();
                }
                ++i;
            }
        }
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{FrequentItemSets.class};
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString("name_of_implementing_class", "Fully qualified classname of the class implementing FPGrowthApplier", "FPGrowthApplier");
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("min_support", "Minimal Support", 0.0, 1.0, 0.5);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

