/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.exercise;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.exercise.KNearestNeighborPredictor;
import edu.udo.cs.yale.operator.learner.SimplePredictionModel;
import edu.udo.cs.yale.tools.math.som.DistanceFunction;
import edu.udo.cs.yale.tools.math.som.EuclideanDistance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KNearestNeighborModel
extends SimplePredictionModel {
    private ArrayList<Example> trainingExamples = new ArrayList();
    private DistanceFunction distance = new EuclideanDistance();
    private int useNeighbors;
    private Attribute classAttribute;
    private String interfaceName;

    public KNearestNeighborModel(ArrayList<Example> examples, int useNeighbors, Attribute classAttribute, String interfaceName) {
        super(classAttribute);
        this.trainingExamples = examples;
        this.useNeighbors = useNeighbors;
        this.classAttribute = classAttribute;
        this.interfaceName = interfaceName;
    }

    public double predict(Example example) throws OperatorException {
        return this.predictClass(example, this.useNeighbors);
    }

    protected double predictClass(Example example, int useNeighbors) throws OperatorException {
        try {
            Class<?> clazz = Class.forName(this.interfaceName);
            KNearestNeighborPredictor predictor = (KNearestNeighborPredictor)clazz.newInstance();
            return predictor.predictClass(this.trainingExamples, example, useNeighbors);
        }
        catch (InstantiationException exception) {
            throw new UserError(null, 904, (Object)this.interfaceName, (Object)exception.getMessage());
        }
        catch (IllegalAccessException exception) {
            throw new UserError(null, 904, (Object)this.interfaceName, (Object)exception.getMessage());
        }
        catch (ClassNotFoundException exception) {
            throw new UserError(null, 904, (Object)this.interfaceName, (Object)exception.getMessage());
        }
    }

    protected Iterator<Example> getTrainDataIterator() {
        return this.trainingExamples.iterator();
    }

    protected double getClassOfExample(Example example) {
        return example.getValue(this.classAttribute);
    }

    protected double[] getValues(Example example) {
        double[] values = new double[example.getNumberOfAttributes()];
        int i = 0;
        while (i < example.getNumberOfAttributes()) {
            values[i] = example.getValue(i);
            ++i;
        }
        return values;
    }

    protected double getDistance(double[] point1, double[] point2) {
        return this.distance.getDistance(point1, point2);
    }

    public void readPredictionModelData(ObjectInputStream in) throws IOException {
    }

    public void writePredictionModelData(ObjectOutputStream out) throws IOException {
    }
}

