/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.exercise;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.exercise.KNearestNeighborModel;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KNearestNeighbor
extends AbstractLearner {
    public KNearestNeighbor(OperatorDescription description) {
        super(description);
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        ArrayList<Example> trainData = new ArrayList<Example>();
        Iterator iterator = exampleSet.iterator();
        while (iterator.hasNext()) {
            trainData.add((Example)iterator.next());
        }
        return new KNearestNeighborModel(trainData, this.getParameterAsInt("k"), exampleSet.getLabel(), this.getParameterAsString("name_of_implementing_class"));
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("k", "Number of neighbors used for class decision", 1, Integer.MAX_VALUE, 3);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString("name_of_implementing_class", "Fully qualified classname of the class implementing KNearestNeighborPredictor", "edu.udo.cs.yale.operator.exercise.KNearestNeighborModelExercise");
        type.setExpert(false);
        types.add(type);
        return types;
    }

    public boolean supportsCapability(LearnerCapability capability) {
        return capability == LearnerCapability.NUMERICAL_ATTRIBUTES;
    }
}

