/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.exercise;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.exercise.KMeansApplier;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeans
extends Operator {
    private Attribute clusterAttribute;
    private ExampleSet exampleSet;

    public KMeans(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        this.exampleSet = (ExampleSet)this.getInput(ExampleSet.class);
        this.clusterAttribute = this.exampleSet.createClusterAttribute();
        this.exampleSet.setCluster(this.clusterAttribute);
        int numberOfClusters = this.getParameterAsInt("number_of_clusters");
        this.apply(this.exampleSet, numberOfClusters);
        return new IOObject[]{this.exampleSet};
    }

    protected void apply(ExampleSet exampleSet, int numberOfClusters) throws OperatorException {
        String interfaceName = this.getParameterAsString("name_of_implementing_class");
        try {
            Class<?> clazz = Class.forName(interfaceName);
            KMeansApplier applier = (KMeansApplier)clazz.newInstance();
            applier.apply(exampleSet, numberOfClusters, this.clusterAttribute);
        }
        catch (InstantiationException exception) {
            throw new UserError(null, 904, (Object)interfaceName, (Object)exception.getMessage());
        }
        catch (IllegalAccessException exception) {
            throw new UserError(null, 904, (Object)interfaceName, (Object)exception.getMessage());
        }
        catch (ClassNotFoundException exception) {
            throw new UserError(null, 904, (Object)interfaceName, (Object)exception.getMessage());
        }
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_of_clusters", "Number of clusters", 1, Integer.MAX_VALUE, 3);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString("name_of_implementing_class", "Fully qualified classname of the class implementing KMeansApplier", "KMeansExercise");
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

