/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.exercise;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.exercise.ID3Builder3;
import edu.udo.cs.yale.operator.exercise.ID3Model2;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ID3Model3
extends ID3Model2 {
    private double logFactor = Math.log(2.0);
    private Collection<ID3Model3> successors = new ArrayList<ID3Model3>();
    private boolean isLeaf;
    private double label;
    private double splitValue = 0.5;
    private double numericalSplitValue = 0.5;
    private int splitIndex;
    private int numberOfExamples;
    private Attribute splitAttribute;
    private boolean[] attributeMask;
    private ID3Builder3 builder;

    public ID3Model3(Attribute labelAttribute, ExampleSet exampleSet, ID3Builder3 builder) throws UserError {
        super(labelAttribute);
        this.builder = builder;
        this.attributeMask = new boolean[exampleSet.getNumberOfAttributes()];
        this.buildTree(exampleSet);
    }

    public ID3Model3(ExampleSet exampleSet, boolean[] attributeMask, double splitValue, ID3Builder3 builder) {
        this.builder = builder;
        this.attributeMask = (boolean[])attributeMask.clone();
        this.splitValue = splitValue;
        this.buildTree(exampleSet);
    }

    public ID3Model3(ExampleSet exampleSet, boolean[] attributeMask, int splitIndex, ID3Builder3 builder) {
        this.builder = builder;
        this.attributeMask = (boolean[])attributeMask.clone();
        this.splitIndex = splitIndex;
        this.buildTree(exampleSet);
    }

    private void buildTree(ExampleSet exampleSet) {
        this.numberOfExamples = exampleSet.size();
        boolean isLeaf = true;
        int i = 0;
        while (i < this.attributeMask.length) {
            isLeaf = isLeaf && this.attributeMask[i];
            ++i;
        }
        if (this.isSingleLabelExampleSet(exampleSet) || isLeaf) {
            this.isLeaf = true;
            this.label = ((Example)exampleSet.iterator().next()).getLabel();
        } else {
            Collection<ExampleSet> successorSets;
            Attribute splitAttribute = this.getSplitAttribute(exampleSet);
            if (splitAttribute.isNominal()) {
                successorSets = this.getExampleSets(exampleSet, this.builder.split(exampleSet, splitAttribute));
            } else {
                this.numericalSplitValue = this.getBestSplitValue(exampleSet, splitAttribute);
                successorSets = this.getExampleSets(exampleSet, this.builder.split(exampleSet, splitAttribute, this.numericalSplitValue));
            }
            for (ExampleSet partedExampleSet : successorSets) {
                if (partedExampleSet.size() <= 0) continue;
                Example example = partedExampleSet.getExample(0);
                double splitValue = example.getValue(splitAttribute);
                if (splitAttribute.isNominal()) {
                    this.successors.add(new ID3Model3(partedExampleSet, this.attributeMask, splitValue, this.builder));
                    continue;
                }
                int splitIndex = 0;
                if (splitValue < this.splitValue) {
                    splitIndex = 0;
                }
                if (splitValue >= this.splitValue) {
                    splitIndex = 1;
                }
                this.successors.add(new ID3Model3(partedExampleSet, this.attributeMask, splitIndex, this.builder));
            }
        }
    }

    private boolean isSingleLabelExampleSet(ExampleSet exampleSet) {
        boolean isSingleLabeled = true;
        Iterator iterator = exampleSet.iterator();
        Attribute labelAttribute = exampleSet.getLabel();
        double labelValue = Double.NEGATIVE_INFINITY;
        while (iterator.hasNext()) {
            if (labelValue == Double.NEGATIVE_INFINITY) {
                labelValue = ((Example)iterator.next()).getValue(labelAttribute);
                continue;
            }
            if (labelValue == ((Example)iterator.next()).getValue(labelAttribute)) continue;
            isSingleLabeled = false;
            break;
        }
        return isSingleLabeled;
    }

    protected Attribute getSplitAttribute(ExampleSet exampleSet) {
        this.splitAttribute = this.builder.getSplitAttribute(exampleSet, this.attributeMask);
        return this.splitAttribute;
    }

    protected double getSplitValue(ExampleSet exampleSet, Attribute attribute) {
        return this.splitValue;
    }

    protected double getNumericalSplitValue(ExampleSet exampleSet, Attribute attribute) {
        return this.numericalSplitValue;
    }

    protected double getInfoGain(ExampleSet exampleSet, Attribute attribute) {
        return this.builder.getInfoGain(exampleSet, attribute);
    }

    protected double getBestSplitValue(ExampleSet exampleSet, Attribute attribute) {
        return this.builder.getBestSplitValue(exampleSet, attribute);
    }

    public double predict(Example example) throws OperatorException {
        if (!this.isLeaf) {
            double value = example.getValue(this.splitAttribute);
            for (ID3Model3 currentSucc : this.successors) {
                if (!(this.splitAttribute.isNominal() ? currentSucc.getSplitValue() == value : value >= this.numericalSplitValue && currentSucc.getSplitIndex() == 1 || value < this.numericalSplitValue && currentSucc.getSplitIndex() == 0)) continue;
                return currentSucc.predict(example);
            }
            return 0.0;
        }
        return this.label;
    }

    public void readPredictionModelData(ObjectInputStream in) throws IOException {
    }

    public void writePredictionModelData(ObjectOutputStream out) throws IOException {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toString(""));
        return buffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public String toString(String ebene) {
        block3: {
            block2: {
                buffer = new StringBuffer();
                if (this.isLeaf) break block2;
                iterator = this.successors.iterator();
                if (!this.splitAttribute.isNominal()) ** GOTO lbl34
                while (iterator.hasNext()) {
                    currentSucc = iterator.next();
                    buffer.append("\n");
                    buffer.append(ebene);
                    buffer.append(String.valueOf(this.splitAttribute.getName()) + " = ");
                    buffer.append(this.splitAttribute.getAsString(currentSucc.getSplitValue(), 0));
                    buffer.append("(" + this.numberOfExamples + ")");
                    buffer.append(currentSucc.toString(String.valueOf(ebene) + "|  "));
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    currentSucc = iterator.next();
                    buffer.append("\n");
                    buffer.append(ebene);
                    buffer.append(String.valueOf(this.splitAttribute.getName()) + "  SplitValue: " + this.numericalSplitValue);
                    buffer.append(" Split: " + currentSucc.getSplitIndex());
                    buffer.append("(" + currentSucc.getRemainingExamples() + ")");
                    buffer.append(currentSucc.toString(String.valueOf(ebene) + "|  "));
lbl34:
                    // 2 sources

                    ** while (iterator.hasNext())
                }
lbl35:
                // 1 sources

                break block3;
            }
            buffer.append("  Label: " + this.label);
        }
        return buffer.toString();
    }

    public double getSplitValue() {
        return this.splitValue;
    }

    public int getSplitIndex() {
        return this.splitIndex;
    }

    public int getRemainingExamples() {
        return this.numberOfExamples;
    }
}

