/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.exercise;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Partition;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.exercise.ID3Builder2;
import edu.udo.cs.yale.operator.exercise.ID3Model1;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID3Model2
extends ID3Model1 {
    private double logFactor = Math.log(2.0);
    private Collection<ID3Model2> successors = new ArrayList<ID3Model2>();
    private boolean isLeaf;
    private double label;
    private double splitValue = 0.5;
    private int splitIndex;
    private int numberOfExamples;
    private Attribute splitAttribute;
    private boolean[] attributeMask;
    private ID3Builder2 builder;

    public ID3Model2(Attribute labelAttribute, ExampleSet exampleSet, ID3Builder2 builder) throws UserError {
        super(labelAttribute);
        this.builder = builder;
        this.attributeMask = new boolean[exampleSet.getNumberOfAttributes()];
        this.buildTree(exampleSet);
    }

    public ID3Model2(ExampleSet exampleSet, boolean[] attributeMask, double splitValue, int splitIndex, ID3Builder2 builder) {
        this.builder = builder;
        this.attributeMask = (boolean[])attributeMask.clone();
        this.splitValue = splitValue;
        this.splitIndex = splitIndex;
        this.buildTree(exampleSet);
    }

    public ID3Model2() {
    }

    public ID3Model2(Attribute labelAttribute) {
        super(labelAttribute);
    }

    private void buildTree(ExampleSet exampleSet) {
        this.numberOfExamples = exampleSet.size();
        boolean isLeaf = true;
        int i = 0;
        while (i < this.attributeMask.length) {
            isLeaf = isLeaf && this.attributeMask[i];
            ++i;
        }
        if (this.isSingleLabelExampleSet(exampleSet) || isLeaf) {
            this.isLeaf = true;
            this.label = ((Example)exampleSet.iterator().next()).getLabel();
        } else {
            Attribute splitAttribute = this.getSplitAttribute(exampleSet);
            Collection<ExampleSet> successorSets = this.split(exampleSet, splitAttribute, this.splitValue);
            for (ExampleSet partedExampleSet : successorSets) {
                if (partedExampleSet.size() <= 0) continue;
                Example example = partedExampleSet.getExample(0);
                double splitValue = example.getValue(splitAttribute);
                if (splitAttribute.isNominal()) {
                    this.successors.add(new ID3Model2(partedExampleSet, this.attributeMask, splitValue, 0, this.builder));
                    continue;
                }
                int splitIndex = 0;
                if (splitValue < this.splitValue) {
                    splitIndex = 0;
                }
                if (splitValue >= this.splitValue) {
                    splitIndex = 1;
                }
                this.successors.add(new ID3Model2(partedExampleSet, this.attributeMask, this.splitValue, splitIndex, this.builder));
            }
        }
    }

    private boolean isSingleLabelExampleSet(ExampleSet exampleSet) {
        boolean isSingleLabeled = true;
        Iterator iterator = exampleSet.iterator();
        Attribute labelAttribute = exampleSet.getLabel();
        double labelValue = Double.NEGATIVE_INFINITY;
        while (iterator.hasNext()) {
            if (labelValue == Double.NEGATIVE_INFINITY) {
                labelValue = ((Example)iterator.next()).getValue(labelAttribute);
                continue;
            }
            if (labelValue == ((Example)iterator.next()).getValue(labelAttribute)) continue;
            isSingleLabeled = false;
            break;
        }
        return isSingleLabeled;
    }

    protected Collection<ExampleSet> split(ExampleSet exampleSet, Attribute attribute, double splitValue) {
        if (attribute.isNominal()) {
            return this.getExampleSets(exampleSet, this.builder.split(exampleSet, attribute));
        }
        return this.getExampleSets(exampleSet, this.builder.split(exampleSet, attribute, splitValue));
    }

    @Override
    protected Collection<ExampleSet> getExampleSets(ExampleSet exampleSet, int[] partition) {
        int[] sortedPartition = (int[])partition.clone();
        Arrays.sort(sortedPartition);
        int numberOfPartitions = sortedPartition[sortedPartition.length - 1] + 1;
        Partition splitPartition = new Partition(partition, numberOfPartitions);
        ArrayList<ExampleSet> partitions = new ArrayList<ExampleSet>(numberOfPartitions);
        int i = 0;
        while (i < numberOfPartitions) {
            SplittedExampleSet splittedSet = new SplittedExampleSet(exampleSet, (Partition)splitPartition.clone());
            splittedSet.selectSingleSubset(i);
            partitions.add((ExampleSet)splittedSet);
            ++i;
        }
        return partitions;
    }

    @Override
    protected int getPartition(double value, double[] values, int foundValues) {
        int i = 0;
        while (i < foundValues) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected Attribute getSplitAttribute(ExampleSet exampleSet) {
        this.splitAttribute = this.builder.getSplitAttribute(exampleSet, this.attributeMask);
        return this.splitAttribute;
    }

    protected double getSplitValue(ExampleSet exampleSet, Attribute attribute) {
        return this.splitValue;
    }

    @Override
    protected double getInfoGain(ExampleSet exampleSet, Attribute attribute) {
        return this.builder.getInfoGain(exampleSet, attribute);
    }

    protected double getBestSplitValue(ExampleSet exampleSet, Attribute attribute) {
        return this.splitValue;
    }

    @Override
    protected double getEntropy(ExampleSet exampleSet) {
        double[] classCounter = new double[exampleSet.getLabel().getNumberOfValues()];
        for (Example currentExample : exampleSet) {
            int n = (int)currentExample.getLabel();
            classCounter[n] = classCounter[n] + 1.0;
        }
        double entropy = 0.0;
        int i = 0;
        while (i < classCounter.length) {
            if (classCounter[i] > 0.0) {
                entropy -= Math.log(classCounter[i]) * classCounter[i] / this.logFactor;
            }
            ++i;
        }
        return entropy / (double)exampleSet.size() + Math.log(exampleSet.size()) / this.logFactor;
    }

    @Override
    public double predict(Example example) throws OperatorException {
        if (!this.isLeaf) {
            double value = example.getValue(this.splitAttribute);
            for (ID3Model2 currentSucc : this.successors) {
                if (!(this.splitAttribute.isNominal() ? currentSucc.getSplitValue() == value : value > this.splitValue && currentSucc.getSplitIndex() == 2 || value == this.splitValue && currentSucc.getSplitIndex() == 1 || value < this.splitValue && currentSucc.getSplitIndex() == 0)) continue;
                return currentSucc.predict(example);
            }
            return 0.0;
        }
        return this.label;
    }

    @Override
    public void readPredictionModelData(ObjectInputStream in) throws IOException {
    }

    @Override
    public void writePredictionModelData(ObjectOutputStream out) throws IOException {
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toString(""));
        return buffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String toString(String ebene) {
        block3: {
            block2: {
                buffer = new StringBuffer();
                if (this.isLeaf) break block2;
                iterator = this.successors.iterator();
                if (!this.splitAttribute.isNominal()) ** GOTO lbl34
                while (iterator.hasNext()) {
                    currentSucc = iterator.next();
                    buffer.append("\n");
                    buffer.append(ebene);
                    buffer.append(String.valueOf(this.splitAttribute.getName()) + " = ");
                    buffer.append(this.splitAttribute.getAsString(currentSucc.getSplitValue(), 0));
                    buffer.append("(" + this.numberOfExamples + ")");
                    buffer.append(currentSucc.toString(String.valueOf(ebene) + "|  "));
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    currentSucc = iterator.next();
                    buffer.append("\n");
                    buffer.append(ebene);
                    buffer.append(String.valueOf(this.splitAttribute.getName()) + "  SplitValue: " + this.splitValue);
                    buffer.append(" Split: " + currentSucc.getSplitIndex());
                    buffer.append("(" + this.numberOfExamples + ")");
                    buffer.append(currentSucc.toString(String.valueOf(ebene) + "|  "));
lbl34:
                    // 2 sources

                    ** while (iterator.hasNext())
                }
lbl35:
                // 1 sources

                break block3;
            }
            buffer.append("  Label: " + this.label);
        }
        return buffer.toString();
    }

    @Override
    public double getSplitValue() {
        return this.splitValue;
    }

    public int getSplitIndex() {
        return this.splitIndex;
    }
}

