/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.exercise;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Partition;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.exercise.ID3Builder1;
import edu.udo.cs.yale.operator.learner.SimplePredictionModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID3Model1
extends SimplePredictionModel {
    private double logFactor = Math.log(2.0);
    private Collection<ID3Model1> successors = new ArrayList<ID3Model1>();
    private boolean isLeaf;
    private double label;
    private double splitValue;
    private int numberOfExamples;
    private Attribute splitAttribute;
    private boolean[] attributeMask;
    private ID3Builder1 builder;

    public ID3Model1(Attribute labelAttribute, ExampleSet exampleSet, ID3Builder1 builder) throws UserError {
        super(labelAttribute);
        this.builder = builder;
        this.attributeMask = new boolean[exampleSet.getNumberOfAttributes()];
        this.buildTree(exampleSet);
    }

    public ID3Model1(ExampleSet exampleSet, boolean[] attributeMask, double splitValue, ID3Builder1 builder) throws UserError {
        this.attributeMask = (boolean[])attributeMask.clone();
        this.builder = builder;
        this.splitValue = splitValue;
        this.buildTree(exampleSet);
    }

    public ID3Model1() {
    }

    public ID3Model1(Attribute label) {
        super(label);
    }

    private void buildTree(ExampleSet exampleSet) throws UserError {
        this.numberOfExamples = exampleSet.size();
        boolean isLeaf = true;
        int i = 0;
        while (i < this.attributeMask.length) {
            isLeaf = isLeaf && this.attributeMask[i];
            ++i;
        }
        if (this.isSingleLabelExampleSet(exampleSet) || isLeaf) {
            this.isLeaf = true;
            this.label = ((Example)exampleSet.iterator().next()).getLabel();
        } else {
            Attribute splitAttribute = this.getSplitAttribute(exampleSet);
            int[] partition = this.split(exampleSet, splitAttribute);
            Collection<ExampleSet> successorSets = this.getExampleSets(exampleSet, partition);
            System.out.println(successorSets);
            System.out.flush();
            for (ExampleSet partedExampleSet : successorSets) {
                if (partedExampleSet.size() <= 0) continue;
                Example example = partedExampleSet.getExample(0);
                double splitValue = example.getValue(splitAttribute);
                this.successors.add(new ID3Model1(partedExampleSet, this.attributeMask, splitValue, this.builder));
            }
        }
    }

    private boolean isSingleLabelExampleSet(ExampleSet exampleSet) {
        boolean isSingleLabeled = true;
        Iterator iterator = exampleSet.iterator();
        Attribute labelAttribute = exampleSet.getLabel();
        double labelValue = Double.NEGATIVE_INFINITY;
        while (iterator.hasNext()) {
            if (labelValue == Double.NEGATIVE_INFINITY) {
                labelValue = ((Example)iterator.next()).getValue(labelAttribute);
                continue;
            }
            if (labelValue == ((Example)iterator.next()).getValue(labelAttribute)) continue;
            isSingleLabeled = false;
            break;
        }
        return isSingleLabeled;
    }

    protected int[] split(ExampleSet exampleSet, Attribute attribute) throws UserError {
        return this.builder.split(exampleSet, attribute);
    }

    protected Collection<ExampleSet> getExampleSets(ExampleSet exampleSet, int[] partition) {
        int[] sortedPartition = (int[])partition.clone();
        Arrays.sort(sortedPartition);
        int numberOfPartitions = sortedPartition[sortedPartition.length - 1] + 1;
        Partition splitPartition = new Partition(partition, numberOfPartitions);
        ArrayList<ExampleSet> partitions = new ArrayList<ExampleSet>(numberOfPartitions);
        int i = 0;
        while (i < numberOfPartitions) {
            SplittedExampleSet splittedSet = new SplittedExampleSet(exampleSet, (Partition)splitPartition.clone());
            splittedSet.selectSingleSubset(i);
            partitions.add((ExampleSet)splittedSet);
            ++i;
        }
        return partitions;
    }

    protected int getPartition(double value, double[] values, int foundValues) {
        int i = 0;
        while (i < foundValues) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Attribute getSplitAttribute(ExampleSet exampleSet) {
        int bestAttributeIndex = 0;
        int i = 0;
        while (i < exampleSet.getNumberOfAttributes()) {
            Attribute currentAttribute = exampleSet.getAttribute(i);
            if (currentAttribute.isNumerical()) {
                this.attributeMask[i] = true;
            } else if (!this.attributeMask[i]) {
                bestAttributeIndex = i;
                break;
            }
            ++i;
        }
        this.attributeMask[bestAttributeIndex] = true;
        this.splitAttribute = exampleSet.getAttribute(bestAttributeIndex);
        return this.splitAttribute;
    }

    protected double getInfoGain(ExampleSet exampleSet, Attribute attribute) throws UserError {
        double infoGain = this.getEntropy(exampleSet);
        Collection<ExampleSet> splittedExampleSets = this.getExampleSets(exampleSet, this.split(exampleSet, attribute));
        for (ExampleSet currentPartition : splittedExampleSets) {
            if (currentPartition.size() <= 0) continue;
            infoGain -= (double)currentPartition.size() / (double)exampleSet.size() * this.getEntropy(currentPartition);
        }
        return infoGain;
    }

    protected double getEntropy(ExampleSet exampleSet) {
        double[] classCounter = new double[exampleSet.getLabel().getNumberOfValues()];
        for (Example currentExample : exampleSet) {
            int n = (int)currentExample.getLabel();
            classCounter[n] = classCounter[n] + 1.0;
        }
        double entropy = 0.0;
        int i = 0;
        while (i < classCounter.length) {
            if (classCounter[i] > 0.0) {
                entropy -= Math.log(classCounter[i]) * classCounter[i] / this.logFactor;
            }
            ++i;
        }
        return entropy / (double)exampleSet.size() + Math.log(exampleSet.size()) / this.logFactor;
    }

    public double predict(Example example) throws OperatorException {
        if (!this.isLeaf) {
            double value = example.getValue(this.splitAttribute);
            for (ID3Model1 currentSucc : this.successors) {
                if (currentSucc.getSplitValue() != value) continue;
                return currentSucc.predict(example);
            }
            return 0.0;
        }
        return this.label;
    }

    public void readPredictionModelData(ObjectInputStream in) throws IOException {
    }

    public void writePredictionModelData(ObjectOutputStream out) throws IOException {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toString(""));
        return buffer.toString();
    }

    public String toString(String ebene) {
        StringBuffer buffer = new StringBuffer();
        if (!this.isLeaf) {
            for (ID3Model1 currentSucc : this.successors) {
                buffer.append("\n");
                buffer.append(ebene);
                buffer.append(String.valueOf(this.splitAttribute.getName()) + " = ");
                buffer.append(this.splitAttribute.getAsString(currentSucc.getSplitValue(), 0));
                buffer.append("(" + this.numberOfExamples + ")");
                buffer.append(currentSucc.toString(String.valueOf(ebene) + "|  "));
            }
        } else {
            buffer.append("  Label: " + this.label);
        }
        return buffer.toString();
    }

    public double getSplitValue() {
        return this.splitValue;
    }
}

