/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.exercise;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.exercise.ID3Builder3;
import edu.udo.cs.yale.operator.exercise.ID3Model3;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID33
extends AbstractLearner {
    public ID33(OperatorDescription description) {
        super(description);
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        String interfaceName = this.getParameterAsString("name_of_implementing_class");
        try {
            Class<?> clazz = Class.forName(interfaceName);
            ID3Builder3 builder = (ID3Builder3)clazz.newInstance();
            return new ID3Model3(exampleSet.getLabel(), exampleSet, builder);
        }
        catch (InstantiationException exception) {
            throw new UserError(null, 904, (Object)interfaceName, (Object)exception.getMessage());
        }
        catch (IllegalAccessException exception) {
            throw new UserError(null, 904, (Object)interfaceName, (Object)exception.getMessage());
        }
        catch (ClassNotFoundException exception) {
            throw new UserError(null, 904, (Object)interfaceName, (Object)exception.getMessage());
        }
    }

    public boolean supportsCapability(LearnerCapability capability) {
        if (capability == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        return capability == LearnerCapability.NUMERICAL_ATTRIBUTES;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString("name_of_implementing_class", "Fully qualified classname of the class implementing ID3Builder3", "edu.udo.cs.yale.operator.exercise.ID3ModelExercise3");
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

