package my.operatoren;

import java.util.Vector;
import my.entity.*;
import my.operatoren.Substitution;
import my.operatoren.DelDuplicate;

public class Unifikator {
	
	private static Literal uni_lit = null;
	private static boolean unifiziert = false;
	
	/**
	 * Unifiziert alle Literale in einem Vector (of Literal)<br>
	 * per 'Robinson-Algorithmus' (1965).<br>
	 * Die Methode liefert also den allgemeinsten Unifikator (als String).<br>
	 * Sollten die Literale im Vector nicht unifizierbar sein,<br>
	 * wird statt des Unifikators eine Fehlermeldung zurueckgegeben.<br> 
	 * Zusaetzlich werden statische Variablen gesetzt, die beschreiben:<br>
	 * - Das unifizierte Literal als String ( Getter: getUni_lit() )
	 * - Die Unifizierbarkeit der Literale als boolean ( Getter: isUnifiziert() )
	 * @param literale
	 * @return String
	 */
	public static String unifikation(Vector<Literal> literale) {
		
		unifiziert = false;
		String uni="";
		Literal lit1 = null;
		Literal lit2 = null;
		LiteralElement litel1 = null;
		LiteralElement litel2 = null;
		
		int neg = 0;
		
		DelDuplicate.doit(literale);
		
		// Beginn : Testen auf Negation
		
		for (int i = 0 ; i < literale.size() ; i++) {
			if (literale.get(i).isNegiert()) {neg++;}
		}
		if ((neg != 0) && (neg != literale.size())) {
			return "nicht unifizierbar ! (Literale sind nicht einheitlich positiv bzw. negativ)";
		} 
		
		// Ende : Testen auf Negation
		
		// Beginn : (erlaubte) Substitutionen bis die Menge
		// der Literale nur noch ein Literal enthaelt.
		// Bei Abbruch: Nicht unifizierbar

		while (literale.size() > 1) {
			lit1 = literale.get(0);
			lit2 = literale.get(1);
			
			if (lit1.size() != lit2.size()) {
				return "nicht unifizierbar ! (Praedikate sind nicht gleichstellig)";
			}
			else {
				for (int i = 0 ; i < lit1.size() ; i++) {
					litel1 = lit1.getElementAt(i);
					litel2 = lit2.getElementAt(i);
					
					if (!(litel1.equals(litel2))) {
						if (litel1.isFunktion() && litel2.isFunktion() && ((Funktion)litel1).getName().equals(((Funktion)litel2).getName())) {
							if (((Funktion)litel1).isGleichstellig((Funktion)litel2)) {
								String temp = new String(uni);
								uni = unifikation((Funktion)litel1, (Funktion)litel2, uni, literale);
								if (uni.contains("nicht unifizierbar")) {
									return uni;
								}
								if (!(temp.equals(uni))) {
									DelDuplicate.doit(literale);
								}
							}
							else {
								return "nicht unifizierbar ! (Funktionen \n"+((Funktion)litel1).getString()+" und \n"+((Funktion)litel2).getString()+" sind nicht gleichstellig)";
							}
						}
						else {
							if (!(litel1.isVariable() || litel2.isVariable())) {
								return "nicht unifizierbar ! (Weder "+litel1.getName()+" noch "+litel2.getName()+" ist eine Variable)";
							}
							else {
								if (litel1.isVariable()) {
									if (litel2.isFunktion() && ((Funktion)litel2).contains(litel1)) {
										return "nicht unifizierbar ! (Variable "+((Variable)litel1).getName()+" ist in Funktion "+((Funktion)litel2).getString()+" enthalten)";
									}
									else {
										if (uni.length() > 0) {uni += " ; ";}
										uni += litel1.getString()+"/"+litel2.getString();
										Substitution.doit(literale, (Variable)litel1, litel2);
										DelDuplicate.doit(literale);
									}
								}
								else {
									if (litel1.isFunktion() && ((Funktion)litel1).contains(litel2)) {
										return "nicht unifizierbar ! (Variable "+((Variable)litel2).getName()+" ist in Funktion "+((Funktion)litel1).getString()+" enthalten)";
									}
									else {
										if (uni.length() > 0) {uni += " ; ";}
										uni += litel2.getString()+"/"+litel1.getString();
										Substitution.doit(literale, (Variable)litel2, litel1);
										DelDuplicate.doit(literale);
									}
								}
							}
						}
					}
				}
			}
		}
		unifiziert = true;
		uni_lit = literale.get(0);
		return uni;
	}
	
	/**
	 * private Methode zum rekursiven Aufruf.<br>
	 * Unifiziert innerhalb von Funktionen.
	 * @param Funktion fkt1
	 * @param Funktion fkt2
	 * @param String uni
	 * @param Vector(Literal) literale
	 * @return String Substitution(en) oder Fehlermeldung
	 */
	private static String unifikation(Funktion fkt1, Funktion fkt2, String uni, Vector<Literal> literale) {
		
		LiteralElement litel1 = null;
		LiteralElement litel2 = null;
		
		for (int i = 0 ; i < fkt1.getStelligkeit() ; i++) {
			litel1 = fkt1.getElementAt(i);
			litel2 = fkt2.getElementAt(i);
			
			if (!(litel1.equals(litel2))) {
				if (litel1.isFunktion() && litel2.isFunktion() && ((Funktion)litel1).getName().equals(((Funktion)litel2).getName())) {
					if (((Funktion)litel1).isGleichstellig((Funktion)litel2)) {
						uni = unifikation((Funktion)litel1, (Funktion)litel2, uni, literale);
						if (uni.contains("nicht unifizierbar")) {
							return uni;
						}
					}
					else {
						return "nicht unifizierbar ! (Funktionen \n"+((Funktion)litel1).getString()+" und \n"+((Funktion)litel2).getString()+" sind nicht gleichstellig)";
					}
				}
				else {
					if (!(litel1.isVariable() || litel2.isVariable())) {
						return "nicht unifizierbar ! (Weder "+litel1.getName()+" noch "+litel2.getName()+" ist eine Variable)";
					}
					else {
						if (litel1.isVariable()) {
							if (litel2.isFunktion() && ((Funktion)litel2).contains(litel1)) {
								return "nicht unifizierbar ! (Variable "+((Variable)litel1).getName()+" ist in Funktion "+((Funktion)litel2).getString()+" enthalten)";
							}
							else {
								if (uni.length() > 0) {uni += " ; ";}
								uni += litel1.getString()+"/"+litel2.getString();
								Substitution.doit(literale, (Variable)litel1, litel2);
							}
						}
						else {
							if (litel1.isFunktion() && ((Funktion)litel1).contains(litel2)) {
								return "nicht unifizierbar ! (Variable "+((Variable)litel2).getName()+" ist in Funktion "+((Funktion)litel1).getString()+" enthalten)";
							}
							else {
								if (uni.length() > 0) {uni += " ; ";}
								uni += litel2.getString()+"/"+litel1.getString();
								Substitution.doit(literale, (Variable)litel2, litel1);
							}
						}
					}
				}
			}
		}
		return uni;
	}

	/**
	 * Gibt das Unifizierte Literal zurueck
	 * @return String
	 */
	public static Literal getUni_lit() {
		return uni_lit;
	}

	/**
	 * gibt an, ob die letzten Literale unifizierbar waren.
	 * @return boolean
	 */
	public static boolean isUnifiziert() {
		return unifiziert;
	}

}
