package my.operatoren;

import java.util.Collection;
import java.util.Iterator;

import my.entity.Funktion;
import my.entity.Literal;
import my.entity.LiteralElement;

public class Substitution {
	
	/**
	 * Fuehrt in einer Collection(Literal) eine Substitution durch.<br>
	 * LiteralElement 'alt' wird in allen Literalen bei jedem Vorkommen ersetzt<br>
	 * durch LiteralElement 'neu'.<br>
	 * Benutzt die equals-Methode aus LiteralElement.
	 * @param c die Collection, auf der die Substitution ausgefuehrt wird
	 * @param alt das zu ersetzende LiteralElement
	 * @param neu 
	 */
	public static void doit(Collection<Literal> c, LiteralElement alt, LiteralElement neu) {
		
		Literal aktLiteral = null;
		Iterator<Literal> it = c.iterator();
		
		while (it.hasNext()) {
			aktLiteral = it.next();
			for (int j = 0 ; j < aktLiteral.size() ; j++) {
				if (aktLiteral.getElementAt(j).isFunktion()) {
					subFkt((Funktion)aktLiteral.getElementAt(j), alt, neu);
				}
				else if (aktLiteral.getElementAt(j).equals(alt)) {
					aktLiteral.setLiteralelement(j, neu);
				}
			}
		}
	}
	
	/**
	 * private Methode zum rekursiven Aufruf.<br>
	 * Wie Methode 'doit' oben, nur fuer Funktionen.
	 * @param Funktion fkt
	 * @param LiteralElement alt
	 * @param LiteralElement neu
	 */
	private static void subFkt(Funktion fkt, LiteralElement alt, LiteralElement neu) {
		for(int i=0; i< fkt.getStelligkeit(); i++) {
			if(fkt.getElementAt(i).isFunktion()) {
				subFkt((Funktion)fkt.getElementAt(i), alt, neu);
			}
			else if (fkt.getElementAt(i).equals(alt)) {
				fkt.setInnereElemente(i, neu);
			}
		}
	}
}
