package my.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import my.control.Controller;
import my.entity.Literal;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JFileChooser;

/**
 * @author  chris
 */
public class GUI_Eingabe {

	private JFrame jFrame = null;  //  @jve:decl-index=0:visual-constraint="10,10"

	private JPanel jContentPane = null;

	private JMenuBar jJMenuBar = null;

	private JMenu fileMenu = null;

	private JMenu editMenu = null;

	private JMenu helpMenu = null;

	private JMenuItem exitMenuItem = null;

	private JMenuItem aboutMenuItem = null;

	private JMenuItem cutMenuItem = null;

	private JMenuItem copyMenuItem = null;

	private JMenuItem pasteMenuItem = null;

	private JMenuItem saveMenuItem = null;

	private JDialog aboutDialog = null;

	private JPanel aboutContentPane = null;

	private JLabel aboutVersionLabel = null;

	private JPanel panel_haupt = null;

	private JTextField textfeld_eingabe = null;

	private JLabel label_literaleingabe = null;

	private JScrollPane scrollpane_liste = null;

	private JList liste_literale = null;

	private JButton button_hinzufuegen = null;

	private JButton button_aendern = null;

	private JButton button_loeschen = null;

	private JButton button_unifikation = null;

	private JButton button_antiunifikation = null;

	private Controller controller;
	
	private DefaultListModel listmodel;
	
	private static boolean listenEingabe =false;
	
	private static boolean uni =false;
	
	private static boolean hoch = false;
	
	private JTextArea ausgabeArea = null;
	
	private JScrollPane scrollPaneAusgabeArea = null;
	
	private JButton buttonHoch = null;
	
	private static boolean ausgabeIsLiteral = false;


	/**
	 * This method initializes jFrame
	 * @return  javax.swing.JFrame
	 * @uml.property  name="jFrame"
	 */
	private JFrame getJFrame() {
		if (jFrame == null) {
			jFrame = new JFrame();
			jFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			jFrame.setResizable(true);
			jFrame.setJMenuBar(getJJMenuBar());
			jFrame.setSize(750, 400);
			jFrame.setContentPane(getJContentPane());
			jFrame.setTitle("Literal-O'Matic");
		}
		return jFrame;
	}

	/**
	 * This method initializes jContentPane
	 * @return  javax.swing.JPanel
	 * @uml.property  name="jContentPane"
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getPanel_haupt(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jJMenuBar	
	 * @return  javax.swing.JMenuBar
	 * @uml.property  name="jJMenuBar"
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.add(getFileMenu());
			jJMenuBar.add(getEditMenu());
			jJMenuBar.add(getHelpMenu());
		}
		return jJMenuBar;
	}

	/**
	 * This method initializes jMenu	
	 * @return  javax.swing.JMenu
	 * @uml.property  name="fileMenu"
	 */
	private JMenu getFileMenu() {
		if (fileMenu == null) {
			fileMenu = new JMenu();
			fileMenu.setText("Datei");
			fileMenu.add(getloadMenuItem());
			fileMenu.add(getSaveMenuItem());
			fileMenu.add(getExitMenuItem());
		}
		return fileMenu;
	}

	/**
	 * This method initializes jMenu	
	 * @return  javax.swing.JMenu
	 * @uml.property  name="editMenu"
	 */
	private JMenu getEditMenu() {
		if (editMenu == null) {
			editMenu = new JMenu();
			editMenu.setText("Bearbeiten");
			editMenu.add(getCutMenuItem());
			editMenu.add(getCopyMenuItem());
			editMenu.add(getPasteMenuItem());
		}
		return editMenu;
	}

	/**
	 * This method initializes jMenu	
	 * @return  javax.swing.JMenu
	 * @uml.property  name="helpMenu"
	 */
	private JMenu getHelpMenu() {
		if (helpMenu == null) {
			helpMenu = new JMenu();
			helpMenu.setText("Hilfe");
			helpMenu.add(getAboutMenuItem());
		}
		return helpMenu;
	}

	/**
	 * This method initializes jMenuItem	
	 * @return  javax.swing.JMenuItem
	 * @uml.property  name="exitMenuItem"
	 */
	private JMenuItem getExitMenuItem() {
		if (exitMenuItem == null) {
			exitMenuItem = new JMenuItem();
			exitMenuItem.setText("Beenden");
			exitMenuItem.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}
			});
		}
		return exitMenuItem;
	}

	/**
	 * This method initializes jMenuItem	
	 * @return  javax.swing.JMenuItem
	 * @uml.property  name="aboutMenuItem"
	 */
	private JMenuItem getAboutMenuItem() {
		if (aboutMenuItem == null) {
			aboutMenuItem = new JMenuItem();
			aboutMenuItem.setText("Ueber");
			aboutMenuItem.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					JDialog aboutDialog = getAboutDialog();
					aboutDialog.pack();
					Point loc = getJFrame().getLocation();
					loc.translate(20, 20);
					aboutDialog.setLocation(loc);
					aboutDialog.setVisible(true);
				}
			});
		}
		return aboutMenuItem;
	}

	/**
	 * This method initializes aboutDialog	
	 * @return  javax.swing.JDialog
	 * @uml.property  name="aboutDialog"
	 */
	private JDialog getAboutDialog() {
		if (aboutDialog == null) {
			aboutDialog = new JDialog(getJFrame(), true);
			aboutDialog.setTitle("Ueber");
			aboutDialog.setContentPane(getAboutContentPane());
		}
		return aboutDialog;
	}

	/**
	 * This method initializes aboutContentPane
	 * @return  javax.swing.JPanel
	 * @uml.property  name="aboutContentPane"
	 */
	private JPanel getAboutContentPane() {
		if (aboutContentPane == null) {
			aboutContentPane = new JPanel();
			aboutContentPane.setLayout(new BorderLayout());
			aboutContentPane.add(getAboutVersionLabel(), BorderLayout.CENTER);
		}
		return aboutContentPane;
	}

	/**
	 * This method initializes aboutVersionLabel	
	 * @return  javax.swing.JLabel
	 * @uml.property  name="aboutVersionLabel"
	 */
	private JLabel getAboutVersionLabel() {
		if (aboutVersionLabel == null) {
			aboutVersionLabel = new JLabel();
			aboutVersionLabel.setText("Version 1.0");
			aboutVersionLabel.setHorizontalAlignment(SwingConstants.CENTER);
		}
		return aboutVersionLabel;
	}

	/**
	 * This method initializes jMenuItem	
	 * @return  javax.swing.JMenuItem
	 * @uml.property  name="cutMenuItem"
	 */
	private JMenuItem getCutMenuItem() {
		if (cutMenuItem == null) {
			cutMenuItem = new JMenuItem();
			cutMenuItem.setText("Ausschneiden");
			cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X,
					Event.CTRL_MASK, true));
		}
		return cutMenuItem;
	}

	/**
	 * This method initializes jMenuItem	
	 * @return  javax.swing.JMenuItem
	 * @uml.property  name="copyMenuItem"
	 */
	private JMenuItem getCopyMenuItem() {
		if (copyMenuItem == null) {
			copyMenuItem = new JMenuItem();
			copyMenuItem.setText("Kopieren");
			copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C,
					Event.CTRL_MASK, true));
		}
		return copyMenuItem;
	}

	/**
	 * This method initializes jMenuItem	
	 * @return  javax.swing.JMenuItem
	 * @uml.property  name="pasteMenuItem"
	 */
	private JMenuItem getPasteMenuItem() {
		if (pasteMenuItem == null) {
			pasteMenuItem = new JMenuItem();
			pasteMenuItem.setText("Einfuegen");
			pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V,
					Event.CTRL_MASK, true));
		}
		return pasteMenuItem;
	}

	/**
	 * This method initializes jMenuItem	
	 * @return  javax.swing.JMenuItem
	 * @uml.property  name="saveMenuItem"
	 */
	private JMenuItem getSaveMenuItem() {
		if (saveMenuItem == null) {
			saveMenuItem = new JMenuItem();
			saveMenuItem.setText("Speichern");
			saveMenuItem.setEnabled(false);
			saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S,
					Event.CTRL_MASK, true));
			saveMenuItem.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					getJFileChooser();
					int return_wert = fileChooser.showSaveDialog(saveMenuItem);
					if(return_wert == JFileChooser.APPROVE_OPTION) {
							controller.speichereLiteralListe(fileChooser.getSelectedFile(), listmodel.elements());			
					}				
				}
			});
		}
		return saveMenuItem;
	}

	/**
	 * This method initializes panel_haupt	
	 * @return  javax.swing.JPanel
	 * @uml.property  name="panel_haupt"
	 */
	private JPanel getPanel_haupt() {
		
		if (panel_haupt == null) {

		 	panel_haupt = new Zeichenpanel();
			GridBagLayout layout = new GridBagLayout();
			GridBagConstraints c = new GridBagConstraints();
			c.fill = GridBagConstraints.BOTH;
			c.weighty = 0;
			c.gridwidth = GridBagConstraints.RELATIVE;
			c.insets = new Insets(7,50,7,7);
			panel_haupt.setLayout(layout);
			
			// label
			c.gridwidth = GridBagConstraints.REMAINDER;
			label_literaleingabe = new JLabel("Bitte geben Sie hier ein Literal ein:");
			layout.setConstraints(label_literaleingabe, c);
			panel_haupt.add(label_literaleingabe);
			
			// input field
			c.gridwidth = GridBagConstraints.RELATIVE;
			textfeld_eingabe = getTextfeld_eingabe();
			layout.setConstraints(textfeld_eingabe, c);
			panel_haupt.add(textfeld_eingabe);

			// hinzu button
			c.gridwidth = GridBagConstraints.REMAINDER;
			button_hinzufuegen = getButton_hinzufuegen();
			layout.setConstraints(button_hinzufuegen, c);
			panel_haupt.add(button_hinzufuegen);
			
			// label
			c.gridwidth = GridBagConstraints.REMAINDER;
			JLabel label_liste = new JLabel("Literale:");
			layout.setConstraints(label_liste, c);
			panel_haupt.add(label_liste);
			
			// literal liste
			scrollpane_liste = getScrollpane_liste();
			c.gridwidth = GridBagConstraints.RELATIVE;
			c.gridheight = 1;
			layout.setConstraints(scrollpane_liste, c);
			panel_haupt.add(scrollpane_liste);
			
			GridBagLayout buttonPanelLayout = new GridBagLayout();
			GridBagConstraints c2 = new GridBagConstraints();
			c2.fill = GridBagConstraints.BOTH;
			c2.weighty = 0;
			c2.gridwidth = GridBagConstraints.RELATIVE;
			c2.insets = new Insets(7,0,7,7);
			
			//aendern button
			JButton aendernButton = getButton_aendern();
			c2.gridwidth = GridBagConstraints.REMAINDER;
			c2.gridheight = 1;
			c2.weightx = 1.0;
			c2.anchor = GridBagConstraints.WEST;
			buttonPanelLayout.setConstraints(aendernButton, c2);
			
			// loeschen button
			JButton loeschenButton = getButton_loeschen();
			c2.gridwidth = GridBagConstraints.REMAINDER;
			c2.weightx = 1.0;
			buttonPanelLayout.setConstraints(loeschenButton, c2);
			
			// panel fuer manipulationsbuttons
			JPanel manButtPanel = new JPanel();
			manButtPanel.setLayout(buttonPanelLayout);
			c.gridwidth = GridBagConstraints.REMAINDER;
			c.gridheight = 1;
			manButtPanel.add(aendernButton);
			manButtPanel.add(loeschenButton);
			layout.setConstraints(manButtPanel, c);
			panel_haupt.add(manButtPanel);
			
			
			// textarea
			ausgabeArea = getTextarea_ausgabe();

			//scrollpane ausgabeArea
			scrollPaneAusgabeArea = new JScrollPane();
			scrollPaneAusgabeArea.setViewportView(ausgabeArea);
			c.gridwidth = GridBagConstraints.RELATIVE;
			c.gridheight = 1;
			c.weightx = 1.0;
			c.weighty = 1.0;
			layout.setConstraints(scrollPaneAusgabeArea, c);
			panel_haupt.add(scrollPaneAusgabeArea);
			c.weightx = 0.0;
			
			//ButtonHoch
			buttonHoch = new JButton("hoch");
			buttonHoch.setEnabled(false);
			buttonHoch.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					listmodel.removeAllElements();
					if(controller.getLiteralDasInDerTextBoxSteht() != null) {
						listmodel.addElement(controller.getLiteralDasInDerTextBoxSteht());
						hoch = true;
					}
					else {
						hoch = false;
					}
					ausgabeArea.setText("");
					buttonHoch.setEnabled(false);
					button_unifikation.setEnabled(false);
					button_antiunifikation.setEnabled(false);
					button_loeschen.setEnabled(false);
					textfeld_eingabe.setEnabled(true);
					textfeld_eingabe.setText("");
					panel_haupt.repaint();
				}
			});
			
			//panel fuer hoch-button
			JPanel panelHochButton = new JPanel();
			c.gridwidth = GridBagConstraints.REMAINDER;
			panelHochButton.add(buttonHoch);
			layout.setConstraints(panelHochButton, c);
			panel_haupt.add(panelHochButton);
			
			//unifikations button
			JButton unifButton = getButton_unifikation();
		
			// antiunif. button
			JButton antiunifButton = getButton_antiunifikation();
			
			//panel fuer Buttons Unifikation und Antiunifikation
			JPanel panelButtons = new JPanel();
			FlowLayout flow = new FlowLayout(FlowLayout.LEFT);
			panelButtons.setLayout(flow);
			panelButtons.add(unifButton);
			panelButtons.add(antiunifButton);
			c.gridwidth = GridBagConstraints.REMAINDER;
			layout.setConstraints(panelButtons, c);
			panel_haupt.add(panelButtons);
			c.weightx = 0.0;
			c.weighty = 0.0;
			
		}
		return panel_haupt;
	}

	/**
	 * This method initializes textfeld_eingabe	
	 * @return  javax.swing.JTextField
	 * @uml.property  name="textfeld_eingabe"
	 */
	private JTextField getTextfeld_eingabe() {
		if (textfeld_eingabe == null) {
			textfeld_eingabe = new JTextField();
			textfeld_eingabe.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					
					Literal tmp = null;
					tmp = controller.processLiteral(textfeld_eingabe.getText());	
					saveMenuItem.setEnabled(true);
					if(!(listmodel.size() <2)) {
						setFehlerMeldung("Es duerfen nicht mehr als 2 Literale eingegeben werden");
						button_hinzufuegen.setEnabled(false);
						textfeld_eingabe.setEnabled(false);
						return;
					}
					if(tmp != null) {
						listmodel.add(0, tmp);	
						saveMenuItem.setEnabled(true);
						uni= false;
						listenEingabe = true;
						textfeld_eingabe.setText("");
						setFehlerMeldung("");
					}
					
					
					button_hinzufuegen.setEnabled(false);
					if(listmodel.size() == 2) {
						button_unifikation.setEnabled(true);
						button_antiunifikation.setEnabled(true);
						textfeld_eingabe.setEnabled(false);
					}	
					ausgabeIsLiteral = false;
					buttonHoch.setEnabled(false);
					panel_haupt.repaint();
				}
			});
			textfeld_eingabe.addCaretListener(new javax.swing.event.CaretListener() {
				public void caretUpdate(javax.swing.event.CaretEvent e) {
					if(textfeld_eingabe.getText().equals("") || listmodel.size() == 2)
						button_hinzufuegen.setEnabled(false);
					else 
						button_hinzufuegen.setEnabled(true);
				}
			});
			textfeld_eingabe.addMouseListener(new MouseListener() {

				public void mouseClicked(MouseEvent e) {
					if(listmodel.size() == 2) {
						button_hinzufuegen.setEnabled(false);
					}	
				}

				public void mouseEntered(MouseEvent e) {
					
					
				}

				public void mouseExited(MouseEvent e) {
					
					
				}

				public void mousePressed(MouseEvent e) {
					
					
				}

				public void mouseReleased(MouseEvent e) {
					
					
				}
			});
		}
		return textfeld_eingabe;
	}

	/**
	 * This method initializes scrollpane_liste	
	 * @return  javax.swing.JScrollPane
	 * @uml.property  name="scrollpane_liste"
	 */
	private JScrollPane getScrollpane_liste() {
		if (scrollpane_liste == null) {
			scrollpane_liste = new JScrollPane();
			scrollpane_liste.setViewportView(getListe_literale());
		}
		return scrollpane_liste;
	}

	/**
	 * This method initializes liste_literale	
	 * @return  javax.swing.JList
	 * @uml.property  name="liste_literale"
	 */
	private JList getListe_literale() {
		if (liste_literale == null) {
			liste_literale = new JList();
			listmodel = new DefaultListModel();
			liste_literale.setModel(listmodel);
			liste_literale
					.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
						public void valueChanged(javax.swing.event.ListSelectionEvent e) {
							textfeld_eingabe.setEnabled(true);
							if(listmodel.size() >0 && liste_literale.getSelectedValue() != null) {
								textfeld_eingabe.setText(((Literal)liste_literale.getSelectedValue()).getLiteral());
								button_loeschen.setEnabled(true);
								button_aendern.setEnabled(true);
							}
							else{
								button_aendern.setEnabled(false);
							}
							if(!(listmodel.size() < 2)) {
								button_hinzufuegen.setEnabled(false);
							}
								
						}
					});
			liste_literale.addKeyListener(new java.awt.event.KeyAdapter() {
				public void keyPressed(java.awt.event.KeyEvent e) {
					if(e.getKeyCode() == KeyEvent.VK_DELETE) {
						while (liste_literale.getSelectedIndices().length > 0) {
							listmodel.removeElementAt(liste_literale.getSelectedIndices()[0]);
						}
						textfeld_eingabe.setText("");
						button_loeschen.setEnabled(false);
						if(listmodel.size() <2)
							button_unifikation.setEnabled(false);
						if(listmodel.size() ==0) {
							saveMenuItem.setEnabled(false);
						}
					}
				}
			});
		}
		return liste_literale;
	}

	/**
	 * This method initializes button_hinzufuegen	
	 * @return  javax.swing.JButton
	 * @uml.property  name="button_hinzufuegen"
	 */
	private JButton getButton_hinzufuegen() {
		if (button_hinzufuegen == null) {
			button_hinzufuegen = new JButton();
			button_hinzufuegen.setText("Hinzufuegen");
			button_hinzufuegen.setEnabled(false);
			button_hinzufuegen
					.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent e) {
							
							Literal tmp = null;
							tmp = controller.processLiteral(textfeld_eingabe.getText());	
							saveMenuItem.setEnabled(true);
							if(!(listmodel.size() <2)) {
								setFehlerMeldung("Es duerfen nicht mehr als 2 Literale eingegeben werden");
								button_hinzufuegen.setEnabled(false);
								textfeld_eingabe.setEnabled(false);
								return;
							}
							if(tmp != null) {
								listmodel.add(0, tmp);	
								saveMenuItem.setEnabled(true);
								uni= false;
								listenEingabe = true;
								textfeld_eingabe.setText("");
								setFehlerMeldung("");
							}
							
							
							button_hinzufuegen.setEnabled(false);
							if(listmodel.size() >1) {
								button_unifikation.setEnabled(true);
								button_antiunifikation.setEnabled(true);
							}
							ausgabeIsLiteral = false;
							buttonHoch.setEnabled(false);
							panel_haupt.repaint();
							
						}
					});
		}
		return button_hinzufuegen;
	}

	/**
	 * This method initializes button_bearbeiten	
	 * @return  javax.swing.JButton
	 * @uml.property  name="button_bearbeiten"
	 */
	private JButton getButton_aendern() {
		if (button_aendern == null) {
			button_aendern = new JButton();
			button_aendern.setText("Aendern");
			button_aendern.setEnabled(false);
			button_aendern
					.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent e) {
							Literal lit = controller.processLiteral(textfeld_eingabe.getText());
							if (lit != null) {
								listmodel.set(liste_literale.getSelectedIndex(),lit);
							}
							hoch = false;
							uni = false;
							listenEingabe = false;
							ausgabeArea.setText("");
							ausgabeIsLiteral = false;
							buttonHoch.setEnabled(false);
							panel_haupt.repaint();
						}
					});
		}
		return button_aendern;
	}

	/**
	 * This method initializes button_loeschen	
	 * @return  javax.swing.JButton
	 * @uml.property  name="button_loeschen"
	 */
	private JButton getButton_loeschen() {
		if (button_loeschen == null) {
			button_loeschen = new JButton();
			button_loeschen.setText("Loeschen");
			button_loeschen.setEnabled(false);
			button_loeschen.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
						while (liste_literale.getSelectedIndices().length > 0) {
							listmodel.removeElementAt(liste_literale.getSelectedIndices()[0]);
						}
						textfeld_eingabe.setText("");
						button_loeschen.setEnabled(false);
						if(listmodel.size() <2) {
							button_unifikation.setEnabled(false);
							button_antiunifikation.setEnabled(false);
							textfeld_eingabe.setEnabled(true);
						}
							
						if(listmodel.size() ==0) {
							saveMenuItem.setEnabled(false);
						}
						uni = false;
						listenEingabe = false;
						hoch = false;
						ausgabeArea.setText("");
						ausgabeIsLiteral = false;
						buttonHoch.setEnabled(false);
						panel_haupt.repaint();
				}
			});
		}
		return button_loeschen;
	}

	/**
	 * This method initializes button_unifikation	
	 * @return  javax.swing.JButton
	 * @uml.property  name="button_unifikation"
	 */
	private JButton getButton_unifikation() {
		if (button_unifikation == null) {
			button_unifikation = new JButton();
			button_unifikation.setText("Unifikation");
			button_unifikation.setEnabled(false);
			button_unifikation
					.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent e) {
							Vector<Literal> tmp = new Vector<Literal>();
							Enumeration en = listmodel.elements();
							while(en.hasMoreElements()) {
								tmp.addElement(new Literal((Literal)en.nextElement()));
							}
							controller.unifizieren(tmp);
							en = null;
							textfeld_eingabe.setEnabled(true);
							textfeld_eingabe.setText("");
							uni = true;
							listenEingabe = false;
							buttonHoch.setEnabled(true);
							panel_haupt.repaint();
						}
					});
		}
		return button_unifikation;
	}

	public DefaultListModel getListmodel() {
		return listmodel;
	}

	/**
	 * This method initializes button_antiunifikation	
	 * @return  javax.swing.JButton
	 * @uml.property  name="button_antiunifikation"
	 */
	private JButton getButton_antiunifikation() {
		if (button_antiunifikation == null) {
			button_antiunifikation = new JButton();
			button_antiunifikation.setText("Antiunifikation");
			button_antiunifikation.setEnabled(false);
			button_antiunifikation
					.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent e) {
							
							String tmp = controller.antiunifizieren();
							if(!tmp.equals("")) {
								buttonHoch.setEnabled(true);
								uni = true;
								listenEingabe = false;
							}
							else {
								buttonHoch.setEnabled(false);
								uni = false;
								listenEingabe = false;
								
							}
							setInfo(tmp);
							textfeld_eingabe.setEnabled(true);
							textfeld_eingabe.setText("");
							panel_haupt.repaint();
						}
					});
		}
		return button_antiunifikation;
	}

	/**
	 * Launches this application
	 */
	public GUI_Eingabe(Controller controller) {
		this.controller = controller;
		this.getJFrame().setVisible(true);
	}
	
	public void setFehlerMeldung(String fehlertext) {
		textarea_ausgabe.setForeground(Color.RED);
		textarea_ausgabe.setText(fehlertext);
	}
	
	public void setInfo(String text) {
		textarea_ausgabe.setForeground(Color.BLUE);
		textarea_ausgabe.setText(text);
	}

	/**
	 * @uml.property  name="controller1"
	 * @uml.associationEnd  inverse="gUI_Eingabe:my.control.Controller"
	 */
	private Controller controller1;

	private JTextArea textarea_ausgabe = null;

	private JFileChooser fileChooser = null; 

	private JMenuItem loadMenuItem = null;

	/**
	 * Getter of the property <tt>controller1</tt>
	 * @return  Returns the controller1.
	 * 
	 */
	public Controller getController1() {
		return controller1;
	}

	/**
	 * Setter of the property <tt>controller1</tt>
	 * @param controller1  The controller1 to set.
	 */
	public void setController1(Controller controller1) {
		this.controller1 = controller1;
	}

	/**
	 * This method initializes textarea_ausgabe	
	 * 	
	 * @return javax.swing.JTextArea	
	 */
	private JTextArea getTextarea_ausgabe() {
		if (textarea_ausgabe == null) {
			textarea_ausgabe = new JTextArea(4, 40);
			textarea_ausgabe.setEditable(false);
		}
		return textarea_ausgabe;
	}

	/**
	 * This method initializes jFileChooser	
	 * 	
	 * @return javax.swing.JFileChooser	
	 */
	private JFileChooser getJFileChooser() {
		if (fileChooser == null) {
			fileChooser = new JFileChooser();
			fileChooser.setAcceptAllFileFilterUsed(false);
			fileChooser.setFileFilter(new ExtensionFilter());
		}
		return fileChooser;
	}
	
	public void setListModel(Vector<Literal> liste) {
		for(int i=0; i< liste.size(); i++) {
			listmodel.addElement(liste.get(i));
		}
		
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getloadMenuItem() {
		if (loadMenuItem == null) {
			loadMenuItem = new JMenuItem();
			loadMenuItem.setText("Laden");
			loadMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_L,
					Event.CTRL_MASK, true));
			loadMenuItem.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					getJFileChooser();
					int return_wert = fileChooser.showOpenDialog(loadMenuItem);
					if(return_wert == JFileChooser.APPROVE_OPTION) {
						controller.ladeLiteralListe(fileChooser.getSelectedFile());
					}
					saveMenuItem.setEnabled(true);
					if(listmodel.size() > 1) {
						button_unifikation.setEnabled(true);
						button_antiunifikation.setEnabled(true);
					}
				}
			});
		}
		return loadMenuItem;
	}
	
	class Zeichenpanel extends JPanel {
		
		private static final long serialVersionUID = 7965723532637541607L;
		
		Image offscreenImage;
		Graphics2D offscreenGraphics;
		
		private void OffPaint() {
			
			offscreenImage    = createImage( getPanel_haupt().getWidth(), getPanel_haupt().getHeight() );
			offscreenGraphics = (Graphics2D)offscreenImage.getGraphics();
			
			
			offscreenGraphics.setRenderingHint( RenderingHints.KEY_ANTIALIASING,
                     RenderingHints.VALUE_ANTIALIAS_ON);
			offscreenGraphics.setStroke( new BasicStroke( 2, BasicStroke.CAP_BUTT  , BasicStroke.JOIN_MITER ) );
			offscreenGraphics.setColor(Color.RED);
			
			//x und y werden gesetzt, zeichendicke und farbe	
			int x = textfeld_eingabe.getX();
			int y = textfeld_eingabe.getY()+textfeld_eingabe.getHeight()/2;
			
			if(listenEingabe == true)
				offscreenGraphics.setColor(Color.GREEN);
			else
				offscreenGraphics.setColor(Color.RED);
			
			//Pfeil von Eingabefeld auf Liste		
			offscreenGraphics.drawLine(x, y, x-20, y);
			x -= 20;
			offscreenGraphics.drawLine(x, y, x, scrollpane_liste.getY()+scrollpane_liste.getHeight()/4);	
			y = scrollpane_liste.getY()+ scrollpane_liste.getHeight()/4;
			offscreenGraphics.drawLine(x, y, scrollpane_liste.getX(), y);
			x = scrollpane_liste.getX();
			offscreenGraphics.drawLine(x, y, x-5, y-5);
			offscreenGraphics.drawLine(x, y, x-5, y+5);
			
			if(uni == true)
				offscreenGraphics.setColor(Color.GREEN);
			else
				offscreenGraphics.setColor(Color.RED);
			
			//Pfeil von Liste auf AusgabeArea
			y = scrollpane_liste.getY()+(scrollpane_liste.getHeight()*3/4);
			offscreenGraphics.drawLine(x, y, x-20, y);
			x -= 20;
			offscreenGraphics.drawLine(x, y, x, scrollPaneAusgabeArea.getY()+scrollPaneAusgabeArea.getHeight()/2);
			y = scrollPaneAusgabeArea.getY()+scrollPaneAusgabeArea.getHeight()/2;
			offscreenGraphics.drawLine(x, y, scrollPaneAusgabeArea.getX(), y);
			x = scrollPaneAusgabeArea.getX();
			offscreenGraphics.drawLine(x, y, x-5, y-5);
			offscreenGraphics.drawLine(x, y, x-5, y+5);
			
			if(hoch == true)
				offscreenGraphics.setColor(Color.GREEN);
			else
				offscreenGraphics.setColor(Color.RED);
				
			//Pfeil von AusgabeArea auf Liste
			x += scrollPaneAusgabeArea.getWidth();
			offscreenGraphics.drawLine(x, y, x+20, y);
			x += 20;
			offscreenGraphics.drawLine(x, y, x, scrollpane_liste.getY()+(scrollpane_liste.getHeight()/2));
			y = scrollpane_liste.getY()+(scrollpane_liste.getHeight()/2);
			offscreenGraphics.drawLine(x, y, scrollpane_liste.getX()+scrollpane_liste.getWidth(), y);
			x = scrollpane_liste.getX()+scrollpane_liste.getWidth();
			offscreenGraphics.drawLine(x, y, x+5, y-5);
			offscreenGraphics.drawLine(x, y, x+5, y+5);	
			y = scrollpane_liste.getY()+scrollpane_liste.getHeight()-25;
			x = scrollpane_liste.getX()+scrollpane_liste.getWidth();
			
			uni = false;
			hoch = false;
			
		}
		
		
		public void paintComponent( Graphics g )
		{
			super.paintComponents(g);
			OffPaint();
			if ( offscreenImage != null )
		    g.drawImage( offscreenImage, 0, 0, this );
		}
	}

	public static boolean isAusgabeIsLiteral() {
		return ausgabeIsLiteral;
	}

	public static void setAusgabeIsLiteral(boolean ausgabeIsLiteral) {
		GUI_Eingabe.ausgabeIsLiteral = ausgabeIsLiteral;
	}    
	
	

}
