package my.gui;

import java.io.File;

public class ExtensionFilter extends javax.swing.filechooser.FileFilter {

	@Override
	public boolean accept(File f) {
		if (f.isDirectory()) {
			return true;
		    }

		    String extension = Utils.getExtension(f);
		    if (extension != null) {
				if (extension.equals(Utils.LIT)) {
				        return true;
				} 
				else {
				    return false;
				}
		    }
		return false;
	}

	@Override
	public String getDescription() {
		// TODO Auto-generated method stub
		return "*.lit";
	}
	
	static class Utils {
		
		public final static String LIT = "lit";
	    

	    /*
	     * Get the extension of a file.
	     */  
	    public static String getExtension(File f) {
	        String ext = null;
	        String s = f.getName();
	        int i = s.lastIndexOf('.');

	        if (i > 0 &&  i < s.length() - 1) {
	            ext = s.substring(i+1).toLowerCase();
	        }
	        return ext;
	    }
	}

}
