package my.entity;



public abstract class LiteralElement {
	
	
	private String name = null;
	
	
	/**
	 * Default Konstruktor
	 */
	public LiteralElement() {
		
	}
	
	/**
	 * Copy-Konstruktor<br>
	 * erzeugt ein neues Object, das gleich dem uebergebenen Object ist
	 * @param el
	 */
	public LiteralElement(LiteralElement el) {

		name = new String(el.getName());
	}
	
	/**
	 * Die Methode ueberscheibt die java.lang.Object.toString Methode<br>
	 * und ersetzt deren Ausgabe durch den Namen<br>
	 * des Literalelements<br>
	 * @return Name Literalelements vom Typ String
	 */
	public String toString() {
		return getName();
	}
	
	/**
	 * gibt das Element als String zurueck
	 * @return String
	 */
	public String getString() {
		if (this.isFunktion()) {
			return ((Funktion)this).getString();
		}
		else {
			return this.name;
		}
	}
	
	/**
	 * gibt den Elementnamen zurueck
	 * @return String
	 */
	public String getName() {
		return name;
	}

	/**
	 * setzt den Namen des Elements
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * Gibt an, ob das Element vom Typ 'Variable' ist
	 * @return boolean
	 */
	public boolean isVariable() {
		return (this instanceof Variable);
	}

	/**
	 * Gibt an, ob das Element vom Typ 'Konstante' ist
	 * @return boolean
	 */
	public boolean isKonstante() {
		return (this instanceof Konstante);
	}
	
	/**
	 * Gibt an, ob das Element vom Typ 'Funktion' ist
	 * @return boolean
	 */
	public boolean isFunktion() {
		return (this instanceof Funktion);
	}

	/**
	 * Gibt an, ob das Element vom Typ 'Praedikat' ist
	 * @return boolean
	 */
	public boolean isPraedikat() {
		return (this instanceof Praedikat);
	}
	
	/**
	 * Kopiert das Element.<br>
	 * Es wird ein neues Object erzeugt (und zurueckgegeben), das<br>
	 * ansonsten dem Element in jeder Hinsicht gleicht.<br>
	 * Benutzt die Copy-Konstruktoren der erbenden Klassen<br>
	 * Ueberschreibt die Clone-Methode in Object
	 * @return LiteralElement
	 */
	public LiteralElement clone() {
		if (this.isFunktion()) {return new Funktion((Funktion)this);}
		if (this.isKonstante()) {return new Konstante((Konstante)this);}
		if (this.isPraedikat()) {return new Praedikat((Praedikat)this);}
		else {return new Variable((Variable)this);}
	}
	
	/**
	 * Gibt an, ob das Element gleich dem uebergebenen Element ist.<br>
	 * Zwei Elemente sind gleich, falls ihre Namen und Klassen<br>
	 * gleich sind (Beachtung von Gross-/Kleinschreibung).<br>
	 * Bei Funktionen muessen zusaetzlich alle inneren Elemente<br>
	 * gleich sein (rekursiver Aufruf).<br>
	 * Ueberschreibt die equals-Methode aus Object
	 * @return boolean
	 */
	public boolean equals(Object o) {
		
		if (o.getClass().equals(this.getClass())) {
			if (!(this.isFunktion())) {
				return (this.getName().equals(((LiteralElement)o).getName()));
			}
			else {
				return (((Funktion)this).equals(o));
			}
		}
		else {
			return false;
		}
	}
}
