package my.entity;

import java.util.Vector;

public class Literal {

	/**
	 * gibt true zurueck, falls der uebergebene Buchstabe eine 'Klammer zu' ist -<br>
	 * false sonst
	 * @param c
	 * @return boolean
	 */
	public static boolean isCloseBracket(char c) {
		return c == ']' || c == ')' || c == '}';
	}
	/**
	 * Methode ueberprueft uebergebenen Buchstaben auf Grossschreibung.<br>
	 * Gibt true zurueck, wenn Buchstabe gross ist.
	 * @param c
	 * @return boolean
	 */
	public static boolean isGrossbuchstabe(char c) {
		return Character.isUpperCase(c);
	}
	
	/**
	 * gibt true zurueck, falls der uebergebene Buchstabe ein 'Komma' ist -<br>
	 * false sonst
	 * @param c
	 * @return boolean
	 */
	public static boolean isKomma(char c) {
		return c == ',';
	}
	
	/**
	 * gibt true zurueck, falls der uebergebene Buchstabe eine 'Klammer auf' ist -<br>
	 * false sonst
	 * @param c
	 * @return boolean
	 */
	public static boolean isOpenBracket(char c) {
		return c == '[' || c == '(' || c == '{';
	}
	
	private LiteralElement element = null;
	
	
	
	private Vector<LiteralElement> literal_elemente = null;

	private String literal_string = null;
	
	private boolean negiert = false;

	/**
	 * Copy-Konstruktor erzeugt ein neues Literal mit neuen Objekten<br>
	 * vom Typ LiteralElement, die gleich sind zu denen des<br>
	 * uebergebenen Literals<br>
	 * @param lit
	 */
	public Literal(Literal lit) {
		this.literal_string = new String(lit.getLiteral());
		this.literal_elemente = new Vector<LiteralElement>();
		this.negiert = lit.isNegiert();
		
		for (int i = 0 ; i < lit.size() ; i++) {
			this.literal_elemente.add(i, lit.getElementAt(i).clone());
		}
	}

	/**
	 * (Pars-)Konstruktor fuer Literal. Benoetigt ein Literal als String
	 * @param literal_string
	 */
	public Literal(String literal_string) {
		this.literal_string = literal_string;
		this.literal_elemente = new Vector<LiteralElement>();
		parseLiteral(this.literal_string);
	}
	
	/**
	 * ueberprueft, ob das uebergebene LiteralElement in dem Literal vorkommt
	 * @param literalElement
	 * @return boolean
	 */
	public boolean contains(LiteralElement literalElement) {
		for (int i = 0 ; i < this.size() ; i++) {
			if (this.getElementAt(i).equals(literalElement)) {
				return true;
			}
			if (this.getElementAt(i).isFunktion() && ((Funktion)this.getElementAt(i)).contains(literalElement)) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * Ueberschreibt equals-Methode in Object.<br>
	 * Gibt an, ob das uebergebene Literal und die Instanz gleich sind.<br>
	 * Zwei Literale sind gleich, falls folgende Kriterien gleich sind:<br>
	 * - Anzahl der Elemente<br>
	 * - Negation<br>
	 * - Saemtliche inneren Elemente<br>
	 * benutzt equals Methode aus LiteralElement
	 * @param o
	 * @return boolean
	 */
	public boolean equals(Object o) {
		if (o.getClass().equals(this.getClass())) {
			Literal lit = (Literal)o;
			if ((lit.size() == this.size()) && (this.isNegiert() == lit.isNegiert())) {
				for(int i=0; i< lit.size(); i++) {
					if (!(lit.getElementAt(i).equals(this.getElementAt(i)))) {
						return false;
					}
				}
				return true;
			}
			else {
				return false;
			}
		}
		else {
			return false;
		}
	}

	/**
	 * gibt das i-te Element vom Literal zurueck
	 * @param  i
	 * @return ein Objekt vom Typ LiteralElement
	 */
	public LiteralElement getElementAt(int i) {
		return literal_elemente.get(i);
	}
	
	/**
	 * gibt das Literal als String zurueck
	 * @return String
	 */
	public String getLiteral() {
		String literal = "";
		
		if (this.isNegiert()) {literal = "!";}
		literal += this.getElementAt(0).getString()+"("+this.getElementAt(1).getString();
		for (int i = 2 ; i < this.size() ; i++) {
			literal += ","+this.getElementAt(i).getString();
		}
		literal += ")";
		return literal;
	}
	
	/**
	 * Gibt den i-ten Buchstaben vom urspruenglich eingegebenen Literal zurueck
	 * @param i
	 * @return char
	 */
	public char  getLiteralAt(int i) {
		return literal_string.charAt(i);
	}
	
	/**
	 * gibt einen Vector(LiteralElement) mit den Literalelementen zurueck
	 * @return Vector(LiteralElement)
	 */
	public Vector<LiteralElement> getLiteralElemente() {
		return literal_elemente;
	}
	
	/**
	 * Gibt an, ob das Literal negiert ist
	 * @return boolean
	 */
	public boolean isNegiert() {
		return negiert;
	}
	
	/**
	 * Diese Methode parst ein Literal und schreibt die einzelnen<br>
	 * Elemente des Literals in einen Vector. Elemente koennen vom Typ<br>
	 * "Variable", "Konstante", "Funktion" oder "Praedikat" sein.<br>
	 * Mit is...() (Bsp. isFunktion()) in LiteralElement koennen die Typen abgefragt werden.
	 * @param literal_string
	 */ 
	public void parseLiteral(String literal_string) {
		char c = 0;
		int literal_stringLength = literal_string.length();
		int open_brackets = 0;
		int left_string_position = 0;
		int right_string_position = 0;
		
		//teste auf Negation
		c = literal_string.charAt(right_string_position);
		if(Character.toString(c).equals("!")) {
			setNegiert(true);
			left_string_position++;
		}

		for(; right_string_position< literal_stringLength; right_string_position++) {
			
			c = literal_string.charAt(right_string_position);
			
			if(isOpenBracket(c)) {
				if(isGrossbuchstabe(literal_string.charAt(right_string_position-1))) {
					element = new Praedikat();
					element.setName(literal_string.substring(left_string_position, right_string_position));
					((Praedikat)element).setInhalt(literal_string.substring(right_string_position+1, literal_stringLength-1));
					literal_elemente.add(element);
					element = null;
					if(!(right_string_position == literal_stringLength))
						left_string_position = (right_string_position+1);	
				}
				else {
					element = new Funktion();
					if(isKomma(literal_string.charAt(left_string_position))) 
						element.setName(literal_string.substring(left_string_position+1, right_string_position));	
					else
						element.setName(literal_string.substring(left_string_position, right_string_position));
					char c_tmp = 0;
					open_brackets = 1;
					
					for(int tmp = right_string_position+1;((Funktion)element).getInhalt() == ""; tmp++) {
						c_tmp = literal_string.charAt(tmp);
						if(isCloseBracket(c_tmp)) {
							open_brackets--;
							if(open_brackets == 0) {
								((Funktion)element).parseInnereElemente((Funktion)element,literal_string.substring(right_string_position+1, tmp));
								right_string_position = tmp;
							}
						}
						else if(isOpenBracket(c_tmp)) {
							open_brackets++;
						}		
					} 
					literal_elemente.add(element);
					element = null;
					if(!(right_string_position == literal_stringLength))
						left_string_position = (right_string_position+1);	
				}			
			}
			if(isKomma(c)) {
				if(isGrossbuchstabe(literal_string.charAt(right_string_position-1))) {
					element = new Konstante();
					if(isKomma(literal_string.charAt(left_string_position))) 
						element.setName(literal_string.substring(left_string_position+1, right_string_position));	
					else
						element.setName(literal_string.substring(left_string_position, right_string_position));
					literal_elemente.add(element);
					element = null;
					if(!(right_string_position == literal_stringLength))
						left_string_position = (right_string_position+1);
				}
				else if(!isGrossbuchstabe(literal_string.charAt(right_string_position-1))){
					if(!isCloseBracket(literal_string.charAt(right_string_position-1))) {
						element = new Variable();
						if(isKomma(literal_string.charAt(left_string_position))) 
							element.setName(literal_string.substring(left_string_position+1, right_string_position));	
						else
							element.setName(literal_string.substring(left_string_position, right_string_position));
						literal_elemente.add(element);
						element = null;
						if(!(right_string_position == literal_stringLength))
							left_string_position = (right_string_position+1);
					}
					else if(!(right_string_position == literal_stringLength))
						left_string_position = (right_string_position+1);
				}			
			}
			if(isCloseBracket(c)) {
				if(isGrossbuchstabe(literal_string.charAt(right_string_position-1))) {
					element = new Konstante();
					if(isKomma(literal_string.charAt(left_string_position))) 
						element.setName(literal_string.substring(left_string_position+1, right_string_position));	
					else
						element.setName(literal_string.substring(left_string_position, right_string_position));
					literal_elemente.add(element);
					element = null;
					if(!(right_string_position == literal_stringLength))
						left_string_position = (right_string_position+1);	
				}
				else if(!isCloseBracket(literal_string.charAt(right_string_position-1))) {
					element = new Variable();
					element.setName(literal_string.substring(left_string_position, right_string_position));
					literal_elemente.add(element);
					element = null;
					if(!(right_string_position == literal_stringLength)) 
						left_string_position = (right_string_position+1);	
				}
			}		
		}	
	}
	
	/**
	 * ueberschreibt den Vector der Literalelemente
	 * @param literal_elemente
	 */
	public void setLiteral_elemente(Vector<LiteralElement> literal_elemente) {
		this.literal_elemente = literal_elemente;
	}
	
	/**
	 * ueberschreibt das Literalelement an der Stelle 'index' mit dem LiteralElement 'el'
	 * @param index
	 * @param el
	 */
	public void setLiteralelement(int index, LiteralElement el) {
		literal_elemente.set(index, el);
	}
	
	/**
	 * Setzt den Wert fuer Negation
	 * @param negiert
	 */
	public void setNegiert(boolean negiert) {
		this.negiert = negiert;
	}
	
	/**
	 * Gibt die Anzahl der Literalelemente zurueck.<br>
	 * D.h. Stelligkeit des Praedikats + 1 (da Praedikat selber Literalelement)<br>
	 * Anders:<br>
	 * - Praedikat zaehlt als ein Literalelement (Position 0)<br>
	 * - Elemente auf oberster Ebene zaehlen als ein Literalelement<br>
	 * - Funktionen und Elemente innerhalb verschachtelter Funktionen werden nicht erfasst
	 * @return int
	 */
	public int size() {
		return literal_elemente.size();
	}
	
	/**
	 * Ueberschreibt die toString Methode der Klasse Object und gibt
	 * den Namen des Literals aus
	 * @return String
	 */
	public String toString() {
		return getLiteral();
	}
}
