package my.entity;


import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import my.operatoren.DelDuplicate;

public class Klausel {
	
	private Vector<Literal> klausel = null;
	
	/**
	 * Standardkonstruktor
	 */
	public Klausel() {	
		klausel = new Vector<Literal>();	
	}
	
	/**
	 * Konstuktor erzeugt neue Klausel mit uebergebener Collection von Literalen,<br>
	 * indem diese kopiert wird
	 * @param c
	 */
	public Klausel(Collection<Literal> c) {
		klausel = new Vector<Literal>();
		Iterator<Literal> ite = c.iterator();
		while(ite.hasNext()) {
			klausel.add(new Literal(ite.next()));
		}
		DelDuplicate.doit(klausel);
	}
	
	/**
	 * Fuegt ein Literal in die Klausel ein
	 * @param lit
	 */
	public void add(Literal lit) {
		if(!klausel.contains((Literal)lit));
			klausel.add(lit);
	}
	
	/**
	 * entfernt das uebergebene Literal aus der Klausel
	 * @param lit
	 */
	public void remove(Literal lit) {
		klausel.remove((Literal)lit);
	}
	
	/**
	 * Gibt das Literal an der Stelle 'index' zurueck 
	 * @param index
	 * @return Literal
	 */
	public Literal get(int index) {
		return klausel.get(index);
	}
	
	/**
	 * Gibt die Anzahl der Elemente (Literale) in der Klausel zurueck
	 * @return int
	 */
	public int size() {
		return klausel.size();
	}
	

}
