package my.entity;

import java.util.Vector;

public class Funktion extends LiteralElement {

	
	private LiteralElement element;
	private String inhalt = "";
	private Vector<LiteralElement> innere_elemente;
	
	/**
	 * Konstruktor<br>
	 * initialisiert "innere_elemente" 
	 */
	public Funktion() {
		innere_elemente = new Vector<LiteralElement>();
	}
	
	/**
	 * Copy-Konstruktor<br>
	 * erzeugt aus einer uebergebenen Funktion<br>
	 * eine neue Funktion mit neuen Objekten
	 * @param f
	 */
	public Funktion(Funktion f) {
		super(f);
		inhalt = new String(f.getInhalt());
		innere_elemente = new Vector<LiteralElement>();
		
		for (int i = 0 ; i < f.getStelligkeit() ; i++) {
			innere_elemente.add(i, f.getElementAt(i).clone());
		}
	}
	
	/**
	 * gibt an, ob das uebergebene LiteralElement in der Funktion<br>
	 * (bzw. deren Subfunktionen) enthalten ist
	 * @param el
	 * @return boolean
	 */
	public boolean contains(LiteralElement el) {
		for (int i = 0 ; i < this.innere_elemente.size() ; i++) {
			if (el.equals(this.innere_elemente.get(i))) {
				return true;
			}
			if (this.innere_elemente.get(i).isFunktion() && ((Funktion)this.innere_elemente.get(i)).contains(el)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Ueberschreibt die equals-Methode aus LiteralElement.<br>
	 * Eine Funktion ist gleich einer zweiten, falls<br>
	 * Gleichheit in folgenden Punkten gilt:<br>
	 * - Funktionsnamen<br>
	 * - Stelligkeiten<br>
	 * - Elemente (Ueberpruefung durch LiteralElement.equals)
	 * @param o
	 * @return boolean
	 */
	public boolean equals(Object o) {
		if ((o.getClass().equals(this.getClass()))) {
			Funktion fkt = (Funktion)o;
			if ((fkt.getName().equals(this.getName())) && (fkt.isGleichstellig(this))) {
				for (int i = 0 ; i < this.getStelligkeit() ; i++) {
					if (!(this.getElementAt(i).equals(fkt.getElementAt(i)))) {
						return false;
					}
				}
				return true;
			}
			else {
				return false;
			}
		}
		else {
			return false;
		}
	}
	/**
	 * gibt das i-te Element der Funktion zurueck
	 * @param  i
	 * @return ein Objekt vom Typ LiteralElement
	 */
	public LiteralElement getElementAt(int i) {
		return innere_elemente.get(i);
	}
	
	/**
	 * gibt die komplette Funktion als String zurueck<br>
	 * Beispiel: f(x,y)
	 * @return String 
	 */
	public String getFunktion() {
		return (this.getName() + "(" + this.getInhalt() + ")");
	}
	/**
	 * gibt ausschliesslich den Inhalt einer Funktion als String zurueck<br>
	 * Mehrere Elemente werden mit Komma getrennt<br>
	 * Beispiel: x,y
	 * @return String
	 */
	public String getInhalt() {
		return inhalt;
	}

	/**
	 * Gibt die Stelligkeit (Anzahl der Elemente) der Funktion zurueck
	 * @return int
	 */
	public int getStelligkeit() {
		return innere_elemente.size();
	}
	
	/**
	 * Ueberprueft ob zwei Funktionen die Gleiche Stelligkeit besitzen
	 * @param fkt
	 * @return boolean
	 */
	public boolean isGleichstellig(Funktion fkt) {
		return (this.getStelligkeit() == fkt.getStelligkeit());
	}
	
	/**
	 * Diese rekursive Methode parst alle Elemente einer Funktion und schreibt sie
	 * in einen Vector. Funktionselemente koennen vom Typ<br>
	 * "Variable", "Konstante" oder "Funktion" sein.
	 * @param fkt die zu parsende Funktion
	 * @param string_innere_elemente die inneren Elemente der Funktion in Form eines Strings
	 * @return int
	 */ 
	public int parseInnereElemente(Funktion fkt,String string_innere_elemente) {
		char c = 0;
		LiteralElement inner_element = element;
		int literal_stringLength = string_innere_elemente.length();
		int open_brackets = 0;
		int left_string_position = 0;
		int right_string_position = 0;
		
		for(; right_string_position< literal_stringLength; right_string_position++) {
			
			c = string_innere_elemente.charAt(right_string_position);
			
			if(Literal.isOpenBracket(c)) {
				inner_element = new Funktion();
				if(Literal.isKomma(string_innere_elemente.charAt(left_string_position))) 
					inner_element.setName(string_innere_elemente.substring(left_string_position+1, right_string_position));	
				else
					inner_element.setName(string_innere_elemente.substring(left_string_position, right_string_position));
				char c_tmp = 0;
				open_brackets = 1;
				for(int tmp = right_string_position+1; right_string_position != tmp+1; tmp++) {
					c_tmp = string_innere_elemente.charAt(tmp);
					if(Literal.isCloseBracket(c_tmp)) {
						open_brackets--;
						if(open_brackets == 0) {
							right_string_position = parseInnereElemente((Funktion)inner_element,string_innere_elemente.substring(right_string_position+1, tmp))+1;
							right_string_position = tmp+1; 
							break;
						}
					}
					else if(Literal.isOpenBracket(c_tmp)) {
						open_brackets++;
					}		
				}
				fkt.innere_elemente.add(inner_element);
				fkt.setInhalt(inner_element);
				inner_element = null;
				if(!(right_string_position == literal_stringLength))
					left_string_position = (right_string_position+1);						
			}
			if(Literal.isKomma(c)) {
				if(Literal.isGrossbuchstabe(string_innere_elemente.charAt(right_string_position-1))) {
					inner_element = new Konstante();
					if(Literal.isKomma(string_innere_elemente.charAt(left_string_position))) 
						inner_element.setName(string_innere_elemente.substring(left_string_position+1, right_string_position));	
					else
						inner_element.setName(string_innere_elemente.substring(left_string_position, right_string_position));
					fkt.innere_elemente.add(inner_element);
					fkt.setInhalt(inner_element);
					element = null;
					if(!(right_string_position == literal_stringLength))
						left_string_position = (right_string_position+1);
				}
				else if(!Literal.isGrossbuchstabe(string_innere_elemente.charAt(right_string_position-1)) && !Literal.isCloseBracket(string_innere_elemente.charAt(right_string_position-1))){
					inner_element = new Variable();
					inner_element.setName(string_innere_elemente.substring(left_string_position, right_string_position));
					fkt.innere_elemente.add(inner_element);
					fkt.setInhalt(inner_element);
					inner_element = null;
					if(!(right_string_position == literal_stringLength))
						left_string_position = (right_string_position+1);	
				}			
			}
			if(Literal.isCloseBracket(c) && string_innere_elemente != "") {
				if(Literal.isGrossbuchstabe(string_innere_elemente.charAt(right_string_position-1))) {
					inner_element = new Konstante();
					if(Literal.isKomma(string_innere_elemente.charAt(left_string_position))) 
						inner_element.setName(string_innere_elemente.substring(left_string_position+1, right_string_position));	
					else
						inner_element.setName(string_innere_elemente.substring(left_string_position, right_string_position));
					fkt.innere_elemente.add(inner_element);
					fkt.setInhalt(inner_element);
					inner_element = null;
					if(!(right_string_position == literal_stringLength))
						left_string_position = (right_string_position+1);	
				}
				else {
					inner_element = new Variable();
					inner_element.setName(string_innere_elemente.substring(left_string_position, right_string_position));
					fkt.innere_elemente.add(inner_element);
					fkt.setInhalt(inner_element);
					inner_element = null;
					if(!(right_string_position == literal_stringLength)) 
						left_string_position = (right_string_position+1);	
				}
			}	
			if(right_string_position+1 == literal_stringLength) {
				if(Literal.isGrossbuchstabe(string_innere_elemente.charAt(right_string_position))) {
					inner_element = new Konstante();
					if(Literal.isKomma(string_innere_elemente.charAt(left_string_position))) 
						inner_element.setName(string_innere_elemente.substring(left_string_position+1, right_string_position));	
					else
						inner_element.setName(string_innere_elemente.substring(left_string_position, right_string_position+1));
					fkt.innere_elemente.add(inner_element);
					fkt.setInhalt(inner_element);
					inner_element = null;	
				}
				else {
					inner_element = new Variable();
					inner_element.setName(string_innere_elemente.substring(left_string_position, right_string_position+1));
					fkt.innere_elemente.add(inner_element);
					fkt.setInhalt(inner_element);
					inner_element = null;	
				}
			}
		}
		return  right_string_position;
	}
	
	/**
	 * just testing
	 * @param fkt
	 * @return inhalt
	 */
	public String schreibeInhalte(Funktion fkt) {
		String inhalt = "";
		Vector<LiteralElement> elemente = fkt.innere_elemente;
		for(int i=0; i < elemente.size(); i++) {
			if(elemente.get(i) instanceof Funktion) {
				inhalt += schreibeInhalte((Funktion)elemente.get(i));
				
			}
		}
		inhalt += fkt.getFunktion() + "\n";
		return inhalt;
	}
	
	/**
	 * speichert den Namen eines Funktionselementes im String<br>
	 * "inhalt" ab 
	 * @param e
	 */
	private void setInhalt(LiteralElement e) {
		if(inhalt.length() !=0)
			inhalt += "," + e;
		else
			inhalt += e;
	}
	
	/**
	 * Ueberschreibt in der Funktion ein Element an der<br>
	 * uebergebenen Stelle 'index' mit dem uebergebenen<br>
	 * Element 'el'  
	 * @param index
	 * @param el
	 */
	public void setInnereElemente(int index, LiteralElement el) {
		innere_elemente.set(index, el);
	}
	
	/**
	 * Gibt die Funktion mit ihren aktuellen Elementen als String zurueck
	 * @return String
	 */
	public String getString() {
		String fkt = "";
		fkt += this.getName()+"(";
		for(int i = 0 ; i < this.getStelligkeit() ; i++) {
			if(i != this.getStelligkeit()-1) 
				fkt += this.getElementAt(i).getString()+",";
			else
				fkt += this.getElementAt(i).getString();		
		}
		fkt += ")";
		return fkt;
	}
}
