package my.control;
import java.util.regex.*;


public class SyntaxChecker {

	public boolean checksyntax(String literal_string, Controller controller) {
		 
		 
		 //Regex-Ausdruecke fuer die Form [!]PRAEDIKATENNAME(Element1,Element2,...,Elementn)
		 Pattern p = Pattern.compile(	"[!]{0,1}[A-Z]+" +	//gross geschriebener Praedikatenname und optionale Negierung "!"
		 								"\\x28"+
		 								".*"); 
		
		 Matcher m = p.matcher(literal_string);
		 boolean b = m.matches();
		 if (b==false){
			 controller.setFehlerMeldung(	"Syntax-Error:" +
			 								"\nPraedikatenname muss komplett gross geschrieben werden." +
			 								"\n! ist optional fuer Verneinung.");
			 return false;
		 }
		 
		 p=null;
		
		 p = Pattern.compile(	"[!]{0,1}[A-Z]+" +	//Praedikatenname und optionale Negierung "!"
		 								"\\x28" +					//erste Klammer auf
		 								"[A-Za-z][A-Za-z0-9()]*(,[A-Za-z][A-Za-z0-9()]*)*" +
		 															//Einzelne Elemente durch Kommas getrennt
		 								"\\x29");					//letzte Klammer zu
		
		 m = p.matcher(literal_string);
		 b = m.matches();
		 if (b==false){
			 controller.setFehlerMeldung(	"Syntax-Error:" +
			 								"\nDas Praedikat hat nicht die Form !PRAEDIKATENNAME(Element1,Element2,...,Elementn)" +
			 								"\n! ist optional fuer Verneinung." +
			 								"\nElemente 1 bis n sind beliebig entweder Konstante, Variable oder Funktion.");
		 }
		 
		 /**Folgende for-Schleife zaehlt u.a., ob die Klammeranzahl korrekt ist. (Variabel z)
		  * Korrekte Syntax wird dadurch ueberprueft, dass nach bestimmten Zeichen, wie
		  * Klammer auf oder zu oder Komma nur bestimmte Zeichen folgen koennen.
		  * Zusammen mit dem Regex-Ausdruck, dem Klammerzaehlen erreicht man so den
		  * korrekten Check der Syntax.
		  */ 
		 int z=0;
		 int h=0;
		 
		 for(int i=0;i<literal_string.length();i++){
			 if (literal_string.charAt(i)=='(') {
				 if(z>=1){	//Folgende if/for-Schleife ueberprueft, ob der Funktionsname klein geschrieben ist
					 for(h=i-1;literal_string.charAt(h)!='('&&literal_string.charAt(h)!=',';h--){
						 if(Character.isUpperCase(literal_string.charAt(h))){
							 controller.setFehlerMeldung(
										"Syntax-Error:"+
								 		"\nFunktionsname muss klein geschrieben werden!");
								 return false;
						 }
					 }
				 }
				 z++;
				 if(i<(literal_string.length()-1)){
					 if (literal_string.charAt(i+1)=='('||
						 literal_string.charAt(i+1)==')'||
						 literal_string.charAt(i+1)==','||
						 Character.getType(literal_string.charAt(i+1))==9){
						 controller.setFehlerMeldung(
								"Syntax-Error an Position "+i+"."+
						 		"\nNach '(' kann nicht '"+literal_string.charAt(i+1)+"' folgen!");
						 return false;
					 }
					 
				 }
			 }
			 if (literal_string.charAt(i)==')'){
				 z--;
				 if(z==0&&!(i==literal_string.length()-1)){
					 controller.setFehlerMeldung(	"Syntax-Error: " +
					 								"\nEnde erwarte nach Position "+i+".");
					 return false;
				 }
				 
				 
				 
				 if(i<(literal_string.length()-1)){
					 if (literal_string.charAt(i+1)!=','&&
						 literal_string.charAt(i+1)!=')'){
						 controller.setFehlerMeldung(
									"Syntax-Error an Position "+i+"."+
							 		"\nNach ')' kann nicht '"+literal_string.charAt(i+1)+"' folgen!");
						 return false;
					 } 
					 
				 }
			 }
			 if (literal_string.charAt(i)==','){
				 if(i<(literal_string.length()-1)){
					 if (literal_string.charAt(i+1)=='('||
						 literal_string.charAt(i+1)==')'||
						 literal_string.charAt(i+1)==','||
						 Character.getType(literal_string.charAt(i+1))==9) {
						 controller.setFehlerMeldung(
									"Syntax-Error an Position "+i+"."+
							 		"\nNach ',' kann nicht '"+literal_string.charAt(i+1)+"' folgen!");
						 return false;	 
					 }
					 
				 }
			 }
			 
		 }
		 if(z!=0){
			 controller.setFehlerMeldung("Syntax-Error: Klammeranzahl nicht korrekt!");
			 b=false;
		 }
		 
		return b;
	}
}
